/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.github.Organization;
import com.jcabi.github.PublicMembers;
import com.jcabi.github.User;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import com.jcabi.xml.XML;
import java.io.IOException;
import org.xembly.Directive;
import org.xembly.Directives;

public final class MkPublicMembers
implements PublicMembers {
    private final transient MkStorage storage;
    private final transient Organization organization;

    public MkPublicMembers(MkStorage stg, Organization organ) {
        this.storage = stg;
        this.organization = organ;
    }

    @Override
    public Organization org() {
        return this.organization;
    }

    @Override
    public void conceal(User user) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath(user)).set((Object)"false"));
    }

    @Override
    public void publicize(User user) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath(user)).set((Object)"true"));
    }

    @Override
    public Iterable<User> iterate() {
        return new MkIterable<User>(this.storage, String.format("%s/member[public='true']/login", this.xpath()), new MkIterable.Mapping<User>(){

            @Override
            public User map(XML xml) {
                try {
                    return new MkUser(MkPublicMembers.this.storage, (String)xml.xpath("text()").get(0));
                }
                catch (IOException exc) {
                    throw new IllegalStateException(exc);
                }
            }
        });
    }

    @Override
    public boolean contains(User user) throws IOException {
        boolean result = false;
        for (User member : this.iterate()) {
            if (!member.equals(user)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String xpath(User user) throws IOException {
        return String.format("%s/member[login='%s']/public", this.xpath(), user.login());
    }

    private String xpath() {
        return String.format("/github/orgs/org[login='%s']/members", this.organization.login());
    }
}

