/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.github.GhPagination;
import com.jcabi.github.JsonReadable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import javax.json.JsonObject;

public final class Bulk<T extends JsonReadable>
implements Iterable<T> {
    private final transient Iterable<T> origin;

    public Bulk(Iterable<T> items) {
        if (items instanceof GhPagination) {
            GhPagination page = (GhPagination)GhPagination.class.cast(items);
            final GhPagination.Mapping mapping = page.mapping();
            this.origin = new GhPagination(page.request(), new GhPagination.Mapping<T>(){

                @Override
                public T map(final JsonObject object) {
                    final JsonReadable item = (JsonReadable)mapping.map(object);
                    return (JsonReadable)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), item.getClass().getInterfaces(), new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) {
                            Object result;
                            if ("json".equals(method.getName())) {
                                result = object;
                            } else {
                                try {
                                    result = method.invoke((Object)item, args);
                                }
                                catch (IllegalAccessException ex) {
                                    throw new IllegalStateException(ex);
                                }
                                catch (InvocationTargetException ex) {
                                    throw new IllegalStateException(ex);
                                }
                            }
                            return result;
                        }
                    });
                }
            });
        } else {
            this.origin = items;
        }
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.origin.iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bulk)) {
            return false;
        }
        Bulk other = (Bulk)o;
        Iterable<T> this$origin = this.origin;
        Iterable<T> other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Iterable<T> $origin = this.origin;
        result = result * 31 + ($origin == null ? 0 : $origin.hashCode());
        return result;
    }
}

