/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamo.mock;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.jcabi.dynamo.Region;
import com.jcabi.log.Logger;
import java.util.concurrent.TimeUnit;

public final class MadeTable {
    private final transient Region region;
    private final transient CreateTableRequest request;

    public MadeTable(Region reg, CreateTableRequest req) {
        this.region = reg;
        this.request = req;
    }

    public void createIfAbsent() throws InterruptedException {
        if (!this.exists()) {
            this.create();
        }
    }

    public void create() throws InterruptedException {
        DescribeTableResult result;
        AmazonDynamoDB aws = this.region.aws();
        String name = this.request.getTableName();
        aws.createTable(this.request);
        Logger.info((Object)this, (String)"DynamoDB table '%s' creation requested...", (Object[])new Object[]{name});
        DescribeTableRequest req = new DescribeTableRequest().withTableName(name);
        while (true) {
            if ("ACTIVE".equals((result = aws.describeTable(req)).getTable().getTableStatus())) break;
            TimeUnit.SECONDS.sleep(10L);
            Logger.info((Object)this, (String)"waiting for DynamoDB table '%s': %s", (Object[])new Object[]{name, result.getTable().getTableStatus()});
        }
        Logger.info((Object)this, (String)"DynamoDB table '%s' is %s", (Object[])new Object[]{name, result.getTable().getTableStatus()});
    }

    public void drop() throws InterruptedException {
        AmazonDynamoDB aws = this.region.aws();
        String name = this.request.getTableName();
        aws.deleteTable(new DeleteTableRequest().withTableName(name));
        Logger.info((Object)this, (String)"DynamoDB table '%s' deletion requested", (Object[])new Object[]{name});
        while (this.exists()) {
            Logger.info((Object)this, (String)"DynamoDB table '%s' still exists", (Object[])new Object[]{name});
            TimeUnit.SECONDS.sleep(10L);
        }
        Logger.info((Object)this, (String)"DynamoDB table '%s' deleted", (Object[])new Object[]{name});
    }

    public boolean exists() {
        boolean exists;
        AmazonDynamoDB aws = this.region.aws();
        String name = this.request.getTableName();
        try {
            aws.listTables(new ListTablesRequest().withExclusiveStartTableName(name).withLimit(Integer.valueOf(1)));
            exists = true;
            Logger.info((Object)this, (String)"DynamoDB table '%s' already exists", (Object[])new Object[]{name});
        }
        catch (ResourceNotFoundException ex) {
            exists = false;
            Logger.info((Object)this, (String)"DynamoDB table '%s' doesn't exist", (Object[])new Object[]{name});
        }
        return exists;
    }
}

