/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aether;

import com.jcabi.aether.RepositorySystemBuilder;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.filter.DependencyFilterUtils;

public final class Aether {
    private final transient MavenProject project;
    private final transient String localRepo;

    public Aether(MavenProject prj, String repo) {
        this.project = prj;
        this.localRepo = repo;
    }

    public List<Artifact> resolve(Artifact root, String scope) {
        CollectRequest crq = new CollectRequest();
        crq.setRoot(new Dependency(root, scope));
        for (RemoteRepository repo : this.project.getRemoteProjectRepositories()) {
            crq.addRepository(repo);
        }
        RepositorySystem system = new RepositorySystemBuilder().build();
        DependencyFilter filter = DependencyFilterUtils.classpathFilter((String[])new String[]{scope});
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository local = new LocalRepository(this.localRepo);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(local));
        LinkedList<Artifact> deps = new LinkedList<Artifact>();
        if (filter != null && system != null) {
            List results;
            try {
                results = system.resolveDependencies((RepositorySystemSession)session, new DependencyRequest(crq, filter)).getArtifactResults();
            }
            catch (DependencyResolutionException ex) {
                throw new IllegalStateException(ex);
            }
            for (ArtifactResult res : results) {
                deps.add(res.getArtifact());
            }
        }
        return deps;
    }
}

