/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.path.xml.config;

import com.jayway.restassured.mapper.factory.DefaultJAXBObjectMapperFactory;
import com.jayway.restassured.mapper.factory.JAXBObjectMapperFactory;
import com.jayway.restassured.path.xml.config.XmlParserType;
import com.jayway.restassured.path.xml.mapping.XmlPathObjectDeserializer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlPathConfig {
    private final XmlPathObjectDeserializer defaultDeserializer;
    private final JAXBObjectMapperFactory jaxbObjectMapperFactory;
    private final XmlParserType defaultParserType;
    private final String charset;
    private final Map<String, Boolean> features;
    private final Map<String, String> declaredNamespaces;

    public XmlPathConfig(XmlPathConfig config) {
        this(config.jaxbObjectMapperFactory(), config.defaultParserType(), config.defaultDeserializer(), config.charset(), new HashMap<String, Boolean>(), new HashMap<String, String>());
    }

    public XmlPathConfig() {
        this(new DefaultJAXBObjectMapperFactory(), null, null, XmlPathConfig.defaultCharset(), new HashMap<String, Boolean>(), new HashMap<String, String>());
    }

    public XmlPathConfig(String defaultCharset) {
        this(new DefaultJAXBObjectMapperFactory(), null, null, defaultCharset, new HashMap<String, Boolean>(), new HashMap<String, String>());
    }

    private XmlPathConfig(JAXBObjectMapperFactory jaxbObjectMapperFactory, XmlParserType defaultParserType, XmlPathObjectDeserializer defaultDeserializer, String charset, Map<String, Boolean> features, Map<String, String> declaredNamespaces) {
        charset = StringUtils.trimToNull((String)charset);
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be empty");
        }
        this.charset = charset;
        this.defaultDeserializer = defaultDeserializer;
        this.defaultParserType = defaultParserType;
        this.jaxbObjectMapperFactory = jaxbObjectMapperFactory;
        this.features = features;
        this.declaredNamespaces = declaredNamespaces;
    }

    private static String defaultCharset() {
        return Charset.defaultCharset().name();
    }

    public Map<String, Boolean> features() {
        return new HashMap<String, Boolean>(this.features);
    }

    public XmlPathConfig features(Map<String, Boolean> features) {
        Validate.notNull(features, (String)"Features cannot be null", (Object[])new Object[0]);
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, this.charset, features, this.declaredNamespaces);
    }

    public XmlPathConfig feature(String uri, boolean enabled) {
        Validate.notEmpty((CharSequence)uri, (String)"URI cannot be empty", (Object[])new Object[0]);
        HashMap<String, Boolean> newFeatures = new HashMap<String, Boolean>(this.features);
        newFeatures.put(uri, enabled);
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, this.charset, newFeatures, this.declaredNamespaces);
    }

    public XmlPathConfig disableLoadingOfExternalDtd() {
        HashMap<String, Boolean> newFeatures = new HashMap<String, Boolean>(this.features);
        newFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        newFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", false);
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, this.charset, newFeatures, this.declaredNamespaces);
    }

    public String charset() {
        return this.charset;
    }

    public XmlPathConfig charset(String charset) {
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, charset, this.features, this.declaredNamespaces);
    }

    public XmlParserType defaultParserType() {
        return this.defaultParserType;
    }

    public boolean hasDefaultParserType() {
        return this.defaultParserType != null;
    }

    public boolean hasCustomJaxbObjectMapperFactory() {
        return this.jaxbObjectMapperFactory() != null && this.jaxbObjectMapperFactory().getClass() != DefaultJAXBObjectMapperFactory.class;
    }

    public XmlPathObjectDeserializer defaultDeserializer() {
        return this.defaultDeserializer;
    }

    public boolean hasDefaultDeserializer() {
        return this.defaultDeserializer != null;
    }

    public XmlPathConfig defaultParserType(XmlParserType defaultParserType) {
        return new XmlPathConfig(this.jaxbObjectMapperFactory, defaultParserType, this.defaultDeserializer, this.charset, this.features, this.declaredNamespaces);
    }

    public XmlPathConfig defaultObjectDeserializer(XmlPathObjectDeserializer defaultObjectDeserializer) {
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, defaultObjectDeserializer, this.charset, this.features, this.declaredNamespaces);
    }

    public JAXBObjectMapperFactory jaxbObjectMapperFactory() {
        return this.jaxbObjectMapperFactory;
    }

    public Map<String, String> declaredNamespaces() {
        return new HashMap<String, String>(this.declaredNamespaces);
    }

    public XmlPathConfig declareNamespaces(Map<String, String> namespacesToDeclare) {
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, this.charset, this.features, namespacesToDeclare);
    }

    public XmlPathConfig declaredNamespace(String prefix, String namespaceURI) {
        Validate.notEmpty((CharSequence)prefix, (String)"Prefix cannot be empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)namespaceURI, (String)"Namespace URI cannot be empty", (Object[])new Object[0]);
        HashMap<String, String> updatedNamespaces = new HashMap<String, String>(this.declaredNamespaces);
        updatedNamespaces.put(prefix, namespaceURI);
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, this.charset, this.features, updatedNamespaces);
    }

    public XmlPathConfig jaxbObjectMapperFactory(JAXBObjectMapperFactory jaxbObjectMapperFactory) {
        return new XmlPathConfig(jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, this.charset, this.features, this.declaredNamespaces);
    }

    public boolean hasDeclaredNamespaces() {
        return !this.declaredNamespaces.isEmpty();
    }

    public XmlPathConfig with() {
        return this;
    }

    public XmlPathConfig and() {
        return this;
    }

    public static XmlPathConfig xmlPathConfig() {
        return new XmlPathConfig();
    }
}

