/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.path.xml.config;

import com.jayway.restassured.mapper.factory.DefaultJAXBObjectMapperFactory;
import com.jayway.restassured.mapper.factory.JAXBObjectMapperFactory;
import com.jayway.restassured.path.xml.config.XmlParserType;
import com.jayway.restassured.path.xml.mapping.XmlPathObjectDeserializer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public class XmlPathConfig {
    private final XmlPathObjectDeserializer defaultDeserializer;
    private final JAXBObjectMapperFactory jaxbObjectMapperFactory;
    private final XmlParserType defaultParserType;
    private final String charset;

    public XmlPathConfig(XmlPathConfig config) {
        this(config.jaxbObjectMapperFactory(), config.defaultParserType(), config.defaultDeserializer(), config.charset());
    }

    public XmlPathConfig() {
        this(new DefaultJAXBObjectMapperFactory(), null, null, XmlPathConfig.defaultCharset());
    }

    public XmlPathConfig(String defaultCharset) {
        this(new DefaultJAXBObjectMapperFactory(), null, null, defaultCharset);
    }

    private XmlPathConfig(JAXBObjectMapperFactory jaxbObjectMapperFactory, XmlParserType defaultParserType, XmlPathObjectDeserializer defaultDeserializer, String charset) {
        charset = StringUtils.trimToNull((String)charset);
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be empty");
        }
        this.charset = charset;
        this.defaultDeserializer = defaultDeserializer;
        this.defaultParserType = defaultParserType;
        this.jaxbObjectMapperFactory = jaxbObjectMapperFactory;
    }

    private static String defaultCharset() {
        return Charset.defaultCharset().name();
    }

    public String charset() {
        return this.charset;
    }

    public XmlPathConfig charset(String charset) {
        return new XmlPathConfig();
    }

    public XmlParserType defaultParserType() {
        return this.defaultParserType;
    }

    public boolean hasDefaultParserType() {
        return this.defaultParserType != null;
    }

    public boolean hasCustomJaxbObjectMapperFactory() {
        return this.jaxbObjectMapperFactory() != null && this.jaxbObjectMapperFactory().getClass() != DefaultJAXBObjectMapperFactory.class;
    }

    public XmlPathObjectDeserializer defaultDeserializer() {
        return this.defaultDeserializer;
    }

    public boolean hasDefaultDeserializer() {
        return this.defaultDeserializer != null;
    }

    public XmlPathConfig defaultParserType(XmlParserType defaultParserType) {
        return new XmlPathConfig(this.jaxbObjectMapperFactory, defaultParserType, this.defaultDeserializer, this.charset);
    }

    public XmlPathConfig defaultObjectDeserializer(XmlPathObjectDeserializer defaultObjectDeserializer) {
        return new XmlPathConfig(this.jaxbObjectMapperFactory, this.defaultParserType, defaultObjectDeserializer, this.charset);
    }

    public JAXBObjectMapperFactory jaxbObjectMapperFactory() {
        return this.jaxbObjectMapperFactory;
    }

    public XmlPathConfig jaxbObjectMapperFactory(JAXBObjectMapperFactory jaxbObjectMapperFactory) {
        return new XmlPathConfig(jaxbObjectMapperFactory, this.defaultParserType, this.defaultDeserializer, this.charset);
    }

    public static XmlPathConfig xmlPathConfig() {
        return new XmlPathConfig();
    }
}

