/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.internal;

import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.HeaderConfig;
import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.filter.log.RequestLoggingFilter;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.MapCreator;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.internal.http.CharsetExtractor;
import com.jayway.restassured.internal.log.LogRepository;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.internal.mapping.ObjectMapperSerializationContextImpl;
import com.jayway.restassured.internal.mapping.ObjectMapping;
import com.jayway.restassured.internal.serialization.SerializationSupport;
import com.jayway.restassured.internal.support.ParameterUpdater;
import com.jayway.restassured.mapper.ObjectMapper;
import com.jayway.restassured.mapper.ObjectMapperSerializationContext;
import com.jayway.restassured.module.mockmvc.config.AsyncConfig;
import com.jayway.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import com.jayway.restassured.module.mockmvc.intercept.MockHttpServletRequestBuilderInterceptor;
import com.jayway.restassured.module.mockmvc.internal.ConfigConverter;
import com.jayway.restassured.module.mockmvc.internal.MockMvcFactory;
import com.jayway.restassured.module.mockmvc.internal.MockMvcMultiPart;
import com.jayway.restassured.module.mockmvc.internal.MockMvcRequestLogSpecificationImpl;
import com.jayway.restassured.module.mockmvc.internal.MockMvcRequestSenderImpl;
import com.jayway.restassured.module.mockmvc.internal.SpringSecurityClassPathChecker;
import com.jayway.restassured.module.mockmvc.internal.UpdateStrategyConverter;
import com.jayway.restassured.module.mockmvc.response.MockMvcResponse;
import com.jayway.restassured.module.mockmvc.specification.MockMvcAuthenticationScheme;
import com.jayway.restassured.module.mockmvc.specification.MockMvcAuthenticationSpecification;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestAsyncSender;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestLogSpecification;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestSpecification;
import com.jayway.restassured.response.Cookie;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Headers;
import com.jayway.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMvcRequestSpecificationImpl
implements MockMvcRequestSpecification,
MockMvcAuthenticationSpecification {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String ACCEPT = "Accept";
    private LogRepository logRepository;
    private MockMvcFactory mockMvcFactory;
    private String basePath;
    private final ResponseSpecification responseSpecification;
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();
    private final Map<String, Object> queryParams = new LinkedHashMap<String, Object>();
    private final Map<String, Object> formParams = new LinkedHashMap<String, Object>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private Object requestBody = null;
    private RestAssuredMockMvcConfig cfg;
    private Headers requestHeaders = new Headers(new Header[0]);
    private Cookies cookies = new Cookies(new Cookie[0]);
    private List<MockMvcMultiPart> multiParts = new ArrayList<MockMvcMultiPart>();
    private RequestLoggingFilter requestLoggingFilter;
    private final ParameterUpdater parameterUpdater = new ParameterUpdater(new ParameterUpdater.Serializer(){

        public String serializeIfNeeded(Object value) {
            return MockMvcRequestSpecificationImpl.this.serializeIfNeeded(value);
        }
    });
    private final List<ResultHandler> resultHandlers = new ArrayList<ResultHandler>();
    private final List<RequestPostProcessor> requestPostProcessors = new ArrayList<RequestPostProcessor>();
    private MockHttpServletRequestBuilderInterceptor interceptor;
    private Object authentication;
    private AsyncConfig asyncConfig;

    public MockMvcRequestSpecificationImpl(MockMvcFactory mockMvcFactory, RestAssuredMockMvcConfig config, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, String basePath, MockMvcRequestSpecification requestSpecification, ResponseSpecification responseSpecification, MockMvcAuthenticationScheme authentication) {
        this.logRepository = new LogRepository();
        this.mockMvcFactory = mockMvcFactory == null ? new MockMvcFactory() : mockMvcFactory;
        this.basePath = basePath;
        this.responseSpecification = responseSpecification;
        this.assignConfig(config);
        if (resultHandlers != null) {
            this.resultHandlers.addAll(resultHandlers);
        }
        if (requestPostProcessors != null) {
            this.requestPostProcessors.addAll(requestPostProcessors);
        }
        if (requestSpecification != null) {
            this.spec(requestSpecification);
        }
        if (authentication != null) {
            authentication.authenticate(this);
        }
    }

    @Override
    public MockMvcRequestSpecification mockMvc(MockMvc mockMvc) {
        AssertParameter.notNull((Object)mockMvc, MockMvc.class);
        return this.changeMockMvcFactoryTo(new MockMvcFactory(mockMvc));
    }

    @Override
    public MockMvcRequestSpecification standaloneSetup(Object ... controllers) {
        return this.changeMockMvcFactoryTo(new MockMvcFactory((MockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])controllers)));
    }

    @Override
    public MockMvcRequestSpecification standaloneSetup(MockMvcBuilder builder) {
        AssertParameter.notNull((Object)builder, MockMvcBuilder.class);
        return this.changeMockMvcFactoryTo(new MockMvcFactory(builder));
    }

    @Override
    public MockMvcRequestSpecification webAppContextSetup(WebApplicationContext context, MockMvcConfigurer ... mockMvcConfigurers) {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup((WebApplicationContext)context);
        if (mockMvcConfigurers != null && mockMvcConfigurers.length > 0) {
            for (MockMvcConfigurer mockMvcConfigurer : mockMvcConfigurers) {
                builder.apply(mockMvcConfigurer);
            }
        }
        return this.changeMockMvcFactoryTo(new MockMvcFactory((MockMvcBuilder)builder));
    }

    @Override
    public MockMvcRequestSpecification interceptor(MockHttpServletRequestBuilderInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    @Override
    public MockMvcRequestSpecification and() {
        return this;
    }

    @Override
    public MockMvcRequestSpecification postProcessors(RequestPostProcessor postProcessor, RequestPostProcessor ... additionalPostProcessors) {
        AssertParameter.notNull((Object)postProcessor, RequestPostProcessor.class);
        this.requestPostProcessors.add(postProcessor);
        if (additionalPostProcessors != null && additionalPostProcessors.length >= 1) {
            Collections.addAll(this.requestPostProcessors, additionalPostProcessors);
        }
        return this;
    }

    @Override
    public MockMvcAuthenticationSpecification auth() {
        return this;
    }

    @Override
    public MockMvcRequestSpecification contentType(ContentType contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(CONTENT_TYPE, contentType.toString(), new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification contentType(String contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(CONTENT_TYPE, contentType, new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification accept(ContentType contentType) {
        AssertParameter.notNull((Object)contentType, (String)"contentType");
        return this.header(ACCEPT, contentType.getAcceptHeader(), new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification accept(String mediaTypes) {
        AssertParameter.notNull((Object)mediaTypes, (String)"mediaTypes");
        return this.header(ACCEPT, mediaTypes, new Object[0]);
    }

    @Override
    public MockMvcRequestSpecification headers(String firstHeaderName, Object firstHeaderValue, Object ... headerNameValuePairs) {
        return this.headers(MapCreator.createMapFromParams((String)firstHeaderName, (Object)firstHeaderValue, (Object[])headerNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification headers(Map<String, ?> headers) {
        AssertParameter.notNull(headers, (String)"headers");
        ArrayList<Header> headerList = new ArrayList<Header>();
        if (this.requestHeaders.exist()) {
            for (Header requestHeader : this.requestHeaders) {
                headerList.add(requestHeader);
            }
        }
        for (Map.Entry<String, ?> stringEntry : headers.entrySet()) {
            headerList.add(new Header(stringEntry.getKey(), this.serializeIfNeeded(stringEntry.getValue())));
        }
        this.requestHeaders = new Headers(headerList);
        return this;
    }

    @Override
    public MockMvcRequestSpecification headers(Headers headers) {
        AssertParameter.notNull((Object)headers, (String)"Headers");
        if (headers.exist()) {
            ArrayList<Header> headerList = new ArrayList<Header>();
            if (this.requestHeaders.exist()) {
                for (Header requestHeader : this.requestHeaders) {
                    headerList.add(requestHeader);
                }
            }
            for (Header requestHeader : headers) {
                headerList.add(requestHeader);
            }
            this.requestHeaders = new Headers(this.removeMergedHeadersIfNeeded(headerList));
        }
        return this;
    }

    private List<Header> removeMergedHeadersIfNeeded(List<Header> headerList) {
        HeaderConfig headerConfig = this.cfg.getHeaderConfig();
        ArrayList<Header> filteredList = new ArrayList<Header>();
        for (Header header : headerList) {
            String headerName = header.getName();
            if (headerConfig.shouldOverwriteHeaderWithName(headerName)) {
                int index = -1;
                for (int i = 0; i < filteredList.size(); ++i) {
                    Header filteredHeader = (Header)filteredList.get(i);
                    if (!filteredHeader.hasSameNameAs(header)) continue;
                    index = i;
                    break;
                }
                if (index != -1) {
                    filteredList.remove(index);
                }
            }
            filteredList.add(header);
        }
        return filteredList;
    }

    @Override
    public MockMvcRequestSpecification header(final String headerName, final Object headerValue, Object ... additionalHeaderValues) {
        AssertParameter.notNull((Object)headerName, (String)"Header name");
        AssertParameter.notNull((Object)headerValue, (String)"Header value");
        ArrayList<Header> headerList = new ArrayList<Header>(){
            {
                this.add(new Header(headerName, MockMvcRequestSpecificationImpl.this.serializeIfNeeded(headerValue)));
            }
        };
        if (additionalHeaderValues != null) {
            for (Object additionalHeaderValue : additionalHeaderValues) {
                headerList.add(new Header(headerName, this.serializeIfNeeded(additionalHeaderValue)));
            }
        }
        return this.headers(new Headers((List)headerList));
    }

    @Override
    public MockMvcRequestSpecification header(Header header) {
        AssertParameter.notNull((Object)header, (String)"Header");
        return this.headers(new Headers(Collections.singletonList(header)));
    }

    @Override
    public MockMvcRequestLogSpecification log() {
        return new MockMvcRequestLogSpecificationImpl(this);
    }

    @Override
    public MockMvcRequestSpecification params(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.params(MapCreator.createMapFromParams((String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification params(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().requestParamsUpdateStrategy()), parametersMap, this.params);
        return this;
    }

    @Override
    public MockMvcRequestSpecification param(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().requestParamsUpdateStrategy()), this.params, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification param(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(UpdateStrategyConverter.convert(this.cfg.getParamConfig().requestParamsUpdateStrategy()), this.params, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification queryParams(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.queryParams(MapCreator.createMapFromParams((String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification queryParams(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().queryParamsUpdateStrategy()), parametersMap, this.queryParams);
        return this;
    }

    @Override
    public MockMvcRequestSpecification queryParam(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().queryParamsUpdateStrategy()), this.queryParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification queryParam(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(UpdateStrategyConverter.convert(this.cfg.getParamConfig().queryParamsUpdateStrategy()), this.queryParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification formParams(String firstParameterName, Object firstParameterValue, Object ... parameterNameValuePairs) {
        AssertParameter.notNull((Object)firstParameterName, (String)"firstParameterName");
        AssertParameter.notNull((Object)firstParameterValue, (String)"firstParameterValue");
        return this.formParams(MapCreator.createMapFromParams((String)firstParameterName, (Object)firstParameterValue, (Object[])parameterNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification formParams(Map<String, ?> parametersMap) {
        AssertParameter.notNull(parametersMap, (String)"parametersMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().formParamsUpdateStrategy()), parametersMap, this.formParams);
        return this;
    }

    @Override
    public MockMvcRequestSpecification formParam(String parameterName, Object ... parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().formParamsUpdateStrategy()), this.formParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification formParam(String parameterName, Collection<?> parameterValues) {
        AssertParameter.notNull((Object)parameterName, (String)"parameterName");
        AssertParameter.notNull(parameterValues, (String)"parameterValues");
        this.parameterUpdater.updateCollectionParameter(UpdateStrategyConverter.convert(this.cfg.getParamConfig().formParamsUpdateStrategy()), this.formParams, parameterName, parameterValues);
        return this;
    }

    @Override
    public MockMvcRequestSpecification attribute(String attributeName, Object attributeValue) {
        AssertParameter.notNull((Object)attributeName, (String)"attributeName");
        AssertParameter.notNull((Object)attributeValue, (String)"attributeValue");
        this.parameterUpdater.updateZeroToManyParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().attributeUpdateStrategy()), this.attributes, attributeName, new Object[]{attributeValue});
        return this;
    }

    @Override
    public MockMvcRequestSpecification attributes(Map<String, ?> attributesMap) {
        AssertParameter.notNull(attributesMap, (String)"attributesMap");
        this.parameterUpdater.updateParameters(UpdateStrategyConverter.convert(this.cfg.getParamConfig().attributeUpdateStrategy()), attributesMap, this.attributes);
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(String body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(byte[] body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(File body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(Object object) {
        AssertParameter.notNull((Object)object, (String)"object");
        if (!SerializationSupport.isSerializableCandidate((Object)object)) {
            return this.body(object.toString());
        }
        String requestContentType = this.getRequestContentType();
        this.requestBody = ObjectMapping.serialize((Object)object, (String)requestContentType, (String)this.findEncoderCharsetOrReturnDefault(requestContentType), null, (ObjectMapperConfig)this.cfg.getObjectMapperConfig(), (EncoderConfig)this.cfg.getEncoderConfig());
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(Object object, ObjectMapper mapper) {
        AssertParameter.notNull((Object)object, (String)"object");
        AssertParameter.notNull((Object)mapper, (String)"Object mapper");
        String requestContentType = this.getRequestContentType();
        ObjectMapperSerializationContextImpl ctx = new ObjectMapperSerializationContextImpl();
        ctx.setObject(object);
        ctx.setCharset((Object)this.findEncoderCharsetOrReturnDefault(requestContentType));
        ctx.setContentType((Object)requestContentType);
        this.requestBody = mapper.serialize((ObjectMapperSerializationContext)ctx);
        return this;
    }

    @Override
    public MockMvcRequestSpecification body(Object object, ObjectMapperType mapperType) {
        AssertParameter.notNull((Object)object, (String)"object");
        AssertParameter.notNull((Object)mapperType, (String)"Object mapper type");
        String requestContentType = this.getRequestContentType();
        this.requestBody = ObjectMapping.serialize((Object)object, (String)requestContentType, (String)this.findEncoderCharsetOrReturnDefault(requestContentType), (ObjectMapperType)mapperType, (ObjectMapperConfig)this.cfg.getObjectMapperConfig(), (EncoderConfig)this.cfg.getEncoderConfig());
        return this;
    }

    @Override
    public MockMvcRequestSpecification cookies(String firstCookieName, Object firstCookieValue, Object ... cookieNameValuePairs) {
        return this.cookies(MapCreator.createMapFromParams((String)firstCookieName, (Object)firstCookieValue, (Object[])cookieNameValuePairs));
    }

    @Override
    public MockMvcRequestSpecification cookies(Map<String, ?> cookies) {
        AssertParameter.notNull(cookies, (String)"cookies");
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        if (this.cookies.exist()) {
            for (Cookie requestCookie : this.cookies) {
                cookieList.add(requestCookie);
            }
        }
        for (Map.Entry<String, ?> stringEntry : cookies.entrySet()) {
            cookieList.add(new Cookie.Builder(stringEntry.getKey(), this.serializeIfNeeded(stringEntry.getValue())).build());
        }
        this.cookies = new Cookies(cookieList);
        return this;
    }

    @Override
    public MockMvcRequestSpecification cookies(Cookies cookies) {
        AssertParameter.notNull((Object)cookies, (String)"Cookies");
        if (cookies.exist()) {
            ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
            if (this.cookies.exist()) {
                for (Cookie cookie : this.cookies) {
                    cookieList.add(cookie);
                }
            }
            for (Cookie cookie : cookies) {
                cookieList.add(cookie);
            }
            this.cookies = new Cookies(cookieList);
        }
        return this;
    }

    @Override
    public MockMvcRequestSpecification cookie(final String cookieName, final Object cookieValue, Object ... additionalValues) {
        AssertParameter.notNull((Object)cookieName, (String)"Cookie name");
        AssertParameter.notNull((Object)cookieValue, (String)"Cookie value");
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>(){
            {
                this.add(new Cookie.Builder(cookieName, MockMvcRequestSpecificationImpl.this.serializeIfNeeded(cookieValue)).build());
            }
        };
        if (additionalValues != null) {
            for (Object additionalCookieValue : additionalValues) {
                cookieList.add(new Cookie.Builder(cookieName, this.serializeIfNeeded(additionalCookieValue)).build());
            }
        }
        return this.cookies(new Cookies((List)cookieList));
    }

    @Override
    public MockMvcRequestSpecification cookie(Cookie cookie) {
        AssertParameter.notNull((Object)cookie, (String)"Cookie");
        return this.cookies(new Cookies(Collections.singletonList(cookie)));
    }

    @Override
    public MockMvcRequestSpecification multiPart(File file) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), file));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, File file) {
        this.multiParts.add(new MockMvcMultiPart(controlName, file));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, File file, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, file, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, Object object) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, this.serializeIfNeeded(object)));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, Object object, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, this.serializeIfNeeded(object, mimeType), mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String filename, Object object, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, filename, (Object)this.serializeIfNeeded(object, mimeType), mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, byte[] bytes) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, bytes));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, byte[] bytes, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, bytes, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, InputStream stream) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, stream));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String fileName, InputStream stream, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(controlName, fileName, stream, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String contentBody) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, contentBody));
        return this;
    }

    @Override
    public MockMvcRequestSpecification multiPart(String controlName, String contentBody, String mimeType) {
        this.multiParts.add(new MockMvcMultiPart(this.cfg.getMultiPartConfig(), controlName, contentBody, mimeType));
        return this;
    }

    @Override
    public MockMvcRequestSpecification config(RestAssuredMockMvcConfig config) {
        this.assignConfig(config);
        return this;
    }

    @Override
    public MockMvcRequestSpecification spec(MockMvcRequestSpecification requestSpecificationToMerge) {
        AsyncConfig otherAsyncConfig;
        Object otherAuth;
        MockMvcFactory otherMockMvcFactory;
        AssertParameter.notNull((Object)requestSpecificationToMerge, MockMvcRequestSpecification.class);
        if (!(requestSpecificationToMerge instanceof MockMvcRequestSpecificationImpl)) {
            throw new IllegalArgumentException("requestSpecificationToMerge must be an instance of " + MockMvcRequestSpecificationImpl.class.getName());
        }
        MockMvcRequestSpecificationImpl that = (MockMvcRequestSpecificationImpl)requestSpecificationToMerge;
        Object otherRequestBody = that.getRequestBody();
        if (otherRequestBody != null) {
            this.requestBody = otherRequestBody;
        }
        if (StringUtils.isNotEmpty((CharSequence)that.getBasePath())) {
            this.basePath = that.getBasePath();
        }
        if ((otherMockMvcFactory = that.getMockMvcFactory()) != null && otherMockMvcFactory.isAssigned()) {
            this.changeMockMvcFactoryTo(otherMockMvcFactory);
        }
        this.cookies(that.getCookies());
        this.headers(that.getRequestHeaders());
        MockMvcRequestSpecificationImpl.mergeConfig(this, that);
        MockHttpServletRequestBuilderInterceptor otherInterceptor = that.getInterceptor();
        if (otherInterceptor != null) {
            this.interceptor = otherInterceptor;
        }
        this.formParams(that.getFormParams());
        this.queryParams(that.getQueryParams());
        this.params(that.getParams());
        this.attributes(that.getAttributes());
        this.multiParts.addAll(that.getMultiParts());
        this.resultHandlers.addAll(that.getResultHandlers());
        this.requestPostProcessors.addAll(that.getRequestPostProcessors());
        RequestLoggingFilter otherRequestLoggingFilter = that.getRequestLoggingFilter();
        if (otherRequestLoggingFilter != null) {
            this.requestLoggingFilter = otherRequestLoggingFilter;
        }
        if ((otherAuth = that.getAuthentication()) != null) {
            this.authentication = otherAuth;
        }
        if ((otherAsyncConfig = that.getAsyncConfig()) != null) {
            this.asyncConfig = otherAsyncConfig;
        }
        return this;
    }

    private static void mergeConfig(MockMvcRequestSpecificationImpl thisOne, MockMvcRequestSpecificationImpl other) {
        RestAssuredMockMvcConfig thisConfig = thisOne.getRestAssuredMockMvcConfig();
        RestAssuredMockMvcConfig otherConfig = other.getRestAssuredMockMvcConfig();
        boolean thisIsUserConfigured = thisConfig.isUserConfigured();
        boolean otherIsUserConfigured = otherConfig.isUserConfigured();
        if (thisIsUserConfigured && otherIsUserConfigured) {
            if (otherConfig.getDecoderConfig().isUserConfigured()) {
                thisConfig = thisConfig.decoderConfig(otherConfig.getDecoderConfig());
            }
            if (otherConfig.getEncoderConfig().isUserConfigured()) {
                thisConfig = thisConfig.encoderConfig(otherConfig.getEncoderConfig());
            }
            if (otherConfig.getHeaderConfig().isUserConfigured()) {
                thisConfig = thisConfig.headerConfig(otherConfig.getHeaderConfig());
            }
            if (otherConfig.getJsonConfig().isUserConfigured()) {
                thisConfig = thisConfig.jsonConfig(otherConfig.getJsonConfig());
            }
            if (otherConfig.getLogConfig().isUserConfigured()) {
                thisConfig = thisConfig.logConfig(otherConfig.getLogConfig());
            }
            if (otherConfig.getObjectMapperConfig().isUserConfigured()) {
                thisConfig = thisConfig.objectMapperConfig(otherConfig.getObjectMapperConfig());
            }
            if (otherConfig.getSessionConfig().isUserConfigured()) {
                thisConfig = thisConfig.sessionConfig(otherConfig.getSessionConfig());
            }
            if (otherConfig.getXmlConfig().isUserConfigured()) {
                thisConfig = thisConfig.xmlConfig(otherConfig.getXmlConfig());
            }
            if (otherConfig.getAsyncConfig().isUserConfigured()) {
                thisConfig = thisConfig.asyncConfig(otherConfig.getAsyncConfig());
            }
            if (otherConfig.getMultiPartConfig().isUserConfigured()) {
                thisConfig = thisConfig.multiPartConfig(otherConfig.getMultiPartConfig());
            }
            if (otherConfig.getMockMvcConfig().isUserConfigured()) {
                thisConfig = thisConfig.mockMvcConfig(otherConfig.getMockMvcConfig());
            }
            if (otherConfig.getParamConfig().isUserConfigured()) {
                thisConfig = thisConfig.paramConfig(otherConfig.getParamConfig());
            }
            thisOne.config(thisConfig);
        } else if (!thisIsUserConfigured && otherIsUserConfigured) {
            thisOne.config(otherConfig);
        }
    }

    @Override
    public MockMvcRequestSpecification sessionId(String sessionIdValue) {
        return this.sessionId(this.cfg.getSessionConfig().sessionIdName(), sessionIdValue);
    }

    @Override
    public MockMvcRequestSpecification sessionId(String sessionIdName, String sessionIdValue) {
        AssertParameter.notNull((Object)sessionIdName, (String)"Session id name");
        AssertParameter.notNull((Object)sessionIdValue, (String)"Session id value");
        if (this.cookies.hasCookieWithName(sessionIdName)) {
            ArrayList<Cookie> allOtherCookies = new ArrayList<Cookie>();
            for (Cookie cookie : this.cookies) {
                if (cookie.getName().equalsIgnoreCase(sessionIdName)) continue;
                allOtherCookies.add(cookie);
            }
            allOtherCookies.add(new Cookie.Builder(sessionIdName, sessionIdValue).build());
            this.cookies = new Cookies(allOtherCookies);
        } else {
            this.cookie(sessionIdName, sessionIdValue, new Object[0]);
        }
        return this;
    }

    @Override
    public MockMvcRequestSpecification resultHandlers(ResultHandler resultHandler, ResultHandler ... resultHandlers) {
        AssertParameter.notNull((Object)resultHandler, ResultHandler.class);
        this.resultHandlers.add(resultHandler);
        if (resultHandlers != null && resultHandlers.length >= 1) {
            Collections.addAll(this.resultHandlers, resultHandlers);
        }
        return this;
    }

    @Override
    public MockMvcRequestAsyncSender when() {
        LogConfig logConfig = this.cfg.getLogConfig();
        if (this.requestLoggingFilter == null && logConfig.isLoggingOfRequestAndResponseIfValidationFailsEnabled()) {
            this.log().ifValidationFails(logConfig.logDetailOfRequestAndResponseIfValidationFails(), logConfig.isPrettyPrintingEnabled());
        }
        MockMvc mockMvc = this.mockMvcFactory.build(this.cfg.getMockMvcConfig());
        return new MockMvcRequestSenderImpl(mockMvc, this.params, this.queryParams, this.formParams, this.attributes, this.cfg, this.requestBody, this.requestHeaders, this.cookies, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository);
    }

    private String findEncoderCharsetOrReturnDefault(String contentType) {
        String charset = CharsetExtractor.getCharsetFromContentType((String)contentType);
        if (charset == null) {
            EncoderConfig encoderConfig = this.cfg.getEncoderConfig();
            charset = encoderConfig.hasDefaultCharsetForContentType(contentType) ? encoderConfig.defaultCharsetForContentType(contentType) : encoderConfig.defaultContentCharset();
        }
        return charset;
    }

    private String serializeIfNeeded(Object object) {
        return this.serializeIfNeeded(object, this.getRequestContentType());
    }

    private String serializeIfNeeded(Object object, String contentType) {
        return SerializationSupport.isSerializableCandidate((Object)object) ? ObjectMapping.serialize((Object)object, (String)contentType, (String)this.findEncoderCharsetOrReturnDefault(contentType), null, (ObjectMapperConfig)this.cfg.getObjectMapperConfig(), (EncoderConfig)this.cfg.getEncoderConfig()) : object.toString();
    }

    public MockMvcResponse get(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().get(path, pathParams);
    }

    public MockMvcResponse get(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().get(path, pathParams);
    }

    public MockMvcResponse post(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().post(path, pathParams);
    }

    public MockMvcResponse post(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().post(path, pathParams);
    }

    public MockMvcResponse put(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().put(path, pathParams);
    }

    public MockMvcResponse put(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().put(path, pathParams);
    }

    public MockMvcResponse delete(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().delete(path, pathParams);
    }

    public MockMvcResponse delete(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().delete(path, pathParams);
    }

    public MockMvcResponse head(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().head(path, pathParams);
    }

    public MockMvcResponse head(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().head(path, pathParams);
    }

    public MockMvcResponse patch(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().patch(path, pathParams);
    }

    public MockMvcResponse patch(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().patch(path, pathParams);
    }

    public MockMvcResponse options(String path, Object ... pathParams) {
        return (MockMvcResponse)this.when().options(path, pathParams);
    }

    public MockMvcResponse options(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)this.when().options(path, pathParams);
    }

    public MockMvcResponse get(URI uri) {
        return (MockMvcResponse)this.when().get(uri);
    }

    public MockMvcResponse post(URI uri) {
        return (MockMvcResponse)this.when().post(uri);
    }

    public MockMvcResponse put(URI uri) {
        return (MockMvcResponse)this.when().put(uri);
    }

    public MockMvcResponse delete(URI uri) {
        return (MockMvcResponse)this.when().delete(uri);
    }

    public MockMvcResponse head(URI uri) {
        return (MockMvcResponse)this.when().head(uri);
    }

    public MockMvcResponse patch(URI uri) {
        return (MockMvcResponse)this.when().patch(uri);
    }

    public MockMvcResponse options(URI uri) {
        return (MockMvcResponse)this.when().options(uri);
    }

    public MockMvcResponse get(URL url) {
        return (MockMvcResponse)this.when().get(url);
    }

    public MockMvcResponse post(URL url) {
        return (MockMvcResponse)this.when().post(url);
    }

    public MockMvcResponse put(URL url) {
        return (MockMvcResponse)this.when().put(url);
    }

    public MockMvcResponse delete(URL url) {
        return (MockMvcResponse)this.when().delete(url);
    }

    public MockMvcResponse head(URL url) {
        return (MockMvcResponse)this.when().head(url);
    }

    public MockMvcResponse patch(URL url) {
        return (MockMvcResponse)this.when().patch(url);
    }

    public MockMvcResponse options(URL url) {
        return (MockMvcResponse)this.when().options(url);
    }

    public MockMvcResponse get() {
        return (MockMvcResponse)this.when().get();
    }

    public MockMvcResponse post() {
        return (MockMvcResponse)this.when().post();
    }

    public MockMvcResponse put() {
        return (MockMvcResponse)this.when().put();
    }

    public MockMvcResponse delete() {
        return (MockMvcResponse)this.when().delete();
    }

    public MockMvcResponse head() {
        return (MockMvcResponse)this.when().head();
    }

    public MockMvcResponse patch() {
        return (MockMvcResponse)this.when().patch();
    }

    public MockMvcResponse options() {
        return (MockMvcResponse)this.when().options();
    }

    public RestAssuredConfig getRestAssuredConfig() {
        return ConfigConverter.convertToRestAssuredConfig(this.cfg);
    }

    public void setRequestLoggingFilter(RequestLoggingFilter requestLoggingFilter) {
        this.requestLoggingFilter = requestLoggingFilter;
    }

    private MockMvcRequestSpecification changeMockMvcFactoryTo(MockMvcFactory mockMvcFactory) {
        this.mockMvcFactory = mockMvcFactory;
        return this;
    }

    private void assignConfig(RestAssuredMockMvcConfig config) {
        this.cfg = config == null ? new RestAssuredMockMvcConfig() : config;
    }

    public MockMvcFactory getMockMvcFactory() {
        return this.mockMvcFactory;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Object> getFormParams() {
        return this.formParams;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Object getAuthentication() {
        return this.authentication;
    }

    public RestAssuredMockMvcConfig getRestAssuredMockMvcConfig() {
        return this.cfg;
    }

    public Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public String getRequestContentType() {
        Header header = this.requestHeaders.get(CONTENT_TYPE);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public List<MockMvcMultiPart> getMultiParts() {
        return this.multiParts;
    }

    public RequestLoggingFilter getRequestLoggingFilter() {
        return this.requestLoggingFilter;
    }

    public List<ResultHandler> getResultHandlers() {
        return this.resultHandlers;
    }

    public List<RequestPostProcessor> getRequestPostProcessors() {
        return this.requestPostProcessors;
    }

    public MockHttpServletRequestBuilderInterceptor getInterceptor() {
        return this.interceptor;
    }

    public MockMvcRequestSpecification basePath(String path) {
        AssertParameter.notNull((Object)path, (String)"Base path");
        this.basePath = path;
        return this;
    }

    @Override
    public MockMvcRequestSpecification principal(Principal principal) {
        AssertParameter.notNull((Object)principal, Principal.class);
        this.authentication = principal;
        return this;
    }

    @Override
    public MockMvcRequestSpecification with(RequestPostProcessor requestPostProcessor, RequestPostProcessor ... additionalRequestPostProcessor) {
        AssertParameter.notNull((Object)requestPostProcessor, RequestPostProcessor.class);
        this.authentication = null;
        this.requestPostProcessors.add(requestPostProcessor);
        if (additionalRequestPostProcessor != null && additionalRequestPostProcessor.length != 0) {
            this.requestPostProcessors.addAll(Arrays.asList(additionalRequestPostProcessor));
        }
        return this;
    }

    @Override
    public MockMvcRequestSpecification principal(Object principal) {
        return this.principalWithCredentials(principal, "", new String[0]);
    }

    @Override
    public MockMvcRequestSpecification principalWithCredentials(Object principal, Object credentials, String ... authorities) {
        return this.authentication(new TestingAuthenticationToken(principal, credentials, authorities));
    }

    @Override
    public MockMvcRequestSpecification authentication(Object authentication) {
        if (!SpringSecurityClassPathChecker.isSpringSecurityInClasspath()) {
            throw new IllegalArgumentException("Cannot use this authentication method since Spring Security was not found in classpath.");
        }
        AssertParameter.notNull((Object)authentication, Authentication.class);
        if (!(authentication instanceof Authentication)) {
            throw new IllegalArgumentException("authentication object must be an instance of " + Authentication.class.getName());
        }
        this.authentication = authentication;
        return this;
    }

    @Override
    public MockMvcRequestSpecification none() {
        this.authentication = null;
        return this;
    }

    public LogRepository getLogRepository() {
        return this.logRepository;
    }

    public AsyncConfig getAsyncConfig() {
        return this.asyncConfig;
    }
}

