/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.internal;

import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.internal.ResponseParserRegistrar;
import com.jayway.restassured.internal.ValidatableResponseOptionsImpl;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.internal.log.LogRepository;
import com.jayway.restassured.internal.util.SafeExceptionRethrower;
import com.jayway.restassured.module.mockmvc.internal.ResponseConverter;
import com.jayway.restassured.module.mockmvc.response.MockMvcResponse;
import com.jayway.restassured.module.mockmvc.response.ValidatableMockMvcResponse;
import com.jayway.restassured.response.ExtractableResponse;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatableMockMvcResponseImpl
extends ValidatableResponseOptionsImpl<ValidatableMockMvcResponse, MockMvcResponse>
implements ValidatableMockMvcResponse {
    private final ResultActions resultActions;
    private final MockMvcResponse mockMvcResponse;

    public ValidatableMockMvcResponseImpl(ResultActions resultActions, String contentType, ResponseParserRegistrar rpr, RestAssuredConfig config, MockMvcResponse response, ExtractableResponse<MockMvcResponse> extractableResponse, LogRepository logRepository) {
        super(contentType, rpr, config, ResponseConverter.toStandardResponse(response), extractableResponse, logRepository);
        this.mockMvcResponse = response;
        AssertParameter.notNull((Object)resultActions, ResultActions.class);
        this.resultActions = resultActions;
    }

    @Override
    public ValidatableMockMvcResponse expect(ResultMatcher resultMatcher) {
        AssertParameter.notNull((Object)resultMatcher, ResultMatcher.class);
        try {
            this.resultActions.andExpect(resultMatcher);
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        return this;
    }

    @Override
    public ValidatableMockMvcResponse assertThat(ResultMatcher resultMatcher) {
        return this.expect(resultMatcher);
    }

    public MockMvcResponse originalResponse() {
        return this.mockMvcResponse;
    }
}

