/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.assertion.AssertParameter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.protocol.HTTP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncoderConfig
implements Config {
    private static final String UTF_8 = StandardCharsets.UTF_8.toString();
    private static final Map<String, String> DEFAULT_CHARSET_FOR_CONTENT_TYPE = new HashMap<String, String>(){
        {
            this.put(ContentType.JSON.toString(), UTF_8);
            this.put("text/json", UTF_8);
        }
    };
    private final String defaultContentCharset;
    private final String defaultQueryParameterCharset;
    private final boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
    private final Map<String, ContentType> contentEncoders;
    private final Map<String, String> contentTypeToDefaultCharset;
    private final boolean isUserDefined;

    public EncoderConfig() {
        this(HTTP.DEF_CONTENT_CHARSET.toString(), UTF_8, true, new HashMap<String, ContentType>(), DEFAULT_CHARSET_FOR_CONTENT_TYPE, true);
    }

    public EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset) {
        this(defaultContentCharset, defaultQueryParameterCharset, true, new HashMap<String, ContentType>(), DEFAULT_CHARSET_FOR_CONTENT_TYPE, true);
    }

    private EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset, boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined, Map<String, ContentType> encoders, Map<String, String> contentTypeToDefaultCharset, boolean isUserDefined) {
        Validate.notBlank((CharSequence)defaultContentCharset, (String)"Default encoder content charset to cannot be blank. See \"appendDefaultContentCharsetToContentTypeIfMissing\" method if you like to disable automatically appending the charset to the content-type.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)defaultQueryParameterCharset, (String)"Default protocol charset to cannot be blank.", (Object[])new Object[0]);
        this.contentTypeToDefaultCharset = new HashMap<String, String>(contentTypeToDefaultCharset);
        this.defaultContentCharset = defaultContentCharset;
        this.defaultQueryParameterCharset = defaultQueryParameterCharset;
        this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined = shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
        this.contentEncoders = encoders;
        this.isUserDefined = isUserDefined;
    }

    public String defaultCharsetForContentType(String contentType) {
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return this.defaultContentCharset();
        }
        String charset = this.contentTypeToDefaultCharset.get(StringUtils.trim((String)contentType).toLowerCase());
        if (charset == null) {
            return this.defaultContentCharset();
        }
        return charset;
    }

    public String defaultCharsetForContentType(ContentType contentType) {
        if (contentType == null) {
            return this.defaultContentCharset();
        }
        return this.defaultCharsetForContentType(contentType.toString());
    }

    public boolean hasDefaultCharsetForContentType(String contentType) {
        return !StringUtils.isBlank((CharSequence)contentType) && this.contentTypeToDefaultCharset.containsKey(StringUtils.trim((String)contentType).toLowerCase());
    }

    public String defaultContentCharset() {
        return this.defaultContentCharset;
    }

    public String defaultQueryParameterCharset() {
        return this.defaultQueryParameterCharset;
    }

    public EncoderConfig defaultCharsetForContentType(String charset, String contentType) {
        AssertParameter.notNull((Object)charset, (String)"Charset");
        AssertParameter.notNull((Object)contentType, (String)"ContentType");
        HashMap<String, String> map = new HashMap<String, String>(this.contentTypeToDefaultCharset);
        map.put(StringUtils.trim((String)contentType).toLowerCase(), StringUtils.trim((String)charset));
        return new EncoderConfig(charset, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, this.contentEncoders, map, true);
    }

    public EncoderConfig defaultCharsetForContentType(String charset, ContentType contentType) {
        AssertParameter.notNull((Object)charset, (String)"Charset");
        AssertParameter.notNull((Object)((Object)contentType), ContentType.class);
        HashMap<String, String> map = new HashMap<String, String>(this.contentTypeToDefaultCharset);
        for (String ct : contentType.getContentTypeStrings()) {
            map.put(ct.toLowerCase(), StringUtils.trim((String)charset));
        }
        return new EncoderConfig(charset, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, this.contentEncoders, map, true);
    }

    public EncoderConfig defaultCharsetForContentType(Charset charset, ContentType contentType) {
        AssertParameter.notNull((Object)charset, (String)"Charset");
        return this.defaultCharsetForContentType(charset.toString(), contentType);
    }

    public EncoderConfig defaultCharsetForContentType(Charset charset, String contentType) {
        AssertParameter.notNull((Object)charset, (String)"Charset");
        return this.defaultCharsetForContentType(charset.toString(), contentType);
    }

    public EncoderConfig defaultContentCharset(Charset charset) {
        String charsetAsString = ((Charset)AssertParameter.notNull((Object)charset, Charset.class)).toString();
        return new EncoderConfig(charsetAsString, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, this.contentEncoders, this.contentTypeToDefaultCharset, true);
    }

    public EncoderConfig defaultQueryParameterCharset(String charset) {
        return new EncoderConfig(this.defaultContentCharset, charset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, this.contentEncoders, this.contentTypeToDefaultCharset, true);
    }

    public EncoderConfig defaultQueryParameterCharset(Charset charset) {
        String charsetAsString = ((Charset)AssertParameter.notNull((Object)charset, Charset.class)).toString();
        return new EncoderConfig(this.defaultContentCharset, charsetAsString, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, this.contentEncoders, this.contentTypeToDefaultCharset, true);
    }

    public EncoderConfig defaultContentCharset(String charset) {
        return new EncoderConfig(charset, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, this.contentEncoders, this.contentTypeToDefaultCharset, true);
    }

    public EncoderConfig appendDefaultContentCharsetToContentTypeIfUndefined(boolean shouldAddDefaultContentCharsetToContentTypeIfMissing) {
        return new EncoderConfig(this.defaultContentCharset, this.defaultQueryParameterCharset, shouldAddDefaultContentCharsetToContentTypeIfMissing, this.contentEncoders, this.contentTypeToDefaultCharset, true);
    }

    @Deprecated
    public EncoderConfig appendDefaultContentCharsetToStreamingContentTypeIfUndefined(boolean shouldAddDefaultContentCharsetToContentTypeIfMissing) {
        return new EncoderConfig(this.defaultContentCharset, this.defaultQueryParameterCharset, shouldAddDefaultContentCharsetToContentTypeIfMissing, this.contentEncoders, this.contentTypeToDefaultCharset, true);
    }

    public boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined() {
        return this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
    }

    public static EncoderConfig encoderConfig() {
        return new EncoderConfig();
    }

    public EncoderConfig and() {
        return this;
    }

    @Override
    public boolean isUserConfigured() {
        return this.isUserDefined;
    }

    public boolean hasContentEncoders() {
        return !this.contentEncoders.isEmpty();
    }

    public Map<String, ContentType> contentEncoders() {
        return Collections.unmodifiableMap(this.contentEncoders);
    }

    public EncoderConfig encodeContentTypeAs(String contentType, ContentType encoder) {
        AssertParameter.notNull((Object)contentType, (String)"Content-Type to encode");
        AssertParameter.notNull((Object)((Object)encoder), ContentType.class);
        HashMap<String, ContentType> newMap = new HashMap<String, ContentType>(this.contentEncoders);
        newMap.put(contentType, encoder);
        return new EncoderConfig(this.defaultContentCharset, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, newMap, this.contentTypeToDefaultCharset, true);
    }
}

