/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.config.ConnectionConfig;
import com.jayway.restassured.config.DecoderConfig;
import com.jayway.restassured.config.EncoderConfig;
import com.jayway.restassured.config.HeaderConfig;
import com.jayway.restassured.config.HttpClientConfig;
import com.jayway.restassured.config.JsonConfig;
import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.config.MatcherConfig;
import com.jayway.restassured.config.MultiPartConfig;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.RedirectConfig;
import com.jayway.restassured.config.SSLConfig;
import com.jayway.restassured.config.SessionConfig;
import com.jayway.restassured.config.XmlConfig;
import com.jayway.restassured.internal.assertion.AssertParameter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestAssuredConfig
implements Config {
    final Map<Class<? extends Config>, Config> configs = new HashMap<Class<? extends Config>, Config>();

    public RestAssuredConfig() {
        this(new RedirectConfig(), new HttpClientConfig(), new LogConfig(), new EncoderConfig(), new DecoderConfig(), new SessionConfig(), new ObjectMapperConfig(), new ConnectionConfig(), new JsonConfig(), new XmlConfig(), new SSLConfig(), new MatcherConfig(), new HeaderConfig(), new MultiPartConfig());
    }

    public RestAssuredConfig(RedirectConfig redirectConfig, HttpClientConfig httpClientConfig, LogConfig logConfig, EncoderConfig encoderConfig, DecoderConfig decoderConfig, SessionConfig sessionConfig, ObjectMapperConfig objectMapperConfig, ConnectionConfig connectionConfig, JsonConfig jsonConfig, XmlConfig xmlConfig, SSLConfig sslConfig, MatcherConfig matcherConfig, HeaderConfig headerConfig, MultiPartConfig multiPartConfig) {
        AssertParameter.notNull((Object)redirectConfig, (String)"Redirect Config");
        AssertParameter.notNull((Object)httpClientConfig, (String)"HTTP Client Config");
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        AssertParameter.notNull((Object)encoderConfig, (String)"Encoder config");
        AssertParameter.notNull((Object)decoderConfig, (String)"Decoder config");
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        AssertParameter.notNull((Object)connectionConfig, (String)"Connection config");
        AssertParameter.notNull((Object)jsonConfig, (String)"Json config");
        AssertParameter.notNull((Object)xmlConfig, (String)"Xml config");
        AssertParameter.notNull((Object)sslConfig, (String)"SSL config");
        AssertParameter.notNull((Object)matcherConfig, (String)"Matcher config");
        AssertParameter.notNull((Object)headerConfig, (String)"Header config");
        this.configs.put(HttpClientConfig.class, httpClientConfig);
        this.configs.put(RedirectConfig.class, redirectConfig);
        this.configs.put(LogConfig.class, logConfig);
        this.configs.put(EncoderConfig.class, encoderConfig);
        this.configs.put(DecoderConfig.class, decoderConfig);
        this.configs.put(SessionConfig.class, sessionConfig);
        this.configs.put(ObjectMapperConfig.class, objectMapperConfig);
        this.configs.put(ConnectionConfig.class, connectionConfig);
        this.configs.put(JsonConfig.class, jsonConfig);
        this.configs.put(XmlConfig.class, xmlConfig);
        this.configs.put(SSLConfig.class, sslConfig);
        this.configs.put(MatcherConfig.class, matcherConfig);
        this.configs.put(HeaderConfig.class, headerConfig);
        this.configs.put(MultiPartConfig.class, multiPartConfig);
    }

    public RestAssuredConfig redirect(RedirectConfig redirectConfig) {
        AssertParameter.notNull((Object)redirectConfig, (String)"Redirect config");
        return new RestAssuredConfig(redirectConfig, this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig httpClient(HttpClientConfig httpClientConfig) {
        AssertParameter.notNull((Object)httpClientConfig, (String)"HTTP Client Config");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), httpClientConfig, this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig logConfig(LogConfig logConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), logConfig, this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig encoderConfig(EncoderConfig encoderConfig) {
        AssertParameter.notNull((Object)encoderConfig, (String)"Encoder config");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), encoderConfig, this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig decoderConfig(DecoderConfig decoderConfig) {
        AssertParameter.notNull((Object)decoderConfig, (String)"Decoder config");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), decoderConfig, this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig sessionConfig(SessionConfig sessionConfig) {
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), sessionConfig, this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig objectMapperConfig(ObjectMapperConfig objectMapperConfig) {
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), objectMapperConfig, this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig connectionConfig(ConnectionConfig connectionConfig) {
        AssertParameter.notNull((Object)connectionConfig, (String)"Connection config");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), connectionConfig, this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig jsonConfig(JsonConfig jsonConfig) {
        AssertParameter.notNull((Object)jsonConfig, (String)"JsonConfig");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), jsonConfig, this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig xmlConfig(XmlConfig xmlConfig) {
        AssertParameter.notNull((Object)xmlConfig, (String)"XmlConfig");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), xmlConfig, this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig sslConfig(SSLConfig sslConfig) {
        AssertParameter.notNull((Object)sslConfig, (String)"SSLConfig");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), sslConfig, this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig matcherConfig(MatcherConfig matcherConfig) {
        AssertParameter.notNull((Object)matcherConfig, (String)"MatcherConfig");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), matcherConfig, this.conf(HeaderConfig.class), this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig headerConfig(HeaderConfig headerConfig) {
        AssertParameter.notNull((Object)headerConfig, (String)"HeaderConfig");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), headerConfig, this.conf(MultiPartConfig.class));
    }

    public RestAssuredConfig multiPartConfig(MultiPartConfig multiPartConfig) {
        AssertParameter.notNull((Object)multiPartConfig, (String)"MultiPartConfig");
        return new RestAssuredConfig(this.conf(RedirectConfig.class), this.conf(HttpClientConfig.class), this.conf(LogConfig.class), this.conf(EncoderConfig.class), this.conf(DecoderConfig.class), this.conf(SessionConfig.class), this.conf(ObjectMapperConfig.class), this.conf(ConnectionConfig.class), this.conf(JsonConfig.class), this.conf(XmlConfig.class), this.conf(SSLConfig.class), this.conf(MatcherConfig.class), this.conf(HeaderConfig.class), multiPartConfig);
    }

    public RestAssuredConfig and() {
        return this;
    }

    public RestAssuredConfig set() {
        return this;
    }

    public RestAssuredConfig with() {
        return this;
    }

    public RedirectConfig getRedirectConfig() {
        return this.conf(RedirectConfig.class);
    }

    public LogConfig getLogConfig() {
        return this.conf(LogConfig.class);
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.conf(HttpClientConfig.class);
    }

    public EncoderConfig getEncoderConfig() {
        return this.conf(EncoderConfig.class);
    }

    public DecoderConfig getDecoderConfig() {
        return this.conf(DecoderConfig.class);
    }

    public SessionConfig getSessionConfig() {
        return this.conf(SessionConfig.class);
    }

    public ObjectMapperConfig getObjectMapperConfig() {
        return this.conf(ObjectMapperConfig.class);
    }

    public ConnectionConfig getConnectionConfig() {
        return this.conf(ConnectionConfig.class);
    }

    public JsonConfig getJsonConfig() {
        return this.conf(JsonConfig.class);
    }

    public XmlConfig getXmlConfig() {
        return this.conf(XmlConfig.class);
    }

    public SSLConfig getSSLConfig() {
        return this.conf(SSLConfig.class);
    }

    public MatcherConfig getMatcherConfig() {
        return this.conf(MatcherConfig.class);
    }

    public HeaderConfig getHeaderConfig() {
        return this.conf(HeaderConfig.class);
    }

    public MultiPartConfig getMultiPartConfig() {
        return this.conf(MultiPartConfig.class);
    }

    public static RestAssuredConfig newConfig() {
        return new RestAssuredConfig();
    }

    public static RestAssuredConfig config() {
        return new RestAssuredConfig();
    }

    @Override
    public boolean isUserConfigured() {
        for (Config cfg : this.configs.values()) {
            if (!cfg.isUserConfigured()) continue;
            return true;
        }
        return false;
    }

    private <T extends Config> T conf(Class<T> type) {
        return (T)this.configs.get(type);
    }
}

