/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.internal.assertion.AssertParameter;
import org.apache.commons.lang3.StringUtils;

public class MultiPartConfig
implements Config {
    private static final String DEFAULT_CONTROL_NAME = "file";
    private static final String DEFAULT_FILE_NAME = "file";
    private final String defaultControlName;
    private final String defaultFileName;
    private final boolean isUserConfigured;

    public MultiPartConfig() {
        this("file", "file", false);
    }

    private MultiPartConfig(String defaultControlName, String defaultFileName, boolean isUserConfigured) {
        AssertParameter.notNull((Object)defaultControlName, (String)"Default control name");
        this.defaultControlName = defaultControlName;
        this.defaultFileName = StringUtils.trimToNull((String)defaultFileName);
        this.isUserConfigured = isUserConfigured;
    }

    public MultiPartConfig defaultControlName(String defaultControlName) {
        return new MultiPartConfig(defaultControlName, this.defaultFileName, true);
    }

    public MultiPartConfig defaultFileName(String defaultFileName) {
        return new MultiPartConfig(this.defaultControlName, defaultFileName, true);
    }

    public MultiPartConfig emptyDefaultFileName() {
        return new MultiPartConfig(this.defaultControlName, null, true);
    }

    public String defaultControlName() {
        return this.defaultControlName;
    }

    public String defaultFileName() {
        return this.defaultFileName;
    }

    public boolean isUserConfigured() {
        return this.isUserConfigured;
    }

    public static MultiPartConfig multiPartConfig() {
        return new MultiPartConfig();
    }

    public MultiPartConfig and() {
        return this;
    }

    public MultiPartConfig with() {
        return this;
    }
}

