/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.config.Config;
import com.jayway.restassured.internal.assertion.AssertParameter;
import java.nio.charset.Charset;
import org.apache.commons.lang3.Validate;
import org.apache.http.protocol.HTTP;

public class EncoderConfig
implements Config {
    private static final String UTF_8 = "UTF-8";
    private final String defaultContentCharset;
    private final String defaultQueryParameterCharset;
    private final boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
    private final boolean isUserDefined;

    public EncoderConfig() {
        this(HTTP.DEF_CONTENT_CHARSET.toString(), UTF_8, true, true);
    }

    public EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset) {
        this(defaultContentCharset, defaultQueryParameterCharset, true, true);
    }

    private EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset, boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined, boolean isUserDefined) {
        Validate.notBlank((CharSequence)defaultContentCharset, (String)"Default encoder content charset to cannot be blank. See \"appendDefaultContentCharsetToContentTypeIfMissing\" method if you like to disable automatically appending the charset to the content-type.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)defaultQueryParameterCharset, (String)"Default protocol charset to cannot be blank.", (Object[])new Object[0]);
        this.defaultContentCharset = defaultContentCharset;
        this.defaultQueryParameterCharset = defaultQueryParameterCharset;
        this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined = shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
        this.isUserDefined = isUserDefined;
    }

    public String defaultContentCharset() {
        return this.defaultContentCharset;
    }

    public String defaultQueryParameterCharset() {
        return this.defaultQueryParameterCharset;
    }

    public EncoderConfig defaultContentCharset(String charset) {
        return new EncoderConfig(charset, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, true);
    }

    public EncoderConfig defaultContentCharset(Charset charset) {
        String charsetAsString = ((Charset)AssertParameter.notNull((Object)charset, Charset.class)).toString();
        return new EncoderConfig(charsetAsString, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, true);
    }

    public EncoderConfig defaultQueryParameterCharset(String charset) {
        return new EncoderConfig(this.defaultContentCharset, charset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, true);
    }

    public EncoderConfig defaultQueryParameterCharset(Charset charset) {
        String charsetAsString = ((Charset)AssertParameter.notNull((Object)charset, Charset.class)).toString();
        return new EncoderConfig(this.defaultContentCharset, charsetAsString, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined, true);
    }

    public EncoderConfig appendDefaultContentCharsetToContentTypeIfUndefined(boolean shouldAddDefaultContentCharsetToContentTypeIfMissing) {
        return new EncoderConfig(this.defaultContentCharset, this.defaultQueryParameterCharset, shouldAddDefaultContentCharsetToContentTypeIfMissing, true);
    }

    @Deprecated
    public EncoderConfig appendDefaultContentCharsetToStreamingContentTypeIfUndefined(boolean shouldAddDefaultContentCharsetToContentTypeIfMissing) {
        return new EncoderConfig(this.defaultContentCharset, this.defaultQueryParameterCharset, shouldAddDefaultContentCharsetToContentTypeIfMissing, true);
    }

    public boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined() {
        return this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
    }

    public static EncoderConfig encoderConfig() {
        return new EncoderConfig();
    }

    public EncoderConfig and() {
        return this;
    }

    public boolean isUserConfigured() {
        return this.isUserDefined;
    }
}

