/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.http;

import org.apache.http.HttpResponse;

public class HttpResponseContentTypeFinder {
    public static String findContentType(HttpResponse resp) {
        if (resp.getEntity() == null) {
            throw new IllegalArgumentException("Response does not contain data");
        }
        if (resp.getEntity().getContentType() == null) {
            throw new IllegalArgumentException("Response does not have a content-type header");
        }
        try {
            return resp.getEntity().getContentType().getValue();
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Could not parse content-type from response");
        }
    }
}

