/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import org.apache.commons.lang3.Validate;
import org.apache.http.protocol.HTTP;

public class EncoderConfig {
    private static final String UTF_8 = "UTF-8";
    private final String defaultContentCharset;
    private final String defaultQueryParameterCharset;
    private final boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined;

    public EncoderConfig() {
        this(HTTP.DEF_CONTENT_CHARSET.toString(), UTF_8);
    }

    public EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset) {
        this(defaultContentCharset, defaultQueryParameterCharset, true);
    }

    private EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset, boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined) {
        Validate.notBlank((CharSequence)defaultContentCharset, (String)"Default encoder content charset to cannot be blank. See \"appendDefaultContentCharsetToContentTypeIfMissing\" method if you like to disable automatically appending the charset to the content-type.", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)defaultQueryParameterCharset, (String)"Default protocol charset to cannot be blank.", (Object[])new Object[0]);
        this.defaultContentCharset = defaultContentCharset;
        this.defaultQueryParameterCharset = defaultQueryParameterCharset;
        this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined = shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
    }

    public String defaultContentCharset() {
        return this.defaultContentCharset;
    }

    public String defaultQueryParameterCharset() {
        return this.defaultQueryParameterCharset;
    }

    public EncoderConfig defaultContentCharset(String charset) {
        return new EncoderConfig(charset, this.defaultQueryParameterCharset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined);
    }

    public EncoderConfig defaultQueryParameterCharset(String charset) {
        return new EncoderConfig(this.defaultContentCharset, charset, this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined);
    }

    public EncoderConfig appendDefaultContentCharsetToContentTypeIfUndefined(boolean shouldAddDefaultContentCharsetToContentTypeIfMissing) {
        return new EncoderConfig(this.defaultContentCharset, this.defaultQueryParameterCharset, shouldAddDefaultContentCharsetToContentTypeIfMissing);
    }

    @Deprecated
    public EncoderConfig appendDefaultContentCharsetToStreamingContentTypeIfUndefined(boolean shouldAddDefaultContentCharsetToContentTypeIfMissing) {
        return new EncoderConfig(this.defaultContentCharset, this.defaultQueryParameterCharset, shouldAddDefaultContentCharsetToContentTypeIfMissing);
    }

    public boolean shouldAppendDefaultContentCharsetToContentTypeIfUndefined() {
        return this.shouldAppendDefaultContentCharsetToContentTypeIfUndefined;
    }

    public static EncoderConfig encoderConfig() {
        return new EncoderConfig();
    }

    public EncoderConfig and() {
        return this;
    }
}

