/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoderConfig {
    private static final boolean DEFAULT_NO_WRAP_FOR_INFLATE_ENCODED_STREAMS = false;
    private final String defaultContentCharset;
    private final List<ContentDecoder> contentDecoders;
    private final boolean useNoWrapForInflateDecoding;

    public DecoderConfig() {
        this(Charset.defaultCharset().toString(), false, DecoderConfig.defaultContentEncoders());
    }

    public DecoderConfig(String defaultContentCharset) {
        this(defaultContentCharset, false, DecoderConfig.defaultContentEncoders());
    }

    public DecoderConfig(ContentDecoder contentDecoder, ContentDecoder ... additionalContentDecoders) {
        this(Charset.defaultCharset().toString(), false, DecoderConfig.merge(contentDecoder, additionalContentDecoders));
    }

    private DecoderConfig(String defaultContentCharset, boolean useNoWrapForInflateDecoding, ContentDecoder ... contentDecoders) {
        this(defaultContentCharset, useNoWrapForInflateDecoding, contentDecoders == null ? Collections.emptyList() : Arrays.asList(contentDecoders));
    }

    private DecoderConfig(String defaultContentCharset, boolean useNoWrapForInflateDecoding, List<ContentDecoder> contentDecoders) {
        Validate.notBlank((CharSequence)defaultContentCharset, (String)"Default decoder content charset to cannot be blank", (Object[])new Object[0]);
        this.defaultContentCharset = defaultContentCharset;
        this.contentDecoders = Collections.unmodifiableList(contentDecoders == null ? Collections.emptyList() : contentDecoders);
        this.useNoWrapForInflateDecoding = useNoWrapForInflateDecoding;
    }

    public String defaultContentCharset() {
        return this.defaultContentCharset;
    }

    public List<ContentDecoder> contentDecoders() {
        return this.contentDecoders;
    }

    public DecoderConfig useNoWrapForInflateDecoding(boolean nowrap) {
        return new DecoderConfig(this.defaultContentCharset, nowrap, this.contentDecoders);
    }

    public boolean shouldUseNoWrapForInflateDecoding() {
        return this.useNoWrapForInflateDecoding;
    }

    public DecoderConfig defaultContentCharset(String charset) {
        return new DecoderConfig(charset, this.useNoWrapForInflateDecoding, this.contentDecoders);
    }

    public DecoderConfig contentDecoders(ContentDecoder contentDecoder, ContentDecoder ... additionalContentDecoders) {
        return new DecoderConfig(this.defaultContentCharset, this.useNoWrapForInflateDecoding, DecoderConfig.merge(contentDecoder, additionalContentDecoders));
    }

    public DecoderConfig noContentDecoders() {
        return new DecoderConfig(this.defaultContentCharset, this.useNoWrapForInflateDecoding, new ContentDecoder[0]);
    }

    public static DecoderConfig decoderConfig() {
        return new DecoderConfig();
    }

    public DecoderConfig and() {
        return this;
    }

    public DecoderConfig with() {
        return this;
    }

    private static ContentDecoder[] defaultContentEncoders() {
        return new ContentDecoder[]{ContentDecoder.GZIP, ContentDecoder.DEFLATE};
    }

    private static ContentDecoder[] merge(ContentDecoder contentDecoder, ContentDecoder[] additionalContentDecoders) {
        ContentDecoder[] contentDecoders;
        Validate.notNull((Object)((Object)contentDecoder), (String)"Content decoder cannot be null", (Object[])new Object[0]);
        if (additionalContentDecoders == null || additionalContentDecoders.length == 0) {
            contentDecoders = new ContentDecoder[]{contentDecoder};
        } else {
            contentDecoders = new ContentDecoder[additionalContentDecoders.length + 1];
            contentDecoders[0] = contentDecoder;
            System.arraycopy(additionalContentDecoders, 0, contentDecoders, 1, additionalContentDecoders.length);
        }
        return contentDecoders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentDecoder {
        GZIP,
        DEFLATE;

    }
}

