/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.authentication;

import com.jayway.restassured.config.LogConfig;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.assertion.AssertParameter;

public class FormAuthConfig {
    private final String formAction;
    private final String userInputTagName;
    private final String passwordInputTagName;
    private final LogConfig logConfig;
    private final LogDetail logDetail;

    public FormAuthConfig(String formAction, String userNameInputTagName, String passwordInputTagName) {
        this(formAction, userNameInputTagName, passwordInputTagName, null, null);
    }

    private FormAuthConfig(String formAction, String userNameInputTagName, String passwordInputTagName, LogDetail logDetail, LogConfig logConfig) {
        AssertParameter.notNull((Object)formAction, (String)"Form action");
        AssertParameter.notNull((Object)userNameInputTagName, (String)"User input tag name");
        AssertParameter.notNull((Object)passwordInputTagName, (String)"Password input tag name");
        this.formAction = formAction;
        this.userInputTagName = userNameInputTagName;
        this.passwordInputTagName = passwordInputTagName;
        this.logDetail = logDetail;
        this.logConfig = logConfig;
    }

    public static FormAuthConfig springSecurity() {
        return new FormAuthConfig("/j_spring_security_check", "j_username", "j_password");
    }

    public FormAuthConfig withLoggingEnabled() {
        return this.withLoggingEnabled(LogDetail.ALL);
    }

    public FormAuthConfig withLoggingEnabled(LogDetail logDetail) {
        return this.withLoggingEnabled(logDetail, new LogConfig());
    }

    public FormAuthConfig withLoggingEnabled(LogConfig logConfig) {
        return this.withLoggingEnabled(LogDetail.ALL, logConfig);
    }

    public FormAuthConfig withLoggingEnabled(LogDetail logDetail, LogConfig logConfig) {
        AssertParameter.notNull((Object)((Object)logDetail), LogDetail.class);
        AssertParameter.notNull((Object)logConfig, LogConfig.class);
        return new FormAuthConfig(this.formAction, this.userInputTagName, this.passwordInputTagName, logDetail, logConfig);
    }

    public FormAuthConfig and() {
        return this;
    }

    public String getFormAction() {
        return this.formAction;
    }

    public String getUserInputTagName() {
        return this.userInputTagName;
    }

    public String getPasswordInputTagName() {
        return this.passwordInputTagName;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public boolean isLoggingEnabled() {
        return this.logConfig != null && this.logDetail != null;
    }

    public LogDetail getLogDetail() {
        return this.logDetail;
    }
}

