/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.http;

import com.jayway.restassured.internal.KeystoreSpecImpl;
import com.jayway.restassured.internal.http.HTTPBuilder;
import com.jayway.restassured.internal.http.URIBuilder;
import com.jayway.restassured.internal.util.SafeExceptionRethrower;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.HttpRequestAdapter;
import oauth.signpost.exception.OAuthException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;

public class AuthConfig {
    private static final int UNDEFINED_PORT = -1;
    private static final int DEFAULT_HTTPS_PORT = 443;
    protected HTTPBuilder builder;

    public AuthConfig(HTTPBuilder builder) {
        this.builder = builder;
    }

    public void basic(String user, String pass) {
        URI uri = ((URIBuilder)this.builder.getUri()).toURI();
        if (uri == null) {
            throw new IllegalStateException("a default URI must be set");
        }
        this.basic(uri.getHost(), uri.getPort(), user, pass);
    }

    public void basic(String host, int port, String user, String pass) {
        this.builder.getClient().getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, pass));
    }

    public void certificate(String certURL, String password, String certType, int port, KeyStore trustStore, X509HostnameVerifier x509HostnameVerifier) {
        KeystoreSpecImpl keystoreSpec = new KeystoreSpecImpl();
        URI uri = ((URIBuilder)this.builder.getUri()).toURI();
        if (uri == null) {
            throw new IllegalStateException("a default URI must be set");
        }
        keystoreSpec.setKeyStoreType(certType);
        keystoreSpec.setPassword(password);
        keystoreSpec.setPath(certURL);
        keystoreSpec.setTrustStore(trustStore);
        keystoreSpec.setPort(port);
        keystoreSpec.setX509HostnameVerifier(x509HostnameVerifier);
        int portSpecifiedInUri = uri.getPort();
        keystoreSpec.apply(this.builder, portSpecifiedInUri == -1 ? 443 : portSpecifiedInUri);
    }

    public void oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        this.builder.client.removeRequestInterceptorByClass(OAuthSigner.class);
        if (consumerKey != null) {
            this.builder.client.addRequestInterceptor((HttpRequestInterceptor)new OAuthSigner(consumerKey, consumerSecret, accessToken, secretToken));
        }
    }

    static class OAuthSigner
    implements HttpRequestInterceptor {
        protected OAuthConsumer oauth;

        public OAuthSigner(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
            this.oauth = new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
            this.oauth.setTokenWithSecret(accessToken, secretToken);
        }

        public void process(HttpRequest request, HttpContext ctx) {
            try {
                HttpUriRequest uriRequest = (HttpUriRequest)request;
                HttpHost host = (HttpHost)ctx.getAttribute("http.target_host");
                final URI requestURI = new URI(host.toURI()).resolve(uriRequest.getURI());
                HttpRequestAdapter oAuthRequest = new HttpRequestAdapter(uriRequest){

                    public String getRequestUrl() {
                        return requestURI.toString();
                    }
                };
                this.oauth.sign((oauth.signpost.http.HttpRequest)oAuthRequest);
            }
            catch (ClassCastException ex) {
                SafeExceptionRethrower.safeRethrow((Throwable)new HttpException("Request must be an instance of HttpUriRequest", (Throwable)ex));
            }
            catch (URISyntaxException ex) {
                SafeExceptionRethrower.safeRethrow((Throwable)new HttpException("Error rebuilding request URI", (Throwable)ex));
            }
            catch (OAuthException e) {
                SafeExceptionRethrower.safeRethrow((Throwable)new HttpException("OAuth signing error", (Throwable)e));
            }
        }
    }
}

