/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;

public class CloseHTTPClientConnectionInputStreamWrapper
extends InputStream {
    private final ClientConnectionManager connectionManager;
    private final InputStream wrapped;

    public CloseHTTPClientConnectionInputStreamWrapper(ClientConnectionManager connectionManager, InputStream wrapped) {
        this.connectionManager = connectionManager;
        this.wrapped = wrapped;
    }

    public int read() throws IOException {
        return this.wrapped.read();
    }

    public int read(byte[] b) throws IOException {
        return this.wrapped.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrapped.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.wrapped.skip(n);
    }

    public int available() throws IOException {
        return this.wrapped.available();
    }

    public void close() throws IOException {
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(0L, TimeUnit.NANOSECONDS);
        }
        this.wrapped.close();
    }

    public void mark(int readlimit) {
        this.wrapped.mark(readlimit);
    }

    public void reset() throws IOException {
        this.wrapped.reset();
    }

    public boolean markSupported() {
        return this.wrapped.markSupported();
    }
}

