/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import org.apache.commons.lang3.Validate;

public class EncoderConfig {
    private static final String UTF_8 = "UTF-8";
    private final String defaultContentCharset;
    private final String defaultQueryParameterCharset;

    public EncoderConfig() {
        this("ISO-8859-1", UTF_8);
    }

    public EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset) {
        Validate.notBlank((CharSequence)defaultContentCharset, (String)"Default encoder content charset to cannot be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)defaultQueryParameterCharset, (String)"Default protocol charset to cannot be blank", (Object[])new Object[0]);
        this.defaultContentCharset = defaultContentCharset;
        this.defaultQueryParameterCharset = defaultQueryParameterCharset;
    }

    public String defaultContentCharset() {
        return this.defaultContentCharset;
    }

    public String defaultQueryParameterCharset() {
        return this.defaultQueryParameterCharset;
    }

    public EncoderConfig defaultContentCharset(String charset) {
        return new EncoderConfig(charset, this.defaultQueryParameterCharset);
    }

    public EncoderConfig defaultQueryParameterCharset(String charset) {
        return new EncoderConfig(this.defaultContentCharset, charset);
    }

    public static EncoderConfig encoderConfig() {
        return new EncoderConfig();
    }

    public EncoderConfig and() {
        return this;
    }
}

