/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.builder;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.authentication.AuthenticationScheme;
import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.internal.SpecificationMerger;
import com.jayway.restassured.specification.RequestSpecification;
import groovyx.net.http.ContentType;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSpecBuilder {
    private RequestSpecification spec = new RequestSpecificationImpl(RestAssured.baseURI, RestAssured.port, RestAssured.basePath, RestAssured.authentication, RestAssured.filters(), RestAssured.keystore(), RestAssured.requestContentType(), RestAssured.requestSpecification, RestAssured.urlEncodingEnabled);

    public RequestSpecBuilder setBody(String body) {
        this.spec.body(body);
        return this;
    }

    public RequestSpecBuilder setBody(byte[] body) {
        this.spec.body(body);
        return this;
    }

    public RequestSpecBuilder setContent(String content) {
        this.spec.content(content);
        return this;
    }

    public RequestSpecBuilder setContent(byte[] content) {
        this.spec.content(content);
        return this;
    }

    public RequestSpecBuilder addCookies(Map<String, String> cookies) {
        this.spec.cookies(cookies);
        return this;
    }

    public RequestSpecBuilder addCookie(String key, String value) {
        this.spec.cookie(key, value);
        return this;
    }

    public RequestSpecBuilder addCookie(String key) {
        this.spec.cookie(key);
        return this;
    }

    public RequestSpecBuilder addFilter(Filter filter) {
        this.spec.filter(filter);
        return this;
    }

    public RequestSpecBuilder addFilters(List<Filter> filters) {
        this.spec.filters(filters);
        return this;
    }

    public RequestSpecBuilder addParameters(Map<String, String> parametersMap) {
        this.spec.parameters(parametersMap);
        return this;
    }

    public RequestSpecBuilder addParameter(String parameterName, String parameterValue, String ... additionalParameterValues) {
        this.spec.parameter(parameterName, parameterValue, additionalParameterValues);
        return this;
    }

    public RequestSpecBuilder addParameter(String parameterName, List<String> parameterValues) {
        this.spec.parameter(parameterName, parameterValues);
        return this;
    }

    public RequestSpecBuilder addParams(Map<String, String> parametersMap) {
        this.spec.params(parametersMap);
        return this;
    }

    public RequestSpecBuilder addParam(String parameterName, String parameterValue, String ... additionalParameterValues) {
        this.spec.param(parameterName, parameterValue, additionalParameterValues);
        return this;
    }

    public RequestSpecBuilder addParam(String parameterName, List<String> parameterValues) {
        this.spec.param(parameterName, parameterValues);
        return this;
    }

    public RequestSpecBuilder addQueryParameters(Map<String, String> parametersMap) {
        this.spec.queryParameters(parametersMap);
        return this;
    }

    public RequestSpecBuilder addQueryParameter(String parameterName, String parameterValue, String ... additionalParameterValues) {
        this.spec.queryParameter(parameterName, parameterValue, additionalParameterValues);
        return this;
    }

    public RequestSpecBuilder addQueryParameter(String parameterName, List<String> parameterValues) {
        this.spec.parameter(parameterName, parameterValues);
        return this;
    }

    public RequestSpecBuilder addQueryParam(String parameterName, List<String> parameterValues) {
        this.spec.queryParam(parameterName, parameterValues);
        return this;
    }

    public RequestSpecBuilder addQueryParams(Map<String, String> parametersMap) {
        this.spec.queryParams(parametersMap);
        return this;
    }

    public RequestSpecBuilder addQueryParam(String parameterName, String parameterValue, String ... additionalParameterValues) {
        this.spec.queryParam(parameterName, parameterValue, additionalParameterValues);
        return this;
    }

    public RequestSpecBuilder addFormParameters(Map<String, String> parametersMap) {
        this.spec.formParameters(parametersMap);
        return this;
    }

    public RequestSpecBuilder addFormParameter(String parameterName, String parameterValue, String ... additionalParameterValues) {
        this.spec.formParameter(parameterName, parameterValue, additionalParameterValues);
        return this;
    }

    public RequestSpecBuilder addFormParameter(String parameterName, List<String> parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public RequestSpecBuilder addFormParam(String parameterName, List<String> parameterValues) {
        this.spec.formParam(parameterName, parameterValues);
        return this;
    }

    public RequestSpecBuilder addFormParams(Map<String, String> parametersMap) {
        this.spec.formParams(parametersMap);
        return this;
    }

    public RequestSpecBuilder addFormParam(String parameterName, String parameterValue, String ... additionalParameterValues) {
        this.spec.formParam(parameterName, parameterValue, additionalParameterValues);
        return this;
    }

    public RequestSpecBuilder addPathParameter(String parameterName, Object parameterValue) {
        this.spec.pathParameter(parameterName, parameterValue);
        return this;
    }

    public RequestSpecBuilder addPathParameters(String parameterName, Object ... parameterNameValuePairs) {
        this.spec.pathParameters(parameterName, parameterNameValuePairs);
        return this;
    }

    public RequestSpecBuilder addPathParameters(Map<String, Object> parameterNameValuePairs) {
        this.spec.pathParameters(parameterNameValuePairs);
        return this;
    }

    public RequestSpecBuilder addPathParam(String parameterName, Object parameterValue) {
        this.spec.pathParam(parameterName, parameterValue);
        return this;
    }

    public RequestSpecBuilder addPathParams(String parameterName, Object ... parameterNameValuePairs) {
        this.spec.pathParams(parameterName, parameterNameValuePairs);
        return this;
    }

    public RequestSpecBuilder addPathParams(Map<String, Object> parameterNameValuePairs) {
        this.spec.pathParams(parameterNameValuePairs);
        return this;
    }

    public RequestSpecBuilder setKeystore(String pathToJks, String password) {
        this.spec.keystore(pathToJks, password);
        return this;
    }

    public RequestSpecBuilder addHeaders(Map<String, String> headers) {
        this.spec.headers(headers);
        return this;
    }

    public RequestSpecBuilder addHeader(String headerName, String headerValue) {
        this.spec.header(headerName, headerValue);
        return this;
    }

    public RequestSpecBuilder setContentType(ContentType contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public RequestSpecBuilder setContentType(String contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public RequestSpecBuilder addMultiPart(File file) {
        this.spec.multiPart(file);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, File file) {
        this.spec.multiPart(controlName, file);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, File file, String mimeType) {
        this.spec.multiPart(controlName, file, mimeType);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes) {
        this.spec.multiPart(controlName, fileName, bytes);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, String fileName, byte[] bytes, String mimeType) {
        this.spec.multiPart(controlName, fileName, bytes, mimeType);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream) {
        this.spec.multiPart(controlName, fileName, stream);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, String fileName, InputStream stream, String mimeType) {
        this.spec.multiPart(controlName, fileName, stream, mimeType);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, String contentBody) {
        this.spec.multiPart(controlName, contentBody);
        return this;
    }

    public RequestSpecBuilder addMultiPart(String controlName, String contentBody, String mimeType) {
        this.spec.multiPart(controlName, mimeType);
        return this;
    }

    public RequestSpecBuilder setAuthentication(AuthenticationScheme auth) {
        ((RequestSpecificationImpl)this.spec).setAuthenticationScheme(auth);
        return this;
    }

    public RequestSpecBuilder setAuth(AuthenticationScheme auth) {
        return this.setAuthentication(auth);
    }

    public RequestSpecBuilder setPort(int port) {
        this.spec.port(port);
        return this;
    }

    public RequestSpecBuilder setUrlEncodingEnabled(boolean isEnabled) {
        this.spec.urlEncodingEnabled(isEnabled);
        return this;
    }

    public RequestSpecBuilder addRequestSpecification(RequestSpecification specification) {
        if (!(specification instanceof RequestSpecification)) {
            throw new IllegalArgumentException("specification must be of type " + RequestSpecification.class.getClass() + ".");
        }
        RequestSpecificationImpl rs = (RequestSpecificationImpl)specification;
        SpecificationMerger.merge((RequestSpecificationImpl)this.spec, rs);
        return this;
    }

    public RequestSpecification build() {
        return this.spec;
    }
}

