/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured;

import com.jayway.restassured.authentication.AuthenticationScheme;
import com.jayway.restassured.authentication.BasicAuthScheme;
import com.jayway.restassured.authentication.CertAuthScheme;
import com.jayway.restassured.authentication.FormAuthConfig;
import com.jayway.restassured.authentication.FormAuthScheme;
import com.jayway.restassured.authentication.NoAuthScheme;
import com.jayway.restassured.authentication.OAuthScheme;
import com.jayway.restassured.authentication.PreemptiveAuthProvider;
import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.internal.KeystoreSpec;
import com.jayway.restassured.internal.KeystoreSpecImpl;
import com.jayway.restassured.internal.NoKeystoreSpecImpl;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.internal.ResponseParserRegistrar;
import com.jayway.restassured.internal.ResponseSpecificationImpl;
import com.jayway.restassured.internal.TestSpecificationImpl;
import com.jayway.restassured.internal.filter.FormAuthFilter;
import com.jayway.restassured.parsing.Parser;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.Argument;
import com.jayway.restassured.specification.RequestSender;
import com.jayway.restassured.specification.RequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import groovyx.net.http.ContentType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestAssured {
    public static final String DEFAULT_URI = "http://localhost";
    public static final String DEFAULT_BODY_ROOT_PATH = "";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_PATH = "";
    public static final AuthenticationScheme DEFAULT_AUTH = new NoAuthScheme();
    public static final boolean DEFAULT_URL_ENCODING_ENABLED = true;
    public static String baseURI = "http://localhost";
    public static int port = 8080;
    public static String basePath = "";
    public static boolean urlEncodingEnabled = true;
    public static AuthenticationScheme authentication = DEFAULT_AUTH;
    public static String rootPath = "";
    public static RequestSpecification requestSpecification = null;
    public static ResponseSpecification responseSpecification = null;
    private static Object requestContentType = null;
    private static Object responseContentType = null;
    private static KeystoreSpec keystoreSpec = new NoKeystoreSpecImpl();
    private static List<Filter> filters = new LinkedList<Filter>();

    public static void keystore(String pathToJks, String password) {
        Validate.notEmpty((String)pathToJks, (String)"Path to java keystore cannot be empty");
        Validate.notEmpty((String)password, (String)"Password cannot be empty");
        KeystoreSpecImpl spec = new KeystoreSpecImpl();
        spec.setPath(pathToJks);
        spec.setPassword(password);
        keystoreSpec = spec;
    }

    public static void filters(List<Filter> filters) {
        RestAssured.filters.addAll(filters);
    }

    public static List<Filter> filters() {
        return Collections.unmodifiableList(filters);
    }

    public static Object requestContentType() {
        return requestContentType;
    }

    public static Object responseContentType() {
        return responseContentType;
    }

    public static KeystoreSpec keystore() {
        return keystoreSpec;
    }

    public static void requestContentType(ContentType contentType) {
        requestContentType = contentType;
    }

    public static void requestContentType(String contentType) {
        requestContentType = contentType;
    }

    public static void responseContentType(ContentType contentType) {
        responseContentType = contentType;
    }

    public static void responseContentType(String contentType) {
        responseContentType = contentType;
    }

    public static ResponseSpecification expect() {
        return RestAssured.createTestSpecification().getResponseSpecification();
    }

    public static RequestSpecification with() {
        return RestAssured.given();
    }

    public static List<Argument> withArguments(Object firstArgument, Object ... additionalArguments) {
        Validate.notNull((Object)firstArgument, (String)"You need to supply at least one argument");
        LinkedList<Argument> arguments = new LinkedList<Argument>();
        arguments.add(Argument.arg(firstArgument));
        if (additionalArguments != null && additionalArguments.length > 0) {
            for (Object additionalArgument : additionalArguments) {
                arguments.add(Argument.arg(additionalArgument));
            }
        }
        return Collections.unmodifiableList(arguments);
    }

    public static List<Argument> withArgs(Object firstArgument, Object ... additionalArguments) {
        return RestAssured.withArguments(firstArgument, additionalArguments);
    }

    public static RequestSpecification given() {
        return RestAssured.createTestSpecification().getRequestSpecification();
    }

    public static RequestSender given(RequestSpecification requestSpecification, ResponseSpecification responseSpecification) {
        return new TestSpecificationImpl(requestSpecification, responseSpecification);
    }

    public static Response get(String path, Object ... pathParams) {
        return RestAssured.given().get(path, pathParams);
    }

    public static Response get(String path, Map<String, Object> pathParams) {
        return RestAssured.given().get(path, pathParams);
    }

    public static Response post(String path, Object ... pathParams) {
        return RestAssured.given().post(path, pathParams);
    }

    public static Response post(String path, Map<String, Object> pathParams) {
        return RestAssured.given().post(path, pathParams);
    }

    public static Response put(String path, Object ... pathParams) {
        return RestAssured.given().put(path, pathParams);
    }

    public static Response delete(String path, Object ... pathParams) {
        return RestAssured.given().delete(path, pathParams);
    }

    public static Response delete(String path, Map<String, Object> pathParams) {
        return RestAssured.given().delete(path, pathParams);
    }

    public static Response head(String path, Object ... pathParams) {
        return RestAssured.given().head(path, pathParams);
    }

    public static Response head(String path, Map<String, Object> pathParams) {
        return RestAssured.given().head(path, pathParams);
    }

    public static AuthenticationScheme basic(String userName, String password) {
        BasicAuthScheme scheme = new BasicAuthScheme();
        scheme.setUserName(userName);
        scheme.setPassword(password);
        return scheme;
    }

    public static AuthenticationScheme form(String userName, String password) {
        return RestAssured.form(userName, password, null);
    }

    public static AuthenticationScheme form(String userName, String password, FormAuthConfig config) {
        if (userName == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        FormAuthScheme scheme = new FormAuthScheme();
        FormAuthFilter authFilter = new FormAuthFilter();
        authFilter.setUserName(userName);
        authFilter.setPassword(password);
        authFilter.setConfig(config);
        filters.add(authFilter);
        return scheme;
    }

    public static PreemptiveAuthProvider preemptive() {
        return new PreemptiveAuthProvider();
    }

    public static AuthenticationScheme certificate(String certURL, String password) {
        CertAuthScheme scheme = new CertAuthScheme();
        scheme.setCertURL(certURL);
        scheme.setPassword(password);
        return scheme;
    }

    public static AuthenticationScheme digest(String userName, String password) {
        return RestAssured.basic(userName, password);
    }

    public static AuthenticationScheme oauth(String consumerKey, String consumerSecret, String accessToken, String secretToken) {
        OAuthScheme scheme = new OAuthScheme();
        scheme.setConsumerKey(consumerKey);
        scheme.setConsumerSecret(consumerSecret);
        scheme.setAccessToken(accessToken);
        scheme.setSecretToken(secretToken);
        return scheme;
    }

    public static void registerParser(String mimeType, Parser parser) {
        ResponseParserRegistrar.registerParser(mimeType, parser);
    }

    public static void unregisterParser(String mimeType) {
        ResponseParserRegistrar.unregisterParser(mimeType);
    }

    public static void reset() {
        baseURI = DEFAULT_URI;
        port = 8080;
        basePath = "";
        authentication = DEFAULT_AUTH;
        rootPath = "";
        filters = new LinkedList<Filter>();
        requestContentType = null;
        responseContentType = null;
        requestSpecification = null;
        responseSpecification = null;
        keystoreSpec = new NoKeystoreSpecImpl();
        urlEncodingEnabled = true;
    }

    private static TestSpecificationImpl createTestSpecification() {
        return new TestSpecificationImpl(new RequestSpecificationImpl(baseURI, port, basePath, authentication, filters, keystoreSpec, requestContentType, requestSpecification, urlEncodingEnabled), new ResponseSpecificationImpl(rootPath, responseContentType, responseSpecification));
    }
}

