/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.path.json;

import com.jayway.restassured.assertion.AssertParameter;
import com.jayway.restassured.assertion.JSONAssertion;
import com.jayway.restassured.exception.ParsePathException;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.groovy.JsonSlurper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPath {
    private final JSON json;
    private String rootPath = "";

    public JsonPath(String text) {
        this.json = new JsonSlurper().parseText(text);
    }

    public JsonPath(URL url) {
        this.json = this.parseURL(url);
    }

    public JsonPath(InputStream stream) {
        this.json = this.parseInputStream(stream);
    }

    public JsonPath(File file) {
        this.json = this.parseFile(file);
    }

    public JsonPath(Reader reader) {
        this.json = this.parseReader(reader);
    }

    public <T> T get(String path) {
        AssertParameter.notNull(path, "path");
        JSONAssertion jsonAssertion = new JSONAssertion();
        String root = this.rootPath.equals("") ? this.rootPath : (this.rootPath.endsWith(".") ? this.rootPath : this.rootPath + ".");
        jsonAssertion.setKey(root + path);
        return (T)jsonAssertion.getResult(this.json);
    }

    public boolean getBoolean(String path) {
        return (Boolean)this.get(path);
    }

    public char getChar(String path) {
        return ((Character)this.get(path)).charValue();
    }

    public int getInt(String path) {
        return (Integer)this.get(path);
    }

    public byte getByte(String path) {
        return (Byte)this.get(path);
    }

    public short getShort(String path) {
        return (Short)this.get(path);
    }

    public float getFloat(String path) {
        return ((Float)this.get(path)).floatValue();
    }

    public double getDouble(String path) {
        return (Double)this.get(path);
    }

    public long getLong(String path) {
        return (Long)this.get(path);
    }

    public String getString(String path) {
        return (String)this.get(path);
    }

    public <T> List<T> getList(String path) {
        return (List)this.get(path);
    }

    public <T> List<T> getList(String path, Class<T> genericType) {
        return (List)this.get(path);
    }

    public <K, V> Map<K, V> getMap(String path) {
        return (Map)this.get(path);
    }

    public <K, V> Map<K, V> getMap(String path, Class<K> keyType, Class<V> valueType) {
        return (Map)this.get(path);
    }

    public static JsonPath given(String text) {
        return new JsonPath(text);
    }

    public static JsonPath given(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath given(File file) {
        return new JsonPath(file);
    }

    public static JsonPath given(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath given(URL url) {
        return new JsonPath(url);
    }

    public static JsonPath with(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath with(String text) {
        return new JsonPath(text);
    }

    public static JsonPath with(File file) {
        return new JsonPath(file);
    }

    public static JsonPath with(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath with(URL url) {
        return new JsonPath(url);
    }

    public static JsonPath from(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath from(String text) {
        return new JsonPath(text);
    }

    public static JsonPath from(File file) {
        return new JsonPath(file);
    }

    public static JsonPath from(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath from(URL url) {
        return new JsonPath(url);
    }

    public JsonPath setRoot(String rootPath) {
        AssertParameter.notNull(rootPath, "Root path");
        this.rootPath = rootPath;
        return this;
    }

    private JSON parseInputStream(final InputStream stream) {
        return new ExceptionCatcher(){

            protected JSON method(JsonSlurper slurper) throws Exception {
                return slurper.parse(stream);
            }
        }.invoke();
    }

    private JSON parseReader(final Reader reader) {
        return new ExceptionCatcher(){

            protected JSON method(JsonSlurper slurper) throws Exception {
                return slurper.parse(reader);
            }
        }.invoke();
    }

    private JSON parseFile(final File file) {
        return new ExceptionCatcher(){

            protected JSON method(JsonSlurper slurper) throws Exception {
                return slurper.parse(file);
            }
        }.invoke();
    }

    private JSON parseURL(final URL url) {
        return new ExceptionCatcher(){

            protected JSON method(JsonSlurper slurper) throws Exception {
                return slurper.parse(url.toString());
            }
        }.invoke();
    }

    private abstract class ExceptionCatcher {
        private ExceptionCatcher() {
        }

        protected abstract JSON method(JsonSlurper var1) throws Exception;

        public JSON invoke() {
            try {
                return this.method(new JsonSlurper());
            }
            catch (Exception e) {
                throw new ParsePathException("Failed to parse the JSON document", e);
            }
        }
    }
}

