/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase08preparepackage;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.configuration.Dex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

public class DexMojo
extends AbstractAndroidMojo {
    private Dex dex;
    private String[] dexJvmArguments;
    private boolean dexCoreLibrary;
    private boolean dexNoLocals;
    private boolean dexOptimize;
    private boolean dexPreDex;
    private String dexPreDexLibLocation;
    private String[] parsedJvmArguments;
    private boolean parsedCoreLibrary;
    private boolean parsedNoLocals;
    private boolean parsedOptimize;
    private boolean parsedPreDex;
    private String parsedPreDexLibLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = new File(this.project.getBuild().getDirectory() + File.separator + "classes.dex");
        Set<File> inputFiles = this.getDexInputFiles();
        this.parseConfiguration();
        if (this.generateApk) {
            this.runDex(executor, outputFile, inputFiles);
        }
        if (this.attachJar) {
            File jarFile = new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar");
            this.projectHelper.attachArtifact(this.project, "jar", this.project.getArtifact().getClassifier(), jarFile);
        }
        if (this.attachSources) {
            File apksources = this.createApkSourcesFile();
            this.projectHelper.attachArtifact(this.project, "apksources", apksources);
        }
    }

    private Set<File> getDexInputFiles() {
        HashSet<File> inputs = new HashSet<File>();
        File proguardJar = new File(this.project.getBuild().getDirectory(), "proguard-obfuscated.jar");
        this.getLog().debug((CharSequence)("Checking for existence of: " + proguardJar.toString()));
        if (proguardJar.exists()) {
            this.getLog().debug((CharSequence)"Obfuscated jar exists, using that as input");
            inputs.add(proguardJar);
        } else {
            this.getLog().debug((CharSequence)"Using non-obfuscated input");
            inputs.add(new File(this.project.getBuild().getOutputDirectory()));
            for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
                if (artifact.getType().equals("aar")) {
                    String apkLibResDir = this.getLibraryUnpackDirectory(artifact) + "/classes.jar";
                    if (!new File(apkLibResDir).exists()) continue;
                    inputs.add(new File(apkLibResDir));
                    continue;
                }
                if (artifact.getType().equals("so") || artifact.getType().equals("a")) continue;
                inputs.add(artifact.getFile().getAbsoluteFile());
            }
        }
        return inputs;
    }

    private void parseConfiguration() {
        if (this.dex != null) {
            this.parsedJvmArguments = this.dex.getJvmArguments() == null ? this.dexJvmArguments : this.dex.getJvmArguments();
            this.parsedCoreLibrary = this.dex.isCoreLibrary() == null ? this.dexCoreLibrary : this.dex.isCoreLibrary();
            this.parsedNoLocals = this.dex.isNoLocals() == null ? this.dexNoLocals : this.dex.isNoLocals();
            this.parsedOptimize = this.dex.isOptimize() == null ? this.dexOptimize : this.dex.isOptimize();
            this.parsedPreDex = this.dex.isPreDex() == null ? this.dexPreDex : this.dex.isPreDex();
            this.parsedPreDexLibLocation = this.dex.getPreDexLibLocation() == null ? this.dexPreDexLibLocation : this.dex.getPreDexLibLocation();
        } else {
            this.parsedJvmArguments = this.dexJvmArguments;
            this.parsedCoreLibrary = this.dexCoreLibrary;
            this.parsedNoLocals = this.dexNoLocals;
            this.parsedOptimize = this.dexOptimize;
            this.parsedPreDex = this.dexPreDex;
            this.parsedPreDexLibLocation = this.dexPreDexLibLocation;
        }
    }

    private Set<File> preDex(CommandExecutor executor, Set<File> inputFiles) throws MojoExecutionException {
        HashSet<File> filtered = new HashSet<File>();
        this.getLog().info((CharSequence)"Pre dex-ing libraries for faster dex-ing of the final application.");
        for (File inputFile : inputFiles) {
            if (inputFile.getName().matches(".*\\.jar$")) {
                List<String> commands = this.dexDefaultCommands();
                File predexJar = this.predexJarPath(inputFile);
                commands.add("--output=" + predexJar.getAbsolutePath());
                commands.add(inputFile.getAbsolutePath());
                filtered.add(predexJar);
                if (predexJar.isFile() && predexJar.lastModified() >= inputFile.lastModified()) continue;
                this.getLog().info((CharSequence)("Pre-dex ing jar: " + inputFile.getAbsolutePath()));
                String javaExecutable = DexMojo.getJavaExecutable().getAbsolutePath();
                this.getLog().info((CharSequence)(javaExecutable + " " + commands.toString()));
                try {
                    executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
                    continue;
                }
                catch (ExecutionException e) {
                    throw new MojoExecutionException("", (Exception)e);
                }
            }
            filtered.add(inputFile);
        }
        return filtered;
    }

    private File predexJarPath(File inputFile) {
        String slash = File.separator;
        File predexLibsDirectory = new File(this.parsedPreDexLibLocation.trim());
        predexLibsDirectory.mkdirs();
        return new File(predexLibsDirectory.getAbsolutePath() + slash + inputFile.getName());
    }

    private List<String> dexDefaultCommands() throws MojoExecutionException {
        ArrayList<String> commands = new ArrayList<String>();
        if (this.parsedJvmArguments != null) {
            for (String jvmArgument : this.parsedJvmArguments) {
                if (!jvmArgument.startsWith("-")) {
                    jvmArgument = "-" + jvmArgument;
                }
                this.getLog().debug((CharSequence)("Adding jvm argument " + jvmArgument));
                commands.add(jvmArgument);
            }
        }
        commands.add("-jar");
        commands.add(this.getAndroidSdk().getDxJarPath());
        commands.add("--dex");
        return commands;
    }

    private void runDex(CommandExecutor executor, File outputFile, Set<File> inputFiles) throws MojoExecutionException {
        List<String> commands = this.dexDefaultCommands();
        Set<File> filteredFiles = inputFiles;
        if (this.parsedPreDex) {
            filteredFiles = this.preDex(executor, inputFiles);
        }
        if (!this.parsedOptimize) {
            commands.add("--no-optimize");
        }
        if (this.parsedCoreLibrary) {
            commands.add("--core-library");
        }
        commands.add("--output=" + outputFile.getAbsolutePath());
        if (this.parsedNoLocals) {
            commands.add("--no-locals");
        }
        for (File inputFile : filteredFiles) {
            this.getLog().debug((CharSequence)("Adding dex input: " + inputFile.getAbsolutePath()));
            commands.add(inputFile.getAbsolutePath());
        }
        String javaExecutable = DexMojo.getJavaExecutable().getAbsolutePath();
        this.getLog().info((CharSequence)(javaExecutable + " " + commands.toString()));
        try {
            executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private static File getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        String slash = File.separator;
        return new File(javaHome + slash + "bin" + slash + "java");
    }

    protected File createApkSourcesFile() throws MojoExecutionException {
        File apksources = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".apksources");
        FileUtils.deleteQuietly((File)apksources);
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apksources);
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            this.addDirectory(jarArchiver, this.sourceDirectory, "src/main/java");
            this.addJavaResources(jarArchiver, this.project.getBuild().getResources());
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .apksource file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .apksource file.", (Exception)e);
        }
        return apksources;
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = StringUtils.defaultIfEmpty((String)prefix, (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            jarArchiver.addFileSet((FileSet)fileSet);
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources) {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource) {
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists()) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash("src/main/resources"));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }
}

