/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.internal.PathToken;
import com.jayway.jsonpath.internal.filter.ArrayEvalFilter;
import com.jayway.jsonpath.internal.filter.ArrayIndexFilter;
import com.jayway.jsonpath.internal.filter.ArrayQueryFilter;
import com.jayway.jsonpath.internal.filter.FieldFilter;
import com.jayway.jsonpath.internal.filter.HasFieldFilter;
import com.jayway.jsonpath.internal.filter.PassthroughFilter;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.internal.filter.ScanFilter;
import com.jayway.jsonpath.internal.filter.WildcardFilter;

public class FilterFactory {
    private static final PathTokenFilter DOCUMENT_FILTER = new PassthroughFilter("$", false);
    private static final PathTokenFilter ALL_ARRAY_ITEMS_FILTER = new PassthroughFilter("[*]", true);
    private static final PathTokenFilter WILDCARD_FILTER = new WildcardFilter("*");
    private static final PathTokenFilter SCAN_FILTER = new ScanFilter("..");
    private static final PathTokenFilter ARRAY_QUERY_FILTER = new ArrayQueryFilter("[?]");

    public static PathTokenFilter createFilter(PathToken token) {
        String pathFragment = token.getFragment();
        if (DOCUMENT_FILTER.getCondition().equals(pathFragment) && token.isRootToken()) {
            return DOCUMENT_FILTER;
        }
        if (ALL_ARRAY_ITEMS_FILTER.getCondition().equals(pathFragment)) {
            return ALL_ARRAY_ITEMS_FILTER;
        }
        if ("*".equals(pathFragment)) {
            return WILDCARD_FILTER;
        }
        if (SCAN_FILTER.getCondition().equals(pathFragment)) {
            return SCAN_FILTER;
        }
        if (ARRAY_QUERY_FILTER.getCondition().equals(pathFragment)) {
            return ARRAY_QUERY_FILTER;
        }
        if (!pathFragment.contains("[")) {
            return new FieldFilter(token);
        }
        if (pathFragment.contains("[")) {
            if (pathFragment.startsWith("[?")) {
                if (ArrayEvalFilter.isConditionStatement(pathFragment)) {
                    return new ArrayEvalFilter(pathFragment);
                }
                if (!(pathFragment.contains("=") || pathFragment.contains("<") || pathFragment.contains(">"))) {
                    return new HasFieldFilter(pathFragment);
                }
                throw new InvalidPathException("Failed to create PathTokenFilter for path fragment: " + pathFragment);
            }
            return new ArrayIndexFilter(pathFragment);
        }
        throw new UnsupportedOperationException("can not find filter for path fragment " + pathFragment);
    }
}

