/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.reader.filter;

import com.jayway.jsonpath.reader.filter.ArrayEvalFilter;
import com.jayway.jsonpath.reader.filter.ArrayIndexFilter;
import com.jayway.jsonpath.reader.filter.FieldFilter;
import com.jayway.jsonpath.reader.filter.Filter;
import com.jayway.jsonpath.reader.filter.HasFieldFilter;
import com.jayway.jsonpath.reader.filter.PassThrewFilter;
import com.jayway.jsonpath.reader.filter.ScanFilter;
import com.jayway.jsonpath.reader.filter.WildcardFilter;

public class FilterFactory {
    private static final Filter DOCUMENT_FILTER = new PassThrewFilter("$");
    private static final Filter ALL_ARRAY_ITEMS_FILTER = new PassThrewFilter("[*]");
    private static final Filter WILDCARD_FILTER = new WildcardFilter("*");
    private static final Filter SCAN_FILTER = new ScanFilter("..");

    public static Filter createFilter(String pathFragment) {
        if ("$".equals(pathFragment)) {
            return DOCUMENT_FILTER;
        }
        if ("[*]".equals(pathFragment)) {
            return ALL_ARRAY_ITEMS_FILTER;
        }
        if ("*".equals(pathFragment)) {
            return WILDCARD_FILTER;
        }
        if (pathFragment.contains("..")) {
            return SCAN_FILTER;
        }
        if (!pathFragment.contains("[")) {
            return new FieldFilter(pathFragment);
        }
        if (pathFragment.contains("[")) {
            if (pathFragment.startsWith("[?")) {
                if (!(pathFragment.contains("=") || pathFragment.contains("<") || pathFragment.contains(">"))) {
                    return new HasFieldFilter(pathFragment);
                }
                return new ArrayEvalFilter(pathFragment);
            }
            return new ArrayIndexFilter(pathFragment);
        }
        throw new UnsupportedOperationException("..");
    }
}

