/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.PathUtil;
import com.jayway.jsonpath.filter.JsonPathFilterChain;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPath {
    private static final Logger log = Logger.getLogger(JsonPath.class.getName());
    private static JSONParser JSON_PARSER = new JSONParser();
    private JsonPathFilterChain filters;

    private JsonPath(String jsonPath) {
        if (jsonPath == null || jsonPath.trim().isEmpty() || jsonPath.matches("new ") || jsonPath.matches("[^\\?\\+\\=\\-\\*\\/\\!]\\(")) {
            throw new InvalidPathException("Invalid path");
        }
        this.filters = new JsonPathFilterChain(PathUtil.splitPath(jsonPath));
    }

    public <T> List<T> read(Object json) {
        return this.filters.filter(json);
    }

    public <T> List<T> read(String json) throws java.text.ParseException {
        return this.read(JsonPath.parse(json));
    }

    public static JsonPath compile(String jsonPath) {
        return new JsonPath(jsonPath);
    }

    public static <T> List<T> read(String json, String jsonPath) throws java.text.ParseException {
        return JsonPath.compile(jsonPath).read(json);
    }

    public static <T> List<T> read(Object json, String jsonPath) {
        return JsonPath.compile(jsonPath).read(json);
    }

    public static <T> T readOne(Object json, String jsonPath) {
        JsonPath.compile(jsonPath);
        List<T> result = JsonPath.read(json, jsonPath);
        if (log.isLoggable(Level.WARNING) && !PathUtil.isPathDefinite(jsonPath)) {
            log.warning("Using readOne() on a not definite json path may give incorrect results. Path : " + jsonPath);
        }
        if (result.size() > 1) {
            throw new RuntimeException(String.format("Expected one result when reading path: %s  but was: ", jsonPath, result.size()));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public static <T> T readOne(String json, String jsonPath) throws java.text.ParseException {
        return JsonPath.readOne(JsonPath.parse(json), jsonPath);
    }

    private static Object parse(String json) throws java.text.ParseException {
        try {
            return JSON_PARSER.parse(json);
        }
        catch (ParseException e) {
            throw new java.text.ParseException(json, e.getPosition());
        }
    }
}

