/*
 * Decompiled with CFR 0.152.
 */
package com.jaychang.sa.twitter;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.jaychang.sa.AuthData;
import com.jaychang.sa.AuthDataHolder;
import com.jaychang.sa.DialogUtils;
import com.jaychang.sa.SimpleAuthActivity;
import com.jaychang.sa.SocialUser;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterAuthToken;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.identity.TwitterAuthClient;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.core.services.AccountService;
import retrofit2.Call;
import retrofit2.Callback;

public class TwitterAuthActivity
extends SimpleAuthActivity {
    private static final String PROFILE_PIC_URL = "https://twitter.com/%1$s/profile_image?size=original";
    private static final String PAGE_LINK = "https://twitter.com/%1$s";
    private TwitterAuthClient twitterAuthClient;
    private com.twitter.sdk.android.core.Callback<TwitterSession> callback = new com.twitter.sdk.android.core.Callback<TwitterSession>(){

        public void success(Result<TwitterSession> result) {
            TwitterAuthActivity.this.handleSuccess((TwitterSession)result.data);
        }

        public void failure(TwitterException exception) {
            TwitterAuthActivity.this.handleError((Throwable)exception);
        }
    };

    public static void start(Context context) {
        Intent intent = new Intent(context, TwitterAuthActivity.class);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TwitterSession activeSession = (TwitterSession)TwitterCore.getInstance().getSessionManager().getActiveSession();
        if (activeSession != null) {
            this.handleSuccess(activeSession);
        } else {
            this.getTwitterAuthClient().authorize((Activity)this, this.callback);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 0) {
            this.handleCancel();
            return;
        }
        if (requestCode == this.getTwitterAuthClient().getRequestCode()) {
            this.getTwitterAuthClient().onActivityResult(requestCode, resultCode, data);
        }
    }

    private void handleSuccess(final TwitterSession session) {
        final ProgressDialog loadingDialog = DialogUtils.createLoadingDialog((Context)this);
        loadingDialog.show();
        TwitterApiClient twitterApiClient = TwitterCore.getInstance().getApiClient();
        AccountService accountService = twitterApiClient.getAccountService();
        Call call = accountService.verifyCredentials(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true));
        call.enqueue((Callback)new com.twitter.sdk.android.core.Callback<User>(){

            public void success(Result<User> userResult) {
                loadingDialog.dismiss();
                SocialUser user = new SocialUser();
                User data = (User)userResult.data;
                user.userId = String.valueOf(data.getId());
                user.accessToken = ((TwitterAuthToken)session.getAuthToken()).token;
                user.profilePictureUrl = String.format(TwitterAuthActivity.PROFILE_PIC_URL, data.screenName);
                user.email = data.email != null ? data.email : "";
                user.fullName = data.name;
                user.username = data.screenName;
                user.pageLink = String.format(TwitterAuthActivity.PAGE_LINK, data.screenName);
                TwitterAuthActivity.this.handleSuccess(user);
            }

            public void failure(TwitterException error) {
                loadingDialog.dismiss();
                TwitterAuthActivity.this.handleError((Throwable)error);
            }
        });
    }

    protected void handleCancel() {
        this.getTwitterAuthClient().cancelAuthorize();
        super.handCancel();
    }

    protected AuthData getAuthData() {
        return AuthDataHolder.getInstance().twitterAuthData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TwitterAuthClient getTwitterAuthClient() {
        if (this.twitterAuthClient != null) return this.twitterAuthClient;
        Class<TwitterAuthActivity> clazz = TwitterAuthActivity.class;
        synchronized (TwitterAuthActivity.class) {
            if (this.twitterAuthClient != null) return this.twitterAuthClient;
            this.twitterAuthClient = new TwitterAuthClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.twitterAuthClient;
        }
    }
}

