/*
 * Decompiled with CFR 0.152.
 */
package com.jaychang.sac.jsonparser.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jaychang.sac.JsonParser;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jaychang/sac/jsonparser/gson/GsonJsonParser;", "Lcom/jaychang/sac/JsonParser;", "()V", "gson", "Lcom/google/gson/Gson;", "createGson", "type", "Ljava/lang/reflect/Type;", "keyPath", "", "getConverterFactory", "Lretrofit2/Converter$Factory;", "parse", "T", "json", "typeOfT", "(Ljava/lang/String;Ljava/lang/reflect/Type;Ljava/lang/String;)Ljava/lang/Object;", "update", "", "KeyPathDeserializer", "library-jsonparser-gson_release"})
public final class GsonJsonParser
implements JsonParser {
    private Gson gson = new Gson();

    @NotNull
    public Converter.Factory getConverterFactory() {
        GsonConverterFactory gsonConverterFactory = GsonConverterFactory.create((Gson)this.gson);
        Intrinsics.checkExpressionValueIsNotNull((Object)gsonConverterFactory, (String)"GsonConverterFactory.create(gson)");
        return (Converter.Factory)gsonConverterFactory;
    }

    public <T> T parse(@NotNull String json, @NotNull Type typeOfT, @Nullable String keyPath) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
        return (T)(keyPath == null ? this.gson.fromJson(json, typeOfT) : this.createGson(typeOfT, keyPath).fromJson(json, typeOfT));
    }

    public void update(@NotNull Type type, @NotNull String keyPath) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)keyPath, (String)"keyPath");
        this.gson = this.createGson(type, keyPath);
    }

    private final Gson createGson(Type type, String keyPath) {
        KeyPathDeserializer deserializer = new KeyPathDeserializer(keyPath);
        Gson gson = new GsonBuilder().registerTypeAdapter(type, (Object)deserializer).create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"GsonBuilder().registerTy\u2026e, deserializer).create()");
        return gson;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jaychang/sac/jsonparser/gson/GsonJsonParser$KeyPathDeserializer;", "Lcom/google/gson/JsonDeserializer;", "", "keyPath", "", "(Ljava/lang/String;)V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "library-jsonparser-gson_release"})
    private static final class KeyPathDeserializer
    implements JsonDeserializer<Object> {
        private final String keyPath;

        @NotNull
        public Object deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            List parts = StringsKt.split$default((CharSequence)this.keyPath, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement jsonElement = jsonObject.get((String)parts.get(0));
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"jsonObject[parts[0]]");
            JsonElement jsonElement2 = jsonElement;
            for (String part : parts) {
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject.get(part), (String)"jsonObject[part]");
                if (!(jsonElement2 instanceof JsonObject)) continue;
                jsonObject = ((JsonObject)jsonElement2).getAsJsonObject();
            }
            Object object = new Gson().fromJson(jsonElement2, typeOfT);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Gson().fromJson(jsonElement, typeOfT)");
            return object;
        }

        public KeyPathDeserializer(@NotNull String keyPath) {
            Intrinsics.checkParameterIsNotNull((Object)keyPath, (String)"keyPath");
            this.keyPath = keyPath;
        }
    }
}

