/*
 * Decompiled with CFR 0.152.
 */
package scriptella.tools.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import scriptella.core.SystemException;
import scriptella.util.IOUtils;
import scriptella.util.PropertiesMap;
import scriptella.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateManager {
    private static final String DEFAULT_ETL_XML = "default.etl.xml";
    private static final String DEFAULT_ETL_PROPS = "default.etl.properties";
    private static final String DEFAULT_BASE_NAME = "etl";
    protected static final String XML_EXT = ".xml";
    protected static final String PROPS_EXT = ".properties";
    private static final String PACKAGE_NAME = TemplateManager.class.getName().substring(0, TemplateManager.class.getName().lastIndexOf(46));
    static final TemplateManager DEFAULT = new TemplateManager();
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public void create(Map<String, ?> properties) throws IOException {
        String baseName = this.defineName();
        String xmlName = baseName + XML_EXT;
        String propsName = baseName + PROPS_EXT;
        Writer w = this.newFileWriter(xmlName);
        w.write(MessageFormat.format(this.loadResourceAsString(DEFAULT_ETL_XML), propsName));
        w.close();
        w = this.newFileWriter(propsName);
        w.write(this.loadResourceAsString(DEFAULT_ETL_PROPS));
        w.close();
        this.logger.info("Files " + xmlName + ", " + propsName + " have been successfully created.");
    }

    protected String loadResourceAsString(String resourcePath) throws IOException {
        InputStream xml = this.getClass().getResourceAsStream(resourcePath);
        if (xml == null) {
            throw new FileNotFoundException("Resource " + resourcePath + " not found");
        }
        return IOUtils.toString((Reader)new InputStreamReader(xml));
    }

    protected String defineName() {
        for (int i = 0; i < 10; ++i) {
            String name = DEFAULT_BASE_NAME + (i > 0 ? "[" + i + "]" : "");
            if (this.checkFile(name + XML_EXT) && this.checkFile(name + PROPS_EXT)) {
                return name;
            }
            this.logger.info("File for template " + name + " already exists, trying the next available name.");
        }
        throw new IllegalStateException("Too many templates generated. Remove unused.");
    }

    protected Writer newFileWriter(String fileName) throws IOException {
        return new FileWriter(fileName);
    }

    protected boolean checkFile(String name) {
        File f = new File(name);
        return !f.exists();
    }

    public static void create(String name, String propertiesFile) throws IOException {
        TemplateManager template = DEFAULT;
        PropertiesMap map = Collections.emptyMap();
        if (!StringUtils.isEmpty((CharSequence)name)) {
            template = TemplateManager.forName(name);
            File filePath = new File(StringUtils.isEmpty((CharSequence)propertiesFile) ? name + PROPS_EXT : propertiesFile);
            if (filePath.isFile()) {
                map = new PropertiesMap((InputStream)new FileInputStream(filePath));
            } else if (!StringUtils.isEmpty((CharSequence)propertiesFile)) {
                throw new FileNotFoundException("File " + filePath.toString() + " not found");
            }
        }
        template.create((Map<String, ?>)map);
    }

    public static TemplateManager forName(String name) {
        String className = PACKAGE_NAME + '.' + name;
        try {
            Class<?> cl = Class.forName(className);
            return (TemplateManager)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SystemException("Template " + name + " not found", (Throwable)e);
        }
        catch (Exception e) {
            throw new SystemException("Cannot initialize template " + name, (Throwable)e);
        }
    }
}

