/*
 * Decompiled with CFR 0.152.
 */
package scriptella.tools.template;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import scriptella.core.SystemException;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.jdbc.JdbcException;
import scriptella.jdbc.JdbcUtils;
import scriptella.tools.template.TemplateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMigrator
extends TemplateManager {
    static final String DRIVER_PROPERTY_NAME = "driver";
    static final String URL_PROPERTY_NAME = "url";
    static final String USER_PROPERTY_NAME = "user";
    static final String PASSWORD_PROPERTY_NAME = "password";
    static final String CATALOG_PROPERTY_NAME = "catalog";
    static final String SCHEMA_PROPERTY_NAME = "schema";
    private static final String DATA_MIGRATOR_ETL_XML = "dataMigrator.etl.xml";
    private static final String DATA_MIGRATOR_ETL_PROPERTIES = "dataMigrator.etl.properties";
    private static final String DATA_MIGRATOR_BLOCK_ETL_XML = "dataMigratorBlock.etl.xml";
    private static Logger LOG = Logger.getLogger(DataMigrator.class.getName());
    static boolean DEBUG = LOG.isLoggable(Level.FINE);

    @Override
    public void create(Map<String, ?> properties) throws IOException {
        String baseName = this.defineName();
        String xmlName = baseName + ".xml";
        String propsName = baseName + ".properties";
        String etlXml = this.loadResourceAsString(DATA_MIGRATOR_ETL_XML);
        String block = this.loadResourceAsString(DATA_MIGRATOR_BLOCK_ETL_XML);
        DbSchema schema = DbSchema.initialize(properties);
        Set<String> tables = DataMigrator.sortTables(schema);
        StringBuilder queriesXml = new StringBuilder(block.length() * tables.size());
        HashMap<String, String> params = new HashMap<String, String>();
        PropertiesSubstitutor ps = new PropertiesSubstitutor(params);
        StringBuilder tmp = new StringBuilder();
        for (String table : tables) {
            params.put("table", table);
            tmp.setLength(0);
            DataMigrator.appendColumnNames(schema, table, tmp);
            params.put("columns", tmp.toString());
            tmp.setLength(0);
            DataMigrator.appendColumnNames(schema, table, tmp, ", ", "?");
            params.put("values", tmp.toString());
            queriesXml.append(ps.substitute(block));
        }
        params.put("etl.properties", propsName);
        params.put("queries", queriesXml.toString());
        Writer w = this.newFileWriter(xmlName);
        w.write(ps.substitute(etlXml));
        w.close();
        w = this.newFileWriter(propsName);
        w.write(this.loadResourceAsString(DATA_MIGRATOR_ETL_PROPERTIES));
        w.close();
    }

    private static StringBuilder appendColumnNames(DbSchema schema, String table, StringBuilder sql) {
        return DataMigrator.appendColumnNames(schema, table, sql, ", ", "");
    }

    private static StringBuilder appendColumnNames(DbSchema schema, String table, StringBuilder sql, String separator, String prefix) {
        Set<String> tableColumns = schema.getTableColumns(table);
        Iterator<String> it = tableColumns.iterator();
        while (it.hasNext()) {
            String s = it.next();
            sql.append(prefix);
            sql.append(s);
            if (!it.hasNext()) continue;
            sql.append(separator);
        }
        return sql;
    }

    private static Set<String> sortTables(DbSchema schema) {
        List<String> tables = schema.getTables();
        LOG.fine("Sorting " + tables);
        int n = tables.size();
        String[] tbls = tables.toArray(new String[n]);
        try {
            int[][] m = DataMigrator.getTablesMatrix(schema, tbls);
            StringBuilder msg = DEBUG ? new StringBuilder() : null;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (!DEBUG) continue;
                    msg.append(m[i][j]);
                    msg.append(m[i][j] >= 10 ? " " : "  ");
                }
                if (!DEBUG) continue;
                msg.append(tbls[i]).append('\n');
            }
            if (DEBUG) {
                LOG.fine("Tables dependencies matrix: \n" + msg);
            }
            boolean[] free = new boolean[n];
            Arrays.fill(free, true);
            LinkedHashSet<String> res = new LinkedHashSet<String>();
            for (int i = 0; i < n; ++i) {
                int min = Integer.MAX_VALUE;
                int minI = -1;
                for (int j = 0; j < n; ++j) {
                    int s = 0;
                    if (!free[j]) continue;
                    for (int k = 0; k < n; ++k) {
                        if (k == j || !free[k]) continue;
                        s += m[k][j];
                    }
                    if (s >= min) continue;
                    min = s;
                    minI = j;
                }
                if (minI < 0) continue;
                free[minI] = false;
                res.add(tbls[minI]);
            }
            return res;
        }
        catch (SQLException e) {
            throw new JdbcException(e.getMessage(), (Throwable)e);
        }
    }

    private static int[][] getTablesMatrix(DbSchema schema, String[] tables) throws SQLException {
        int[][] m;
        DatabaseMetaData metaData = schema.getMetaData();
        int n = tables.length;
        for (int[] a : m = new int[n][n]) {
            Arrays.fill(a, 0);
        }
        for (int i = 0; i < n; ++i) {
            ResultSet rs = metaData.getExportedKeys(schema.getCatalog(), schema.getSchema(), tables[i]);
            while (rs.next()) {
                String t2 = rs.getString("FKTABLE_NAME");
                int i2 = DataMigrator.indexOf(tables, t2);
                if (i2 < 0) continue;
                int[] nArray = m[i];
                int n2 = i2;
                nArray[n2] = nArray[n2] + (rs.getInt("DELETE_RULE") != 2 ? 10 : 1);
            }
            rs.close();
        }
        return m;
    }

    private static int indexOf(String[] list, String element) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equalsIgnoreCase(element)) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbSchema {
        private Connection connection;
        private DatabaseMetaData metaData;
        private String catalog;
        private String schema;

        public DbSchema(Connection connection, String catalog, String schema) {
            this.connection = connection;
            this.catalog = catalog;
            this.schema = schema;
        }

        static DbSchema initialize(Map<String, ?> props) {
            String driver = (String)props.get(DataMigrator.DRIVER_PROPERTY_NAME);
            if (driver == null) {
                throw new IllegalArgumentException("driver property is required");
            }
            String jdbcUrl = (String)props.get(DataMigrator.URL_PROPERTY_NAME);
            if (jdbcUrl == null) {
                throw new IllegalArgumentException("url property is required");
            }
            String user = (String)props.get(DataMigrator.USER_PROPERTY_NAME);
            String password = (String)props.get(DataMigrator.PASSWORD_PROPERTY_NAME);
            String catalog = (String)props.get(DataMigrator.CATALOG_PROPERTY_NAME);
            String schema = (String)props.get(DataMigrator.SCHEMA_PROPERTY_NAME);
            try {
                Class.forName(driver);
                return new DbSchema(DriverManager.getConnection(jdbcUrl, user, password), catalog, schema);
            }
            catch (ClassNotFoundException e) {
                throw new SystemException("Cannot lookup JDBC driver " + driver, (Throwable)e);
            }
            catch (SQLException e) {
                throw new SystemException("Cannot initialize JDBC connection " + jdbcUrl, (Throwable)e);
            }
        }

        List<String> getTables() {
            try {
                return DbSchema.getColumn(this.getMetaData().getTables(this.catalog, this.schema, null, new String[]{"TABLE"}), 3);
            }
            catch (SQLException e) {
                throw new JdbcException(e.getMessage(), (Throwable)e);
            }
        }

        Set<String> getTableColumns(String tableName) {
            try {
                return new HashSet<String>(DbSchema.getColumn(this.getMetaData().getColumns(this.catalog, this.schema, tableName, null), 4));
            }
            catch (SQLException e) {
                throw new JdbcException(e.getMessage(), (Throwable)e);
            }
        }

        static List<String> getColumn(ResultSet rs, int columnPos) {
            ArrayList<String> l = new ArrayList<String>();
            try {
                while (rs.next()) {
                    l.add(rs.getString(columnPos));
                }
            }
            catch (SQLException e) {
                throw new JdbcException("Unable to get column #" + columnPos, (Throwable)e);
            }
            finally {
                JdbcUtils.closeSilent((ResultSet)rs);
            }
            return l;
        }

        public DatabaseMetaData getMetaData() {
            if (this.metaData == null) {
                try {
                    this.metaData = this.connection.getMetaData();
                }
                catch (SQLException e) {
                    throw new JdbcException("Unable to get database metadata", (Throwable)e);
                }
            }
            return this.metaData;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }
    }
}

