/*
 * Decompiled with CFR 0.152.
 */
package scriptella.tools.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import scriptella.configuration.ConfigurationEl;
import scriptella.configuration.ConfigurationFactory;
import scriptella.execution.EtlExecutor;
import scriptella.execution.EtlExecutorException;
import scriptella.execution.ExecutionStatistics;
import scriptella.execution.JmxEtlManager;
import scriptella.interactive.ConsoleProgressIndicator;
import scriptella.interactive.LoggingConfigurer;
import scriptella.interactive.ProgressIndicator;
import scriptella.spi.AbstractScriptellaDriver;
import scriptella.tools.launcher.BugReport;
import scriptella.tools.template.TemplateManager;
import scriptella.util.CollectionUtils;
import scriptella.util.IOUtils;
import scriptella.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EtlLauncher {
    private static final Logger LOG = Logger.getLogger(EtlLauncher.class.getName());
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;
    public static final Formatter STD_FORMATTER = new Formatter(){
        private final MessageFormat f = new MessageFormat("{0,date} {0,time} <{1}> {2}");
        private final Object[] args = new Object[3];
        private final StringBuffer sb = new StringBuffer();
        private final Date d = new Date();

        public synchronized String format(LogRecord record) {
            this.d.setTime(record.getMillis());
            this.args[0] = this.d;
            this.args[1] = record.getLevel().getLocalizedName();
            this.args[2] = record.getMessage();
            this.f.format(this.args, this.sb, (FieldPosition)null);
            Throwable err = record.getThrown();
            this.sb.append('\n');
            if (err != null) {
                this.sb.append(err.getMessage());
                this.sb.append('\n');
            }
            String s = this.sb.toString();
            this.sb.setLength(0);
            return s;
        }
    };
    private EtlExecutor exec = new EtlExecutor();
    private ConfigurationFactory factory = new ConfigurationFactory();
    private ProgressIndicator indicator;
    private Map<String, ?> properties;
    public static final String DEFAULT_FILE_NAME = "etl.xml";

    public EtlLauncher() {
        this.exec.setJmxEnabled(true);
    }

    public void setNoStat(boolean suppressStatistics) {
        this.exec.setSuppressStatistics(suppressStatistics);
    }

    ErrorCode launch(String[] args) {
        ConsoleHandler h = new ConsoleHandler();
        h.setFormatter(STD_FORMATTER);
        h.setLevel(Level.INFO);
        boolean failed = false;
        ArrayList<File> files = new ArrayList<File>();
        ConsoleProgressIndicator indicator = new ConsoleProgressIndicator("Execution Progress");
        try {
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
            while (!arguments.isEmpty()) {
                String arg = (String)arguments.get(0);
                arguments.remove(0);
                if (arg.startsWith("-h")) {
                    this.printUsage();
                    return ErrorCode.OK;
                }
                if (arg.startsWith("-d")) {
                    h.setLevel(Level.FINE);
                    continue;
                }
                if (arg.startsWith("-q")) {
                    h.setLevel(Level.WARNING);
                    continue;
                }
                if (arg.startsWith("-v")) {
                    this.printVersion();
                    return ErrorCode.OK;
                }
                if (arg.startsWith("-t")) {
                    return this.template(arguments);
                }
                if (arg.startsWith("-nostat")) {
                    this.setNoStat(true);
                    continue;
                }
                if (arg.startsWith("-")) {
                    err.println("Unrecognized option " + arg);
                    return ErrorCode.UNRECOGNIZED_OPTION;
                }
                if (arg.startsWith("-")) continue;
                files.add(this.resolveFile(null, arg));
            }
            if (files.isEmpty()) {
                files.add(this.resolveFile(null, null));
            }
        }
        catch (FileNotFoundException e) {
            err.println(e.getMessage());
            return ErrorCode.FILE_NOT_FOUND;
        }
        if (indicator != null) {
            this.setProgressIndicator((ProgressIndicator)indicator);
        }
        LoggingConfigurer.configure((Handler)h);
        if (this.properties == null) {
            this.setProperties(CollectionUtils.asMap((Properties)System.getProperties()));
        }
        for (File file : files) {
            try {
                this.execute(file);
            }
            catch (Exception e) {
                failed = true;
                LOG.log(Level.SEVERE, "Script " + file + " execution failed.", e);
                if (BugReport.isPossibleBug(e)) {
                    LOG.log(Level.SEVERE, new BugReport(e).toString());
                    continue;
                }
                if (h.getLevel().intValue() >= Level.INFO.intValue()) continue;
                err.println("---------------Debug Stack Trace-----------------");
                Throwable t = e.getCause() == null ? e : e.getCause();
                t.printStackTrace();
            }
        }
        LoggingConfigurer.remove((Handler)h);
        return failed ? ErrorCode.FAILED : ErrorCode.OK;
    }

    protected void printVersion() {
        String v = AbstractScriptellaDriver.getScriptellaVersion();
        String p = AbstractScriptellaDriver.getScriptellaTitle();
        if (p != null && v != null) {
            out.println(p + " Version " + v);
        } else {
            out.println("Scriptella version information unavailable");
        }
    }

    protected void printUsage() {
        out.println("scriptella [-options] [<file 1> ... <file N>]");
        out.println("Options:");
        out.println("  -help,     -h        display help ");
        out.println("  -debug,    -d        print debugging information");
        out.println("  -quiet,    -q        be extra quiet");
        out.println("  -version,  -v        print version");
        out.println("  -template, -t        creates an etl.xml template file in the current directory");
    }

    protected ErrorCode template(List<String> args) {
        try {
            String name = args.isEmpty() ? null : args.get(0);
            String props = null;
            if (name != null) {
                args.remove(0);
                props = args.isEmpty() ? null : args.get(0);
            }
            TemplateManager.create(name, props);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Template generation failed", e);
            return ErrorCode.FAILED;
        }
        return ErrorCode.OK;
    }

    public void setProperties(Map<String, ?> props) {
        this.properties = props;
    }

    public void setProgressIndicator(ProgressIndicator indicator) {
        this.indicator = indicator;
    }

    public void execute(File file) throws EtlExecutorException {
        try {
            this.factory.setResourceURL(IOUtils.toUrl((File)file));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Wrong file path " + file.getPath(), e);
        }
        this.factory.setExternalParameters(this.properties);
        ConfigurationEl c = this.factory.createConfiguration();
        this.exec.setConfiguration(c);
        ExecutionStatistics st = this.exec.execute(this.indicator);
        if (LOG.isLoggable(Level.INFO)) {
            if (!this.exec.isSuppressStatistics()) {
                LOG.info("Execution statistics:\n" + st.toString());
            }
            LOG.info("Successfully executed ETL file " + file);
        }
    }

    public File resolveFile(File dir, String name) throws FileNotFoundException {
        File f;
        if (StringUtils.isEmpty((CharSequence)name)) {
            f = new File(dir, DEFAULT_FILE_NAME);
        } else {
            f = new File(dir, name);
            if (!this.isFile(f) && name.indexOf(46) < 0) {
                f = new File(dir, name + '.' + DEFAULT_FILE_NAME);
            }
        }
        if (!this.isFile(f)) {
            throw new FileNotFoundException("ETL file " + f + " was not found.");
        }
        return f.getAbsoluteFile();
    }

    protected boolean isFile(File file) {
        return file.isFile();
    }

    public static void main(String[] args) {
        EtlLauncher launcher = new EtlLauncher();
        System.exit(launcher.launch(args).getErrorCode());
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(EtlShutdownHook.INSTANCE);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to add shutdown hook. ETL will not be rolled back on abnormal termination.", e);
        }
    }

    private static class EtlShutdownHook
    extends Thread {
        private static final EtlShutdownHook INSTANCE = new EtlShutdownHook();

        private EtlShutdownHook() {
            this.setName("ETL Cancellation Thread");
        }

        public void run() {
            int i;
            if (!JmxEtlManager.findEtlMBeans().isEmpty()) {
                System.out.println("Cancelling ETL tasks and rolling back changes...");
            }
            if ((i = JmxEtlManager.cancelAll()) > 1) {
                System.out.println(i + " ETL tasks cancelled");
            } else if (i == 1) {
                System.out.println("ETL cancelled");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorCode {
        OK(0),
        FAILED(1),
        FILE_NOT_FOUND(2),
        UNRECOGNIZED_OPTION(3);

        private int errorCode;

        private ErrorCode(int code) {
            this.errorCode = code;
        }

        public int getErrorCode() {
            return this.errorCode;
        }
    }
}

