/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import java.util.ArrayList;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.Lock;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.util.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SupportedLockProperty
extends BaseProperty {
    public static final String TAG_NAME = "supportedlock";

    public SupportedLockProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public Lock[] getLockEntries() {
        NodeList children = this.element.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        ArrayList<Lock> locks = new ArrayList<Lock>();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            try {
                String localName;
                Element child = (Element)children.item(i2);
                String namespace = DOMUtils.getElementNamespaceURI(child);
                if (namespace == null || !namespace.equals("DAV:") || !"lockentry".equals(localName = DOMUtils.getElementLocalName(child))) continue;
                locks.add(this.parseLock(child));
                continue;
            }
            catch (ClassCastException e2) {
                // empty catch block
            }
        }
        return locks.toArray(new Lock[locks.size()]);
    }

    protected Lock parseLock(Element element) {
        Element lockType;
        int ls = -1;
        Element child = DOMUtils.getFirstElement(element, "DAV:", "lockscope");
        if (child != null) {
            Element lockScope = DOMUtils.getFirstElement(child, "DAV:", "exclusive");
            if (lockScope != null) {
                ls = 0;
            }
            if ((lockScope = DOMUtils.getFirstElement(child, "DAV:", "shared")) != null) {
                ls = 1;
            }
        }
        int lt = -1;
        child = DOMUtils.getFirstElement(element, "DAV:", "locktype");
        if (child != null && (lockType = DOMUtils.getFirstElement(child, "DAV:", "write")) != null) {
            lt = 0;
        }
        return new Lock(ls, lt);
    }

    public String getPropertyAsString() {
        Lock[] locks = this.getLockEntries();
        if (locks == null || locks.length == 0) {
            return "";
        }
        StringBuffer tmp = new StringBuffer(locks[0].toString());
        for (int i2 = 1; i2 < locks.length; ++i2) {
            tmp.append(", ");
            tmp.append(locks[i2].toString());
        }
        return tmp.toString();
    }
}

