/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class UnsubscribeMethod
extends XMLResponseMethodBase {
    private static final String HEADER_SUBSCRIPTION_ID = "Subscription-Id";
    private List subscriptionIds = new ArrayList();

    public UnsubscribeMethod() {
    }

    public UnsubscribeMethod(String path) {
        super(path);
    }

    public void addSubscriptionId(int id) {
        this.subscriptionIds.add(new Integer(id));
    }

    public String getName() {
        return "UNSUBSCRIBE";
    }

    public void recycle() {
        super.recycle();
        this.subscriptionIds.clear();
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (this.subscriptionIds.size() > 0) {
            StringBuffer b2 = new StringBuffer();
            boolean first = true;
            Iterator i2 = this.subscriptionIds.iterator();
            while (i2.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    b2.append(", ");
                }
                b2.append(i2.next());
            }
            super.addRequestHeader(HEADER_SUBSCRIPTION_ID, b2.toString());
        }
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase(HEADER_SUBSCRIPTION_ID)) {
            StringTokenizer t = new StringTokenizer(headerValue, ", ");
            try {
                while (t.hasMoreTokens()) {
                    this.addSubscriptionId(Integer.parseInt(t.nextToken()));
                }
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException("Invalid header value '" + headerValue + "' for header " + headerName + "!");
            }
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }
}

