/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpState;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.util.XMLPrinter;

public class ReportMethod
extends XMLResponseMethodBase
implements DepthSupport {
    public static final int SUB_SET = 0;
    public static final int ALL = 1;
    public static final int LOCATE_HISTORY = 2;
    public String sVersionHistory = "";
    private String preloadedQuery = null;
    protected int type = 1;
    protected PropertyName[] propertyNames;
    protected int depth = Integer.MAX_VALUE;
    protected String prefix = null;

    public ReportMethod() {
    }

    public ReportMethod(String path) {
        super(path);
    }

    public ReportMethod(String path, int depth) {
        this(path);
        this.setDepth(depth);
    }

    public ReportMethod(String path, Enumeration propertyNames) {
        this(path);
        this.setDepth(1);
        this.setPropertyNames(propertyNames);
        this.setType(0);
    }

    public ReportMethod(String path, int depth, Enumeration propertyNames, Enumeration histUrl) {
        this(path);
        this.setDepth(depth);
        this.setPropertyNames(propertyNames);
        this.setHistoryURLs(histUrl);
        this.setType(2);
    }

    public ReportMethod(String path, int depth, Enumeration propertyNames) {
        this(path);
        this.setDepth(depth);
        this.setPropertyNames(propertyNames);
        this.setType(0);
    }

    public ReportMethod(String path, int depth, String sBody) {
        this(path);
        this.setDepth(depth);
        this.setType(0);
        this.preloadedQuery = sBody;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Depth")) {
            int depth = -1;
            if (headerValue.equals("0")) {
                depth = 0;
            }
            if (headerValue.equals("1")) {
                depth = 1;
            } else if (headerValue.equalsIgnoreCase("infinity")) {
                depth = Integer.MAX_VALUE;
            }
            this.setDepth(depth);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void setType(int type) {
        this.checkNotUsed();
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setDepth(int depth) {
        this.checkNotUsed();
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setPropertyNames(Enumeration propertyNames) {
        this.checkNotUsed();
        Vector list = new Vector();
        while (propertyNames.hasMoreElements()) {
            Object item = propertyNames.nextElement();
            if (item instanceof PropertyName) {
                list.add(item);
                continue;
            }
            if (!(item instanceof String)) continue;
            String propertyName = (String)item;
            int length = propertyName.length();
            boolean found = false;
            int i2 = 1;
            while (!found && i2 <= length) {
                char chr = propertyName.charAt(length - i2);
                if (!Character.isUnicodeIdentifierPart(chr) && chr != '-' && chr != '_' && chr != '.') {
                    found = true;
                    continue;
                }
                ++i2;
            }
            if (i2 == 1 || i2 >= length) {
                list.add(new PropertyName("DAV:", propertyName));
                continue;
            }
            String namespace = propertyName.substring(0, length + 1 - i2);
            String localName = propertyName.substring(length + 1 - i2);
            list.add(new PropertyName(namespace, localName));
        }
        this.propertyNames = list.toArray(new PropertyName[list.size()]);
    }

    public void setHistoryURLs(Enumeration historyURLs) {
        this.sVersionHistory = "<D:version-history-set>";
        while (historyURLs.hasMoreElements()) {
            this.sVersionHistory = this.sVersionHistory + "<D:href>" + historyURLs.nextElement().toString() + "</D:href>";
        }
        this.sVersionHistory = this.sVersionHistory + "</D:version-history-set>";
    }

    public String getName() {
        return "REPORT";
    }

    public void recycle() {
        super.recycle();
        this.prefix = null;
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
        switch (this.depth) {
            case 0: {
                super.setRequestHeader("Depth", "0");
                break;
            }
            case 1: {
                super.setRequestHeader("Depth", "1");
                break;
            }
            case 0x7FFFFFFF: {
                super.setRequestHeader("Depth", "infinity");
            }
        }
    }

    protected String generateRequestBody() {
        if (this.preloadedQuery != null) {
            return this.preloadedQuery;
        }
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        if (this.type != 2) {
            printer.writeElement("D", "DAV:", "version-tree", 0);
        }
        switch (this.type) {
            case 1: {
                printer.writeElement("D", "allprop", 2);
                printer.writeElement("D", "version-tree", 1);
                break;
            }
            case 0: {
                printer.writeElement("D", "prop", 0);
                for (int i2 = 0; i2 < this.propertyNames.length; ++i2) {
                    String namespace = this.propertyNames[i2].getNamespaceURI();
                    String localname = this.propertyNames[i2].getLocalName();
                    if ("DAV:".equals(namespace)) {
                        printer.writeElement("D", localname, 2);
                        continue;
                    }
                    printer.writeElement("ZZ", namespace, localname, 2);
                }
                printer.writeElement("D", "prop", 1);
                printer.writeElement("D", "version-tree", 1);
                break;
            }
            case 2: {
                printer.writeElement("D", "DAV:", "locate-by-history", 0);
                printer.writeText(this.sVersionHistory);
                printer.writeElement("D", "prop", 0);
                for (int i3 = 0; i3 < this.propertyNames.length; ++i3) {
                    String namespace = this.propertyNames[i3].getNamespaceURI();
                    String localname = this.propertyNames[i3].getLocalName();
                    if ("DAV:".equals(namespace)) {
                        printer.writeElement("D", localname, 2);
                        continue;
                    }
                    printer.writeElement("ZZ", namespace, localname, 2);
                }
                printer.writeElement("D", "prop", 1);
                printer.writeElement("D", "locate-by-history", 1);
            }
        }
        return printer.toString();
    }

    public Enumeration getAllResponseURLs() {
        this.checkUsed();
        return this.getResponseURLs().elements();
    }

    public Enumeration getResponseProperties(String urlPath) {
        this.checkUsed();
        XMLResponseMethodBase.Response response = (XMLResponseMethodBase.Response)this.getResponseHashtable().get(urlPath);
        if (response != null) {
            return response.getProperties();
        }
        return new Vector().elements();
    }
}

