/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jec.httpclient.Cookie;
import jec.httpclient.Credentials;
import jec.httpclient.HostConfiguration;
import jec.httpclient.HttpClient;
import jec.httpclient.HttpException;
import jec.httpclient.HttpMethod;
import jec.httpclient.HttpURL;
import jec.httpclient.HttpsURL;
import jec.httpclient.URIException;
import jec.httpclient.UsernamePasswordCredentials;
import jec.httpclient.methods.GetMethod;
import jec.httpclient.methods.HeadMethod;
import jec.httpclient.methods.PutMethod;
import jec.httpclient.util.URIUtil;
import jec.utils.AppLogger;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Lock;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.Subscription;
import org.apache.webdav.lib.WebdavResources;
import org.apache.webdav.lib.WebdavSession;
import org.apache.webdav.lib.WebdavState;
import org.apache.webdav.lib.methods.AclMethod;
import org.apache.webdav.lib.methods.AclReportMethod;
import org.apache.webdav.lib.methods.BindMethod;
import org.apache.webdav.lib.methods.CheckinMethod;
import org.apache.webdav.lib.methods.CheckoutMethod;
import org.apache.webdav.lib.methods.CopyMethod;
import org.apache.webdav.lib.methods.DeleteMethod;
import org.apache.webdav.lib.methods.LabelMethod;
import org.apache.webdav.lib.methods.LockMethod;
import org.apache.webdav.lib.methods.MkWorkspaceMethod;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.OptionsMethod;
import org.apache.webdav.lib.methods.PollMethod;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.RebindMethod;
import org.apache.webdav.lib.methods.ReportMethod;
import org.apache.webdav.lib.methods.SubscribeMethod;
import org.apache.webdav.lib.methods.UnbindMethod;
import org.apache.webdav.lib.methods.UncheckoutMethod;
import org.apache.webdav.lib.methods.UnlockMethod;
import org.apache.webdav.lib.methods.UnsubscribeMethod;
import org.apache.webdav.lib.methods.UpdateMethod;
import org.apache.webdav.lib.methods.VersionControlMethod;
import org.apache.webdav.lib.properties.AclProperty;
import org.apache.webdav.lib.properties.LockDiscoveryProperty;
import org.apache.webdav.lib.properties.PrincipalCollectionSetProperty;
import org.apache.webdav.lib.properties.ResourceTypeProperty;
import org.apache.webdav.lib.util.DOMUtils;
import org.apache.webdav.lib.util.WebdavStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WebdavResource
extends WebdavSession {
    private String a = null;
    public static final String DISPLAYNAME = "displayname";
    public static final String GETCONTENTLANGUAGE = "getcontentlanguage";
    public static final String GETCONTENTLENGTH = "getcontentlength";
    public static final String GETLASTMODIFIED = "getlastmodified";
    public static final String CREATIONDATE = "creationdate";
    public static final String RESOURCETYPE = "resourcetype";
    public static final String SOURCE = "source";
    public static final String GETCONTENTTYPE = "getcontenttype";
    public static final String GETETAG = "getetag";
    public static final String ISHIDDEN = "ishidden";
    public static final String ISCOLLECTION = "iscollection";
    public static final String SUPPORTEDLOCK = "supportedlock";
    public static final String LOCKDISCOVERY = "lockdiscovery";
    public static final int NOACTION = 1;
    public static final int NAME = 2;
    public static final int BASIC = 3;
    public static final int DEFAULT = 4;
    public static final int ALL = 5;
    public static final int OPTIONS_WORKSPACE = 8;
    public static final int OPTIONS_VERSION_HISTORY = 9;
    public static final int LABEL_SET = 10;
    public static final int LABEL_REMOVE = 11;
    public static final int LABEL_ADD = 12;
    public static final String defaultOwner = "Slide";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected HttpURL httpURL;
    protected WebdavResources childResources = new WebdavResources();
    protected static int defaultAction;
    protected static int defaultDepth;
    protected static String tempDirForGet;
    protected static boolean useDiskForGet;
    protected boolean thisResource;
    protected Enumeration allowedMethods;
    protected Enumeration davCapabilities;
    protected boolean exists;
    protected boolean overwrite;
    protected int latestStatusCode;
    protected String latestStatusMessage = "";
    protected String displayName = "";
    protected long getContentLength;
    protected String getContentType = "";
    protected ResourceTypeProperty resourceType;
    protected long getLastModified;
    protected long creationDate;
    protected String getEtag = "";
    protected String owner = null;
    protected boolean isHidden;
    protected boolean isCollection;
    protected String supportedLock = "";
    protected LockDiscoveryProperty lockDiscovery;
    protected boolean followRedirects = false;

    protected WebdavResource() {
    }

    public WebdavResource(HttpClient httpClient) {
        this.client = httpClient;
        if (httpClient.getState().getCookies().length > 0) {
            this.a = httpClient.getState().getCookies()[0].getValue();
            AppLogger.getLogger().debug((Object)("jecFbaSessionId: " + this.a));
        }
    }

    public WebdavResource(HttpURL httpURL, Credentials credentials, int n, int n2) throws HttpException, IOException {
        this.setCredentials(credentials);
        this.setHttpURL(httpURL, n, n2);
    }

    public WebdavResource(HttpURL httpURL, int n, int n2) throws HttpException, IOException {
        this.setHttpURL(httpURL, n, n2);
    }

    public WebdavResource(HttpURL httpURL, int n, int n2, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(this.followRedirects);
        this.setHttpURL(httpURL, n, n2);
    }

    public WebdavResource(HttpURL httpURL, int n) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultAction, n);
    }

    public WebdavResource(HttpURL httpURL, int n, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(bl);
        this.setHttpURL(httpURL, defaultAction, n);
    }

    public WebdavResource(HttpURL httpURL) throws HttpException, IOException {
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(bl);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String string, int n) throws HttpException, IOException {
        this.setProxy(string, n);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String string, int n, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(bl);
        this.setProxy(string, n);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String string, int n, Credentials credentials) throws HttpException, IOException {
        this.setProxy(string, n);
        this.setProxyCredentials(credentials);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(HttpURL httpURL, String string, int n, Credentials credentials, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(bl);
        this.setProxy(string, n);
        this.setProxyCredentials(credentials);
        this.setHttpURL(httpURL);
    }

    public WebdavResource(String string) throws HttpException, IOException {
        this.setHttpURL(string);
    }

    public WebdavResource(String string, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(bl);
        this.setHttpURL(string);
    }

    public WebdavResource(String string, Credentials credentials) throws HttpException, IOException {
        this.setCredentials(credentials);
        this.setHttpURL(string);
    }

    public WebdavResource(String string, Credentials credentials, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(bl);
        this.setCredentials(credentials);
        this.setHttpURL(string);
    }

    public WebdavResource(String string, String string2, int n) throws HttpException, IOException {
        this.setProxy(string2, n);
        this.setHttpURL(string);
    }

    public WebdavResource(String string, String string2, int n, Credentials credentials) throws HttpException, IOException {
        this.setProxy(string2, n);
        this.setProxyCredentials(credentials);
        this.setHttpURL(string);
    }

    public WebdavResource(HttpURL httpURL, String string) throws HttpException, IOException {
        this.setHttpURL(httpURL, string);
    }

    public WebdavResource(HttpURL httpURL, String string, boolean bl) throws HttpException, IOException {
        this.setFollowRedirects(bl);
        this.setHttpURL(httpURL, string);
    }

    protected void generateTransactionHeader(HttpMethod httpMethod) {
        if (this.client == null || httpMethod == null) {
            return;
        }
        WebdavState webdavState = (WebdavState)this.client.getState();
        String string = webdavState.getTransactionHandle();
        if (string != null) {
            httpMethod.setRequestHeader("Transaction", "<" + string + ">");
        }
    }

    protected void generateIfHeader(HttpMethod httpMethod) {
        if (this.client == null) {
            return;
        }
        if (httpMethod == null) {
            return;
        }
        WebdavState webdavState = (WebdavState)this.client.getState();
        String[] stringArray = webdavState.getAllLocks(httpMethod.getPath());
        if (stringArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append("(<").append(stringArray[i2]).append(">) ");
        }
        httpMethod.setRequestHeader("If", stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseDate(String string) {
        Date date = null;
        for (int i2 = 0; date == null && i2 < formats.length; ++i2) {
            try {
                SimpleDateFormat simpleDateFormat = formats[i2];
                synchronized (simpleDateFormat) {
                    date = formats[i2].parse(string);
                    continue;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    protected void setNameProperties(int n) throws HttpException, IOException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(DISPLAYNAME);
        this.setNamedProp(n, vector);
    }

    protected void setBasicProperties(int n) throws HttpException, IOException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(DISPLAYNAME);
        vector.addElement(GETCONTENTLENGTH);
        vector.addElement(GETCONTENTTYPE);
        vector.addElement(RESOURCETYPE);
        vector.addElement(GETLASTMODIFIED);
        vector.addElement(LOCKDISCOVERY);
        this.setNamedProp(n, vector);
    }

    protected void setDefaultProperties(int n) throws HttpException, IOException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(CREATIONDATE);
        vector.addElement(DISPLAYNAME);
        vector.addElement(GETCONTENTLANGUAGE);
        vector.addElement(GETCONTENTLENGTH);
        vector.addElement(GETCONTENTTYPE);
        vector.addElement(GETETAG);
        vector.addElement(GETLASTMODIFIED);
        vector.addElement(LOCKDISCOVERY);
        vector.addElement(RESOURCETYPE);
        vector.addElement(SOURCE);
        vector.addElement(SUPPORTEDLOCK);
        this.setNamedProp(n, vector);
    }

    protected void setNamedProp(int n, Vector vector) throws HttpException, IOException {
        Enumeration enumeration = this.propfindMethod(n, vector);
        this.setWebdavProperties(enumeration);
    }

    protected void setAllProp(int n) throws HttpException, IOException {
        Enumeration enumeration = this.propfindMethod(n);
        this.setWebdavProperties(enumeration);
    }

    protected void setWebdavProperties(Enumeration enumeration) throws HttpException, IOException {
        this.childResources.removeAll();
        while (enumeration.hasMoreElements()) {
            Object object;
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            boolean bl = false;
            String string = responseEntity.getHref();
            if (!string.startsWith("/")) {
                string = URIUtil.getPath(string);
            }
            string = WebdavResource.if(string);
            String string2 = this.httpURL.getPath();
            String string3 = URIUtil.decode(string);
            int n = string3.length() - string2.length();
            int n2 = 0;
            if (n == -1 && !string3.endsWith("/")) {
                n2 = string3.length();
                n = 0;
            } else if (n == 1 && !string2.endsWith("/")) {
                n2 = string2.length();
                n = 0;
            }
            if (n == 0 && (n2 == 0 && string2.equals(string3) || string2.regionMatches(0, string3, 0, n2))) {
                if (responseEntity.getStatusCode() > 0) {
                    this.setStatusCode(responseEntity.getStatusCode());
                }
                this.setExistence(true);
                bl = true;
            }
            WebdavResource webdavResource = null;
            if (bl) {
                webdavResource = this;
            } else {
                webdavResource = this.createWebdavResource(this.client);
                webdavResource.setDebug(this.debug);
            }
            webdavResource.setLockDiscovery(null);
            Enumeration enumeration2 = responseEntity.getProperties();
            while (enumeration2.hasMoreElements()) {
                object = (Property)enumeration2.nextElement();
                webdavResource.processProperty((Property)object);
            }
            object = webdavResource.getDisplayName();
            if (object == null || ((String)object).trim().equals("")) {
                object = WebdavResource.a(string);
            }
            if (!bl) {
                String string4 = this.httpURL.getEscapedURI();
                char[] cArray = (string4 + (string4.endsWith("/") ? "" : "/") + URIUtil.getName(string)).toCharArray();
                AppLogger.getLogger().debug((Object)("orig:" + new String(cArray)));
                char[] cArray2 = this.a(cArray);
                AppLogger.getLogger().debug((Object)("enc:" + new String(cArray2)));
                HttpURL httpURL = this.httpURL instanceof HttpsURL ? new HttpsURL(cArray2) : new HttpURL(cArray2);
                httpURL.setRawAuthority(this.httpURL.getRawAuthority());
                webdavResource.setHttpURL(httpURL, 1, defaultDepth);
                webdavResource.setExistence(true);
                webdavResource.setOverwrite(this.getOverwrite());
            }
            webdavResource.setDisplayName((String)object);
            if (bl) continue;
            this.childResources.addResource(webdavResource);
        }
    }

    public static void setDefaultAction(int n) {
        defaultAction = n;
    }

    public static int getDefaultAction() {
        return defaultAction;
    }

    public static void setDefaultDepth(int n) {
        defaultDepth = n;
    }

    public static int getDefaultDepth() {
        return defaultDepth;
    }

    public static void setGetTempDir(String string) {
        tempDirForGet = string;
    }

    public static String getGetTempDir() {
        return tempDirForGet;
    }

    public static void setGetUseDisk(boolean bl) {
    }

    public static boolean getGetUseDisk() {
        return false;
    }

    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    protected synchronized boolean isTheClient() throws URIException {
        boolean bl;
        Object object;
        HostConfiguration hostConfiguration = this.client.getHostConfiguration();
        Credentials credentials = this.client.getState().getCredentials(null, hostConfiguration.getHost());
        String string = null;
        String string2 = null;
        if (credentials instanceof UsernamePasswordCredentials) {
            object = (UsernamePasswordCredentials)credentials;
            string = ((UsernamePasswordCredentials)object).getUserName();
            string2 = ((UsernamePasswordCredentials)object).getPassword();
        }
        object = this.httpURL.getUser();
        boolean bl2 = string != null ? string.equals(object) : (bl = object == null);
        if (!bl) {
            return false;
        }
        object = this.httpURL.getPassword();
        bl = string2 != null ? string2.equals(object) : object == null;
        if (bl) {
            return this.httpURL.getHost().equalsIgnoreCase(hostConfiguration.getHost()) && this.httpURL.getPort() == hostConfiguration.getProtocol().resolvePort(hostConfiguration.getPort());
        }
        return false;
    }

    protected void setClient() throws IOException {
        this.setClient(this.httpURL);
    }

    protected synchronized void setClient(HttpURL httpURL) throws IOException {
        if (this.client == null) {
            this.client = this.getSessionInstance(httpURL);
        }
    }

    public void setHttpURL(HttpURL httpURL, int n, int n2) throws HttpException, IOException {
        this.httpURL = httpURL;
        this.setClient(httpURL);
        this.setExistence(false);
        this.setProperties(n, n2);
    }

    public void setHttpURL(HttpURL httpURL, int n) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultAction, n);
    }

    public void setHttpURL(HttpURL httpURL, String string, int n, int n2) throws HttpException, IOException {
        this.setHttpURL(httpURL instanceof HttpsURL ? new HttpsURL((HttpsURL)httpURL, string) : new HttpURL(httpURL, string), n, n2);
    }

    public void setHttpURL(HttpURL httpURL, String string, int n) throws HttpException, IOException {
        this.setHttpURL(httpURL instanceof HttpsURL ? new HttpsURL((HttpsURL)httpURL, string) : new HttpURL(httpURL, string), n, defaultDepth);
    }

    public void setHttpURL(HttpURL httpURL, String string) throws HttpException, IOException {
        this.setHttpURL(httpURL instanceof HttpsURL ? new HttpsURL((HttpsURL)httpURL, string) : new HttpURL(httpURL, string), defaultAction, defaultDepth);
    }

    public void setHttpURL(HttpURL httpURL) throws HttpException, IOException {
        this.setHttpURL(httpURL, defaultDepth);
    }

    public void setHttpURL(String string) throws HttpException, IOException {
        this.setHttpURL(string.startsWith("https") ? new HttpsURL(string) : new HttpURL(string));
    }

    public HttpURL getHttpURL() {
        return this.httpURL;
    }

    public HttpURL getHttpURLExceptForUserInfo() throws URIException {
        return this.httpURL instanceof HttpsURL ? new HttpsURL(this.httpURL.getRawURI()) : new HttpURL(this.httpURL.getRawURI());
    }

    public void setPath(String string) throws HttpException, IOException {
        this.httpURL.setPath(string);
        this.setHttpURL(this.httpURL);
    }

    public String getPath() {
        try {
            return this.httpURL.getPath();
        }
        catch (URIException uRIException) {
            return this.httpURL.getEscapedPath();
        }
    }

    public String getName() {
        return WebdavResource.a(this.httpURL.getEscapedPath());
    }

    public String getHost() throws URIException {
        return this.httpURL.getHost();
    }

    public void setUserInfo(String string, String string2) throws HttpException, IOException {
        this.httpURL.setUserinfo(string, string2);
        this.setHttpURL(this.httpURL);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String string) {
        this.displayName = string;
    }

    public long getGetContentLength() {
        return this.getContentLength;
    }

    protected void setGetContentLength(long l2) {
        this.getContentLength = l2;
    }

    protected void setGetContentLength(String string) {
        try {
            this.getContentLength = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public ResourceTypeProperty getResourceType() {
        return this.resourceType;
    }

    protected void setResourceType(ResourceTypeProperty resourceTypeProperty) {
        this.resourceType = resourceTypeProperty;
    }

    public boolean isCollection() {
        if (this.getResourceType() == null) {
            return false;
        }
        return this.getResourceType().isCollection();
    }

    public String getGetContentType() {
        return this.getContentType;
    }

    protected void setGetContentType(String string) {
        this.getContentType = string;
    }

    public void setContentType(String string) {
        this.getContentType = string;
    }

    public long getGetLastModified() {
        return this.getLastModified;
    }

    protected void setGetLastModified(long l2) {
        this.getLastModified = l2;
    }

    protected void setGetLastModified(String string) {
        Date date = this.parseDate(string);
        if (date != null) {
            this.getLastModified = date.getTime();
        }
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    protected void setCreationDate(long l2) {
        this.creationDate = l2;
    }

    protected void setCreationDate(String string) {
        Date date = this.parseDate(string);
        if (date != null) {
            this.creationDate = date.getTime();
        }
    }

    public String getGetEtag() {
        return this.getEtag;
    }

    protected void setGetEtag(String string) {
        this.getEtag = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSupportedLock() {
        return this.supportedLock;
    }

    protected void setSupportedLock(String string) {
        this.supportedLock = string;
    }

    public LockDiscoveryProperty getLockDiscovery() {
        return this.lockDiscovery;
    }

    protected void setLockDiscovery(LockDiscoveryProperty lockDiscoveryProperty) {
        this.lockDiscovery = lockDiscoveryProperty;
    }

    public Enumeration getActiveLockOwners() {
        if (this.lockDiscovery == null) {
            return null;
        }
        Lock[] lockArray = this.lockDiscovery.getActiveLocks();
        if (lockArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = lockArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            vector.addElement(lockArray[i2].getOwner());
        }
        return vector.elements();
    }

    public boolean isLocked() {
        if (this.lockDiscovery == null) {
            return false;
        }
        Lock[] lockArray = this.lockDiscovery.getActiveLocks();
        if (lockArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < lockArray.length; ++i2) {
            if (lockArray[i2].getLockType() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    protected void setIsHidden(boolean bl) {
        this.isHidden = bl;
    }

    protected void setIsHidden(String string) {
        this.isHidden = string.equals(TRUE);
    }

    public boolean getIsCollection() {
        return this.isCollection;
    }

    protected void setIsCollection(boolean bl) {
        this.isCollection = bl;
    }

    protected void setIsCollection(String string) {
        this.isCollection = string.equals(TRUE);
    }

    public void setProperties(int n, int n2) throws HttpException, IOException {
        switch (n) {
            case 2: {
                this.setNameProperties(n2);
                break;
            }
            case 3: {
                this.setBasicProperties(n2);
                break;
            }
            case 4: {
                this.setDefaultProperties(n2);
                break;
            }
            case 5: {
                this.setAllProp(n2);
                break;
            }
        }
    }

    public void setProperties(int n) throws HttpException, IOException {
        this.setProperties(defaultAction, n);
    }

    protected void refresh() throws HttpException, IOException {
        int n = this.latestStatusCode;
        String string = this.latestStatusMessage;
        this.setProperties(0);
        this.latestStatusCode = n;
        this.latestStatusMessage = string;
    }

    public boolean exists() {
        return this.getExistence();
    }

    protected void setExistence(boolean bl) {
        this.exists = bl;
    }

    public boolean getExistence() {
        return this.exists;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void close() throws IOException {
        this.closeSession();
    }

    public String getStatusMessage() {
        return this.latestStatusMessage;
    }

    public int getStatusCode() {
        return this.latestStatusCode;
    }

    protected void setStatusCode(int n) {
        this.setStatusCode(n, null);
    }

    protected void setStatusCode(int n, String string) {
        this.latestStatusCode = n;
        this.latestStatusMessage = WebdavStatus.getStatusText(n) + " (" + n + ")" + (string == null ? "" : string);
    }

    public Enumeration getAllowedMethods() {
        return this.allowedMethods;
    }

    public Enumeration getDavCapabilities() {
        return this.davCapabilities;
    }

    public WebdavResources getChildResources() throws HttpException, IOException {
        this.setProperties(1);
        return this.childResources;
    }

    public WebdavResource[] listWebdavResources() throws HttpException, IOException {
        return this.getChildResources().listResources();
    }

    public String[] list() {
        try {
            this.setNameProperties(1);
        }
        catch (IOException iOException) {
            return null;
        }
        Enumeration enumeration = this.childResources.getResourceNames();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = (String)vector.elementAt(i2);
        }
        return stringArray;
    }

    public Vector listBasic() throws HttpException, IOException {
        this.setBasicProperties(1);
        Enumeration enumeration = this.childResources.getResourceNames();
        Vector<String[]> vector = new Vector<String[]>();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                WebdavResource webdavResource = this.childResources.getResource(string);
                String[] stringArray = new String[5];
                stringArray[0] = webdavResource.getDisplayName();
                long l2 = webdavResource.getGetContentLength();
                stringArray[1] = new Long(l2).toString();
                ResourceTypeProperty resourceTypeProperty = webdavResource.getResourceType();
                String string2 = webdavResource.getGetContentType();
                stringArray[2] = resourceTypeProperty.isCollection() ? "COLLECTION" : string2;
                Date date = new Date(webdavResource.getGetLastModified());
                stringArray[3] = date == null ? "-- -- ----" : DateFormat.getDateTimeInstance().format(date);
                vector.addElement(stringArray);
                stringArray[4] = webdavResource.getName();
            }
            catch (Exception exception) {
                if (this.debug <= 0) continue;
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public void setEncodeURLs(boolean bl) {
    }

    public HttpClient retrieveSessionInstance() throws IOException {
        this.setClient();
        return this.client;
    }

    public int executeHttpRequestMethod(HttpClient httpClient, HttpMethod httpMethod) throws IOException, HttpException {
        httpClient.executeMethod(httpMethod);
        return httpMethod.getStatusCode();
    }

    public boolean aclMethod(String string, Ace[] aceArray) throws HttpException, IOException {
        int n;
        this.setClient();
        AclMethod aclMethod = new AclMethod(URIUtil.encodePath(string));
        aclMethod.setDebug(this.debug);
        aclMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(aclMethod);
        for (n = 0; n < aceArray.length; ++n) {
            Ace ace = aceArray[n];
            aclMethod.addAce(ace);
        }
        this.generateTransactionHeader(aclMethod);
        n = this.client.executeMethod(aclMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public AclProperty aclfindMethod() throws HttpException, IOException {
        this.thisResource = true;
        return this.aclfindMethod(this.httpURL.getPath());
    }

    public AclProperty aclfindMethod(String string) throws HttpException, IOException {
        this.setClient();
        AclProperty aclProperty = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement("acl");
        PropFindMethod propFindMethod = new PropFindMethod(URIUtil.encodePath(string), 0, vector.elements());
        propFindMethod.setDebug(this.debug);
        propFindMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(propFindMethod);
        this.client.executeMethod(propFindMethod);
        Enumeration enumeration = propFindMethod.getResponses();
        if (enumeration.hasMoreElements()) {
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            String string2 = responseEntity.getHref();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            Enumeration enumeration2 = propFindMethod.getResponseProperties(string2);
            while (enumeration2.hasMoreElements()) {
                Property property = (Property)enumeration2.nextElement();
                if (!(property instanceof AclProperty)) continue;
                aclProperty = (AclProperty)property;
            }
        }
        return aclProperty;
    }

    public PrincipalCollectionSetProperty principalCollectionSetFindMethod() throws HttpException, IOException {
        this.thisResource = true;
        return this.principalCollectionSetFindMethod(this.httpURL.getPath());
    }

    public PrincipalCollectionSetProperty principalCollectionSetFindMethod(String string) throws HttpException, IOException {
        this.setClient();
        PrincipalCollectionSetProperty principalCollectionSetProperty = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement("principal-collection-set");
        PropFindMethod propFindMethod = new PropFindMethod(URIUtil.encodePath(string), 0, vector.elements());
        propFindMethod.setDebug(this.debug);
        propFindMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(propFindMethod);
        this.client.executeMethod(propFindMethod);
        Enumeration enumeration = propFindMethod.getResponses();
        if (enumeration.hasMoreElements()) {
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            String string2 = responseEntity.getHref();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            Enumeration enumeration2 = propFindMethod.getResponseProperties(string2);
            while (enumeration2.hasMoreElements()) {
                Property property = (Property)enumeration2.nextElement();
                if (!(property instanceof PrincipalCollectionSetProperty)) continue;
                principalCollectionSetProperty = (PrincipalCollectionSetProperty)property;
            }
        }
        return principalCollectionSetProperty;
    }

    public LockDiscoveryProperty lockDiscoveryPropertyFindMethod() throws HttpException, IOException {
        this.thisResource = true;
        return this.lockDiscoveryPropertyFindMethod(this.httpURL.getPath());
    }

    public LockDiscoveryProperty lockDiscoveryPropertyFindMethod(String string) throws HttpException, IOException {
        this.setClient();
        LockDiscoveryProperty lockDiscoveryProperty = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement(LOCKDISCOVERY);
        PropFindMethod propFindMethod = new PropFindMethod(URIUtil.encodePath(string), 0, vector.elements());
        propFindMethod.setDebug(this.debug);
        propFindMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(propFindMethod);
        this.client.executeMethod(propFindMethod);
        Enumeration enumeration = propFindMethod.getResponses();
        if (enumeration.hasMoreElements()) {
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            String string2 = responseEntity.getHref();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            Enumeration enumeration2 = propFindMethod.getResponseProperties(string2);
            while (enumeration2.hasMoreElements()) {
                Property property = (Property)enumeration2.nextElement();
                if (!(property instanceof LockDiscoveryProperty)) continue;
                lockDiscoveryProperty = (LockDiscoveryProperty)property;
            }
        }
        return lockDiscoveryProperty;
    }

    public InputStream getMethodData() throws HttpException, IOException {
        return this.getMethodData(this.httpURL.getPathQuery());
    }

    public InputStream getMethodData(String string) throws HttpException, IOException {
        this.setClient();
        GetMethod getMethod = new GetMethod(URIUtil.encodePathQuery(string));
        this.generateTransactionHeader(getMethod);
        this.client.executeMethod(getMethod);
        int n = getMethod.getStatusLine().getStatusCode();
        this.setStatusCode(n);
        if (n >= 200 && n < 300) {
            return getMethod.getResponseBodyAsStream();
        }
        throw new IOException("Couldn't get file");
    }

    public String getMethodDataAsString() throws HttpException, IOException {
        return this.getMethodDataAsString(this.httpURL.getPathQuery());
    }

    public String getMethodDataAsString(String string) throws HttpException, IOException {
        this.setClient();
        GetMethod getMethod = new GetMethod(URIUtil.encodePathQuery(string));
        this.generateTransactionHeader(getMethod);
        int n = this.client.executeMethod(getMethod);
        this.setStatusCode(n);
        return getMethod.getResponseBodyAsString();
    }

    public boolean getMethod(File file) throws HttpException, IOException {
        return this.getMethod(this.httpURL.getPathQuery(), file);
    }

    public boolean getMethod(String string, File file) throws HttpException, IOException {
        this.setClient();
        GetMethod getMethod = new GetMethod(URIUtil.encodePathQuery(string));
        this.generateTransactionHeader(getMethod);
        int n = this.client.executeMethod(getMethod);
        this.setStatusCode(n);
        if (n >= 200 && n < 300) {
            int n2;
            InputStream inputStream = getMethod.getResponseBodyAsStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[65535];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            fileOutputStream.close();
            return true;
        }
        return false;
    }

    public boolean putMethod(byte[] byArray) throws HttpException, IOException {
        boolean bl = this.putMethod(this.httpURL.getPathQuery(), byArray);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean putMethod(String string, byte[] byArray) throws HttpException, IOException {
        this.setClient();
        PutMethod putMethod = new PutMethod(URIUtil.encodePathQuery(string));
        this.generateIfHeader(putMethod);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            putMethod.setRequestHeader("Content-Type", this.getGetContentType());
        }
        putMethod.setRequestHeader("Content-Length", String.valueOf(byArray.length));
        putMethod.setRequestBody(new ByteArrayInputStream(byArray));
        this.generateTransactionHeader(putMethod);
        int n = this.client.executeMethod(putMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean putMethod(InputStream inputStream) throws HttpException, IOException {
        return this.putMethod(this.httpURL.getPathQuery(), inputStream);
    }

    public boolean putMethod(String string, InputStream inputStream) throws HttpException, IOException {
        this.setClient();
        PutMethod putMethod = new PutMethod(URIUtil.encodePathQuery(string));
        this.generateIfHeader(putMethod);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            putMethod.setRequestHeader("Content-Type", this.getGetContentType());
        }
        putMethod.setRequestContentLength(-1);
        putMethod.setRequestBody(inputStream);
        this.generateTransactionHeader(putMethod);
        int n = this.client.executeMethod(putMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean putMethod(String string) throws HttpException, IOException {
        boolean bl = this.putMethod(this.httpURL.getPathQuery(), string);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean putMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        PutMethod putMethod = new PutMethod(URIUtil.encodePathQuery(string));
        this.generateIfHeader(putMethod);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            putMethod.setRequestHeader("Content-Type", this.getGetContentType());
        }
        putMethod.setRequestBody(string2);
        this.generateTransactionHeader(putMethod);
        int n = this.client.executeMethod(putMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean putMethod(File file) throws HttpException, IOException {
        boolean bl = this.putMethod(this.httpURL.getPathQuery(), file);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean putMethod(String string, File file) throws HttpException, IOException {
        long l2;
        this.setClient();
        PutMethod putMethod = new PutMethod(URIUtil.encodePathQuery(string));
        this.generateIfHeader(putMethod);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            putMethod.setRequestHeader("Content-Type", this.getGetContentType());
        }
        putMethod.setRequestContentLength((l2 = file.length()) <= Integer.MAX_VALUE ? (int)l2 : -1);
        putMethod.setRequestBody(new FileInputStream(file));
        this.generateTransactionHeader(putMethod);
        int n = this.client.executeMethod(putMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean putMethod(URL uRL) throws HttpException, IOException {
        boolean bl = this.putMethod(this.httpURL.getPathQuery(), uRL);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean putMethod(String string, URL uRL) throws HttpException, IOException {
        this.setClient();
        PutMethod putMethod = new PutMethod(URIUtil.encodePathQuery(string));
        this.generateIfHeader(putMethod);
        if (this.getGetContentType() != null && !this.getGetContentType().equals("")) {
            putMethod.setRequestHeader("Content-Type", this.getGetContentType());
        }
        putMethod.setRequestBody(uRL.openStream());
        this.generateTransactionHeader(putMethod);
        int n = this.client.executeMethod(putMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean optionsMethod() throws HttpException, IOException {
        return this.optionsMethod(this.httpURL.getPath());
    }

    public boolean optionsMethod(String string) throws HttpException, IOException {
        this.setClient();
        OptionsMethod optionsMethod = string.trim().equals("*") ? new OptionsMethod("*") : new OptionsMethod(URIUtil.encodePath(string));
        optionsMethod.setDebug(this.debug);
        optionsMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(optionsMethod);
        int n = this.client.executeMethod(optionsMethod);
        this.setStatusCode(n);
        if (n >= 200 && n < 300) {
            this.allowedMethods = optionsMethod.getAllowedMethods();
            this.davCapabilities = optionsMethod.getDavCapabilities();
            return true;
        }
        return false;
    }

    public boolean optionsMethod(String string, String string2) throws HttpException, IOException {
        if (string2 != null && this.optionsMethod(string)) {
            while (this.allowedMethods.hasMoreElements()) {
                if (!string2.equalsIgnoreCase((String)this.allowedMethods.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration optionsMethod(HttpURL httpURL) throws HttpException, IOException {
        HttpClient httpClient = this.getSessionInstance(httpURL, true);
        OptionsMethod optionsMethod = new OptionsMethod(httpURL.getEscapedPath());
        optionsMethod.setDebug(this.debug);
        optionsMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(optionsMethod);
        httpClient.executeMethod(optionsMethod);
        Vector vector = new Vector();
        int n = optionsMethod.getStatusLine().getStatusCode();
        if (n >= 200 && n < 300) {
            Enumeration enumeration = optionsMethod.getAllowedMethods();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            Enumeration enumeration2 = optionsMethod.getDavCapabilities();
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
            Enumeration enumeration3 = optionsMethod.getResponses();
            if (enumeration3.hasMoreElements()) {
                ResponseEntity responseEntity = (ResponseEntity)enumeration3.nextElement();
                Enumeration enumeration4 = responseEntity.getWorkspaces();
                String string = "";
                while (enumeration4.hasMoreElements()) {
                    string = string + enumeration4.nextElement().toString();
                }
                Enumeration enumeration5 = responseEntity.getHistories();
                while (enumeration5.hasMoreElements()) {
                    string = string + enumeration5.nextElement().toString();
                }
                if (this.thisResource && responseEntity.getStatusCode() > 0) {
                    this.setStatusCode(responseEntity.getStatusCode());
                }
                this.thisResource = false;
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public Enumeration optionsMethod(HttpURL httpURL, int n) throws HttpException, IOException {
        Enumeration enumeration;
        HttpClient httpClient = this.getSessionInstance(httpURL, true);
        OptionsMethod optionsMethod = new OptionsMethod(httpURL.getEscapedPath(), n);
        optionsMethod.setDebug(this.debug);
        optionsMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(optionsMethod);
        httpClient.executeMethod(optionsMethod);
        Vector<String> vector = new Vector<String>();
        int n2 = optionsMethod.getStatusLine().getStatusCode();
        if (n2 >= 200 && n2 < 300 && (enumeration = optionsMethod.getResponses()).hasMoreElements()) {
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            if (n == 8) {
                Enumeration enumeration2 = responseEntity.getWorkspaces();
                while (enumeration2.hasMoreElements()) {
                    vector.add(enumeration2.nextElement().toString());
                }
            } else if (n == 9) {
                Enumeration enumeration3 = responseEntity.getHistories();
                while (enumeration3.hasMoreElements()) {
                    vector.add(enumeration3.nextElement().toString());
                }
            }
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
        }
        return vector.elements();
    }

    public Enumeration optionsMethod(String string, int n) throws HttpException, IOException {
        Enumeration enumeration;
        this.setClient();
        OptionsMethod optionsMethod = new OptionsMethod(URIUtil.encodePath(string), n);
        optionsMethod.setDebug(this.debug);
        optionsMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(optionsMethod);
        this.client.executeMethod(optionsMethod);
        Vector<String> vector = new Vector<String>();
        int n2 = optionsMethod.getStatusLine().getStatusCode();
        if (n2 >= 200 && n2 < 300 && (enumeration = optionsMethod.getResponses()).hasMoreElements()) {
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            if (n == 8) {
                Enumeration enumeration2 = responseEntity.getWorkspaces();
                while (enumeration2.hasMoreElements()) {
                    vector.add(enumeration2.nextElement().toString());
                }
            } else if (n == 9) {
                Enumeration enumeration3 = responseEntity.getHistories();
                while (enumeration3.hasMoreElements()) {
                    vector.add(enumeration3.nextElement().toString());
                }
            }
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
        }
        return vector.elements();
    }

    public boolean labelMethod(String string, int n) throws HttpException, IOException {
        return this.labelMethod(this.httpURL.getPath(), string, n);
    }

    public boolean labelMethod(String string, String string2, int n) throws HttpException, IOException {
        int n2 = 0;
        switch (n) {
            case 10: {
                n2 = 1;
                break;
            }
            case 11: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
            }
        }
        this.setClient();
        LabelMethod labelMethod = new LabelMethod(URIUtil.encodePath(string), n2, string2);
        labelMethod.setDebug(this.debug);
        labelMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(labelMethod);
        int n3 = this.client.executeMethod(labelMethod);
        this.setStatusCode(n3);
        return n3 >= 200 && n3 < 300;
    }

    public Enumeration reportMethod(HttpURL httpURL, int n) throws HttpException, IOException {
        this.setClient();
        ReportMethod reportMethod = new ReportMethod(httpURL.getEscapedPath(), n);
        reportMethod.setDebug(this.debug);
        reportMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(reportMethod);
        this.client.executeMethod(reportMethod);
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = reportMethod.getResponses();
        while (enumeration.hasMoreElements()) {
            String string;
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            String string2 = string = responseEntity.getHref();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            Enumeration enumeration2 = reportMethod.getResponseProperties(string);
            while (enumeration2.hasMoreElements()) {
                Property property = (Property)enumeration2.nextElement();
                string2 = string2 + "\n" + property.getName() + ":\t" + DOMUtils.getTextValue(property.getElement());
            }
            vector.addElement(string2);
        }
        return vector.elements();
    }

    public Enumeration reportMethod(HttpURL httpURL, Vector vector) throws HttpException, IOException {
        this.setClient();
        ReportMethod reportMethod = new ReportMethod(httpURL.getEscapedPath(), 0, vector.elements());
        reportMethod.setDebug(this.debug);
        reportMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(reportMethod);
        this.client.executeMethod(reportMethod);
        return reportMethod.getResponses();
    }

    public Enumeration reportMethod(HttpURL httpURL, Vector vector, int n) throws HttpException, IOException {
        this.setClient();
        ReportMethod reportMethod = new ReportMethod(httpURL.getEscapedPath(), n, vector.elements());
        reportMethod.setDebug(this.debug);
        reportMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(reportMethod);
        this.client.executeMethod(reportMethod);
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = reportMethod.getResponses();
        while (enumeration.hasMoreElements()) {
            String string;
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            String string2 = string = responseEntity.getHref();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            Enumeration enumeration2 = reportMethod.getResponseProperties(string);
            while (enumeration2.hasMoreElements()) {
                Property property = (Property)enumeration2.nextElement();
                string2 = string2 + "\n" + property.getName() + ":\t" + DOMUtils.getTextValue(property.getElement());
            }
            vector2.addElement(string2);
        }
        return vector2.elements();
    }

    public Enumeration reportMethod(HttpURL httpURL, Vector vector, Vector vector2, int n) throws HttpException, IOException {
        this.setClient();
        ReportMethod reportMethod = new ReportMethod(httpURL.getEscapedPath(), n, vector.elements(), vector2.elements());
        reportMethod.setDebug(this.debug);
        reportMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(reportMethod);
        this.client.executeMethod(reportMethod);
        Vector<String> vector3 = new Vector<String>();
        Enumeration enumeration = reportMethod.getResponses();
        while (enumeration.hasMoreElements()) {
            String string;
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            String string2 = string = responseEntity.getHref();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            Enumeration enumeration2 = reportMethod.getResponseProperties(string);
            while (enumeration2.hasMoreElements()) {
                Property property = (Property)enumeration2.nextElement();
                string2 = string2 + "\n" + property.getName() + ":\t" + DOMUtils.getTextValue(property.getElement());
            }
            vector3.addElement(string2);
        }
        return vector3.elements();
    }

    public Enumeration reportMethod(HttpURL httpURL, String string, int n) throws HttpException, IOException {
        this.setClient();
        ReportMethod reportMethod = new ReportMethod(httpURL.getEscapedPath(), n, string);
        reportMethod.setDebug(this.debug);
        reportMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(reportMethod);
        this.client.executeMethod(reportMethod);
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = reportMethod.getResponses();
        while (enumeration.hasMoreElements()) {
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            String string2 = responseEntity.toString();
            vector.addElement(string2);
        }
        return vector.elements();
    }

    public Enumeration propfindMethod(int n) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), n);
    }

    public Enumeration propfindMethod(String string, int n) throws HttpException, IOException {
        this.setClient();
        PropFindMethod propFindMethod = new PropFindMethod(URIUtil.encodePath(string), n);
        propFindMethod.setDebug(this.debug);
        this.generateTransactionHeader(propFindMethod);
        int n2 = this.client.executeMethod(propFindMethod);
        if (this.thisResource) {
            this.setStatusCode(n2);
        }
        if (n2 != 207 && n2 != 200) {
            HttpException httpException = new HttpException();
            httpException.setReasonCode(n2);
            throw httpException;
        }
        this.thisResource = false;
        return propFindMethod.getResponses();
    }

    public Enumeration propfindMethod(int n, Vector vector) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), n, vector);
    }

    public Enumeration propfindMethod(String string, int n, Vector vector) throws HttpException, IOException {
        String string2 = string;
        if (string.indexOf("%20") > 0) {
            string2 = string.replaceAll("%20", " ");
        }
        PropFindMethod propFindMethod = new PropFindMethod(URIUtil.encodePath(string2), n, vector.elements());
        propFindMethod.setDebug(this.debug);
        propFindMethod.setFollowRedirects(this.followRedirects);
        Cookie cookie = new Cookie();
        cookie.setName("sessionid");
        cookie.setValue(this.a);
        this.client.getState().addCookie(cookie);
        int n2 = this.client.executeMethod(propFindMethod);
        if (this.thisResource) {
            this.setStatusCode(propFindMethod.getStatusLine().getStatusCode());
        }
        if (n2 != 207 && n2 != 200) {
            HttpException httpException = new HttpException();
            httpException.setReasonCode(n2);
            throw httpException;
        }
        this.thisResource = false;
        return propFindMethod.getResponses();
    }

    public Enumeration propfindMethod(String string) throws HttpException, IOException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), vector);
    }

    public Enumeration propfindMethod(String string, String string2) throws HttpException, IOException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        this.thisResource = false;
        return this.propfindMethod(string, vector);
    }

    public Enumeration propfindMethod(Vector vector) throws HttpException, IOException {
        this.thisResource = true;
        return this.propfindMethod(this.httpURL.getPath(), vector);
    }

    public Enumeration propfindMethod(String string, Vector vector) throws HttpException, IOException {
        this.setClient();
        PropFindMethod propFindMethod = new PropFindMethod(URIUtil.encodePath(string), 0, vector.elements());
        propFindMethod.setDebug(this.debug);
        propFindMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(propFindMethod);
        int n = this.client.executeMethod(propFindMethod);
        if (n != 207 && n != 200) {
            HttpException httpException = new HttpException();
            httpException.setReasonCode(n);
            throw httpException;
        }
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = propFindMethod.getResponses();
        if (enumeration.hasMoreElements()) {
            ResponseEntity responseEntity = (ResponseEntity)enumeration.nextElement();
            String string2 = responseEntity.getHref();
            if (this.thisResource && responseEntity.getStatusCode() > 0) {
                this.setStatusCode(responseEntity.getStatusCode());
            }
            this.thisResource = false;
            Enumeration enumeration2 = propFindMethod.getResponseProperties(string2);
            while (enumeration2.hasMoreElements()) {
                Property property = (Property)enumeration2.nextElement();
                vector2.addElement(property.getPropertyAsString());
            }
        }
        return vector2.elements();
    }

    public boolean proppatchMethod(String string, String string2) throws HttpException, IOException {
        boolean bl = this.proppatchMethod(this.httpURL.getPath(), string, string2, true);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean proppatchMethod(String string, String string2, boolean bl) throws HttpException, IOException {
        boolean bl2 = this.proppatchMethod(this.httpURL.getPath(), string, string2, bl);
        if (bl2) {
            this.refresh();
        }
        return bl2;
    }

    public boolean proppatchMethod(PropertyName propertyName, String string) throws HttpException, IOException {
        boolean bl = this.proppatchMethod(this.httpURL.getPath(), propertyName, string, true);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean proppatchMethod(PropertyName propertyName, String string, boolean bl) throws HttpException, IOException {
        boolean bl2 = this.proppatchMethod(this.httpURL.getPath(), propertyName, string, bl);
        if (bl2) {
            this.refresh();
        }
        return bl2;
    }

    public boolean proppatchMethod(String string, String string2, String string3) throws HttpException, IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string2, string3);
        return this.proppatchMethod(string, hashtable, true);
    }

    public boolean proppatchMethod(String string, String string2, String string3, boolean bl) throws HttpException, IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string2, string3);
        return this.proppatchMethod(string, hashtable, bl);
    }

    public boolean proppatchMethod(String string, PropertyName propertyName, String string2) throws HttpException, IOException {
        Hashtable<PropertyName, String> hashtable = new Hashtable<PropertyName, String>();
        hashtable.put(propertyName, string2);
        return this.proppatchMethod(string, hashtable, true);
    }

    public boolean proppatchMethod(String string, PropertyName propertyName, String string2, boolean bl) throws HttpException, IOException {
        Hashtable<PropertyName, String> hashtable = new Hashtable<PropertyName, String>();
        hashtable.put(propertyName, string2);
        return this.proppatchMethod(string, hashtable, bl);
    }

    public boolean proppatchMethod(Hashtable hashtable) throws HttpException, IOException {
        boolean bl = this.proppatchMethod(this.httpURL.getPath(), hashtable, true);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean proppatchMethod(Hashtable hashtable, boolean bl) throws HttpException, IOException {
        boolean bl2 = this.proppatchMethod(this.httpURL.getPath(), hashtable, bl);
        if (bl2) {
            this.refresh();
        }
        return bl2;
    }

    public boolean proppatchMethod(String string, Hashtable hashtable) throws HttpException, IOException {
        return this.proppatchMethod(string, hashtable, true);
    }

    public boolean proppatchMethod(String string, Hashtable hashtable, boolean bl) throws HttpException, IOException {
        this.setClient();
        PropPatchMethod propPatchMethod = new PropPatchMethod(URIUtil.encodePath(string));
        propPatchMethod.setDebug(this.debug);
        propPatchMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(propPatchMethod);
        Enumeration enumeration = hashtable.keys();
        boolean bl2 = false;
        if (enumeration.hasMoreElements()) {
            bl2 = true;
        }
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3;
            Object k2 = enumeration.nextElement();
            if (k2 instanceof String) {
                string3 = (String)k2;
                string2 = (String)hashtable.get(k2);
                if (bl) {
                    propPatchMethod.addPropertyToSet(string3, string2);
                    continue;
                }
                propPatchMethod.addPropertyToRemove(string3);
                continue;
            }
            if (!(k2 instanceof PropertyName)) continue;
            string3 = ((PropertyName)k2).getLocalName();
            string2 = ((PropertyName)k2).getNamespaceURI();
            String string4 = (String)hashtable.get(k2);
            if (bl) {
                propPatchMethod.addPropertyToSet(string3, string4, null, string2);
                continue;
            }
            propPatchMethod.addPropertyToRemove(string3, null, string2);
        }
        if (bl2) {
            this.generateTransactionHeader(propPatchMethod);
            int n = this.client.executeMethod(propPatchMethod);
            this.setStatusCode(n);
            if (n >= 200 && n < 300) {
                return true;
            }
        }
        return false;
    }

    public boolean headMethod() throws HttpException, IOException {
        return this.headMethod(this.httpURL.getPathQuery());
    }

    public boolean headMethod(String string) throws HttpException, IOException {
        this.setClient();
        HeadMethod headMethod = new HeadMethod(URIUtil.encodePathQuery(string));
        this.generateTransactionHeader(headMethod);
        int n = this.client.executeMethod(headMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean deleteMethod() throws HttpException, IOException {
        boolean bl = this.deleteMethod(this.httpURL.getPath());
        if (bl) {
            this.setExistence(false);
        }
        return bl;
    }

    public boolean deleteMethod(String string) throws HttpException, IOException {
        this.setClient();
        DeleteMethod deleteMethod = new DeleteMethod(URIUtil.encodePath(string));
        deleteMethod.setDebug(this.debug);
        deleteMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(deleteMethod);
        this.generateTransactionHeader(deleteMethod);
        int n = this.client.executeMethod(deleteMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean moveMethod(String string) throws HttpException, IOException {
        boolean bl = this.moveMethod(this.httpURL.getPath(), string);
        if (bl) {
            this.httpURL.setPath(string);
            this.refresh();
        }
        return bl;
    }

    public boolean moveMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        MoveMethod moveMethod = new MoveMethod(URIUtil.encodePath(string), URIUtil.encodePath(string2));
        moveMethod.setDebug(this.debug);
        moveMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(moveMethod);
        moveMethod.setOverwrite(this.overwrite);
        this.generateTransactionHeader(moveMethod);
        int n = this.client.executeMethod(moveMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean copyMethod(String string) throws HttpException, IOException {
        boolean bl = this.copyMethod(this.httpURL.getPath(), string);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean copyMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        CopyMethod copyMethod = new CopyMethod(URIUtil.encodePath(string), URIUtil.encodePath(string2));
        copyMethod.setDebug(this.debug);
        copyMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(copyMethod);
        copyMethod.setOverwrite(this.overwrite);
        this.generateTransactionHeader(copyMethod);
        int n = this.client.executeMethod(copyMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean mkcolMethod() throws HttpException, IOException {
        boolean bl = this.mkcolMethod(this.httpURL.getPath());
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean mkcolMethod(String string) throws HttpException, IOException {
        this.setClient();
        MkcolMethod mkcolMethod = new MkcolMethod(URIUtil.encodePath(string));
        this.generateIfHeader(mkcolMethod);
        this.generateTransactionHeader(mkcolMethod);
        int n = this.client.executeMethod(mkcolMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean lockMethod() throws HttpException, IOException {
        String string = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        boolean bl = this.lockMethod(this.httpURL.getPath(), string, 120);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean lockMethod(String string, int n) throws HttpException, IOException {
        boolean bl = this.lockMethod(this.httpURL.getPath(), string, n);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean lockMethod(String string) throws HttpException, IOException {
        String string2 = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        return this.lockMethod(string, string2, 120);
    }

    public boolean lockMethod(String string, String string2, int n) throws HttpException, IOException {
        return this.lockMethod(string, string2, n, (short)0);
    }

    public boolean lockMethod(String string, String string2, int n, short s) throws HttpException, IOException {
        return this.lockMethod(string, string2, n, s, Integer.MAX_VALUE);
    }

    public boolean lockMethod(String string, String string2, int n, short s, int n2) throws HttpException, IOException {
        this.setClient();
        if (string2 == null) {
            string2 = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        }
        LockMethod lockMethod = new LockMethod(URIUtil.encodePath(string), string2, s, n);
        lockMethod.setDebug(this.debug);
        lockMethod.setFollowRedirects(this.followRedirects);
        lockMethod.setDepth(n2);
        this.generateIfHeader(lockMethod);
        this.generateTransactionHeader(lockMethod);
        int n3 = this.client.executeMethod(lockMethod);
        String string3 = lockMethod.getLockToken();
        WebdavState webdavState = (WebdavState)this.client.getState();
        if (webdavState != null) {
            webdavState.addLock(string, string3);
        }
        this.owner = lockMethod.getOwner();
        this.setStatusCode(n3, string3);
        return n3 >= 200 && n3 < 300;
    }

    public boolean lockMethod(String string, short s) throws HttpException, IOException {
        return this.lockMethod(string, (int)s);
    }

    public boolean lockMethod(String string, String string2, short s) throws HttpException, IOException {
        return this.lockMethod(string, string2, (int)s);
    }

    public boolean startTransaction(String string, int n) throws IOException {
        String string2 = this.httpURL.getPath();
        this.setClient();
        if (string == null) {
            string = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        }
        LockMethod lockMethod = new LockMethod(string2, string, n, true);
        lockMethod.setDebug(this.debug);
        lockMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(lockMethod);
        int n2 = this.client.executeMethod(lockMethod);
        String string3 = lockMethod.getLockToken();
        WebdavState webdavState = (WebdavState)this.client.getState();
        if (webdavState != null) {
            webdavState.setTransactionHandle(string3);
        }
        this.owner = lockMethod.getOwner();
        this.setStatusCode(n2, string3);
        return n2 >= 200 && n2 < 300;
    }

    public String getTransactionHandle() throws IOException {
        this.setClient();
        WebdavState webdavState = (WebdavState)this.client.getState();
        if (webdavState == null) {
            return null;
        }
        String string = webdavState.getTransactionHandle();
        return string;
    }

    public boolean commitTransaction() throws IOException {
        String string = this.httpURL.getPath();
        return this.endTransaction(string, 1);
    }

    public boolean abortTransaction() throws IOException {
        String string = this.httpURL.getPath();
        return this.endTransaction(string, 0);
    }

    protected boolean endTransaction(String string, int n) throws IOException {
        this.setClient();
        WebdavState webdavState = (WebdavState)this.client.getState();
        if (webdavState == null) {
            return false;
        }
        String string2 = webdavState.getTransactionHandle();
        if (string2 == null) {
            return false;
        }
        UnlockMethod unlockMethod = new UnlockMethod(string, string2, n);
        unlockMethod.setDebug(this.debug);
        unlockMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(unlockMethod);
        int n2 = this.client.executeMethod(unlockMethod);
        this.setStatusCode(n2);
        if (n2 >= 200 && n2 < 300) {
            webdavState.setTransactionHandle(null);
            return true;
        }
        return false;
    }

    public boolean unlockMethod() throws HttpException, IOException {
        String string = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        boolean bl = this.unlockMethod(this.httpURL.getPath(), string);
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean unlockMethod(String string) throws HttpException, IOException {
        String string2 = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        return this.unlockMethod(string, string2);
    }

    public boolean unlockMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        if (string2 == null) {
            string2 = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        }
        WebdavState webdavState = (WebdavState)this.client.getState();
        String string3 = (webdavState = this.discoverLock(string2, string, webdavState)).getLock(string);
        if (string3 == null) {
            return false;
        }
        UnlockMethod unlockMethod = new UnlockMethod(URIUtil.encodePath(string));
        unlockMethod.setDebug(this.debug);
        unlockMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(unlockMethod);
        this.generateTransactionHeader(unlockMethod);
        unlockMethod.setLockToken(string3);
        int n = this.client.executeMethod(unlockMethod);
        this.setStatusCode(n);
        if (n >= 200 && n < 300) {
            webdavState.removeLocks(string);
            return true;
        }
        return false;
    }

    public void discoverOwnLocks() throws HttpException, IOException {
        this.setClient();
        String string = this.httpURL.getUser() != null ? this.httpURL.getUser() : defaultOwner;
        WebdavState webdavState = (WebdavState)this.client.getState();
        webdavState = this.discoverLock(string, this.httpURL.getPath(), webdavState);
        this.client.setState(webdavState);
    }

    public void discoverOwnLocks(String string) throws HttpException, IOException {
        this.setClient();
        WebdavState webdavState = (WebdavState)this.client.getState();
        webdavState = this.discoverLock(string, this.httpURL.getPath(), webdavState);
        this.client.setState(webdavState);
    }

    protected WebdavState discoverLock(String string, String string2, WebdavState webdavState) {
        try {
            this.lockDiscovery = this.lockDiscoveryPropertyFindMethod(string2);
        }
        catch (Exception exception) {
            return webdavState;
        }
        if (this.lockDiscovery == null) {
            return webdavState;
        }
        Lock[] lockArray = this.lockDiscovery.getActiveLocks();
        if (lockArray == null) {
            return webdavState;
        }
        for (int i2 = 0; i2 < lockArray.length; ++i2) {
            String string3 = lockArray[i2].getOwner();
            if (!string3.equals(string)) continue;
            String string4 = lockArray[i2].getLockToken();
            webdavState.addLock(string2, string4);
        }
        return webdavState;
    }

    public boolean updateMethod(String string) throws HttpException, IOException {
        return this.updateMethod(this.httpURL.getPath(), string);
    }

    public boolean updateMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        UpdateMethod updateMethod = new UpdateMethod(URIUtil.encodePath(string), URIUtil.encodePath(string2));
        updateMethod.setDebug(this.debug);
        updateMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(updateMethod);
        this.generateTransactionHeader(updateMethod);
        int n = this.client.executeMethod(updateMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean versionControlMethod(String string) throws HttpException, IOException {
        this.setClient();
        VersionControlMethod versionControlMethod = new VersionControlMethod(URIUtil.encodePath(string));
        versionControlMethod.setDebug(this.debug);
        versionControlMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(versionControlMethod);
        this.generateTransactionHeader(versionControlMethod);
        int n = this.client.executeMethod(versionControlMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean versionControlMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        VersionControlMethod versionControlMethod = new VersionControlMethod(URIUtil.encodePath(string), URIUtil.encodePath(string2));
        versionControlMethod.setDebug(this.debug);
        versionControlMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(versionControlMethod);
        this.generateTransactionHeader(versionControlMethod);
        int n = this.client.executeMethod(versionControlMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean mkWorkspaceMethod() throws HttpException, IOException {
        boolean bl = this.mkWorkspaceMethod(this.httpURL.getPath());
        if (bl) {
            this.refresh();
        }
        return bl;
    }

    public boolean mkWorkspaceMethod(String string) throws HttpException, IOException {
        this.setClient();
        MkWorkspaceMethod mkWorkspaceMethod = new MkWorkspaceMethod(URIUtil.encodePath(string));
        mkWorkspaceMethod.setDebug(this.debug);
        mkWorkspaceMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(mkWorkspaceMethod);
        this.generateTransactionHeader(mkWorkspaceMethod);
        int n = this.client.executeMethod(mkWorkspaceMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public int compareToWebdavResource(WebdavResource webdavResource) {
        try {
            int n;
            HttpURL httpURL = webdavResource.getHttpURL();
            String string = this.httpURL.getHost();
            String string2 = httpURL.getHost();
            if (!string.equalsIgnoreCase(string2)) {
                return string.compareTo(string2);
            }
            int n2 = this.httpURL.getPort();
            if (n2 != (n = httpURL.getPort())) {
                return n2 < n ? -1 : 1;
            }
            boolean bl = this.isCollection();
            boolean bl2 = webdavResource.isCollection();
            if (bl && !bl2) {
                return -1;
            }
            if (bl2 && !bl) {
                return 1;
            }
            String string3 = this.httpURL.getPathQuery();
            String string4 = httpURL.getPathQuery();
            return string3.compareTo(string4);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(Object object) {
        if (object != null && object instanceof WebdavResource) {
            return this.compareToWebdavResource((WebdavResource)object);
        }
        String string = this.toString();
        String string2 = object.toString();
        return string.compareTo(string2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof WebdavResource) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public String toString() {
        return this.httpURL.toString();
    }

    public boolean checkinMethod() throws HttpException, IOException {
        return this.checkinMethod(this.httpURL.getPath());
    }

    public boolean checkinMethod(String string) throws HttpException, IOException {
        this.setClient();
        CheckinMethod checkinMethod = new CheckinMethod(URIUtil.encodePath(string));
        checkinMethod.setDebug(this.debug);
        checkinMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(checkinMethod);
        this.generateTransactionHeader(checkinMethod);
        int n = this.client.executeMethod(checkinMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean checkoutMethod() throws HttpException, IOException {
        return this.checkoutMethod(this.httpURL.getPath());
    }

    public boolean checkoutMethod(String string) throws HttpException, IOException {
        this.setClient();
        CheckoutMethod checkoutMethod = new CheckoutMethod(URIUtil.encodePath(string));
        checkoutMethod.setDebug(this.debug);
        checkoutMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(checkoutMethod);
        this.generateTransactionHeader(checkoutMethod);
        int n = this.client.executeMethod(checkoutMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean uncheckoutMethod() throws HttpException, IOException {
        return this.uncheckoutMethod(this.httpURL.getPath());
    }

    public boolean uncheckoutMethod(String string) throws HttpException, IOException {
        this.setClient();
        UncheckoutMethod uncheckoutMethod = new UncheckoutMethod(URIUtil.encodePath(string));
        uncheckoutMethod.setDebug(this.debug);
        uncheckoutMethod.setFollowRedirects(this.followRedirects);
        this.generateIfHeader(uncheckoutMethod);
        this.generateTransactionHeader(uncheckoutMethod);
        int n = this.client.executeMethod(uncheckoutMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    protected WebdavResource createWebdavResource(HttpClient httpClient) {
        WebdavResource webdavResource = new WebdavResource(httpClient);
        webdavResource.setProxy(this.proxyHost, this.proxyPort);
        webdavResource.setProxyCredentials(this.proxyCredentials);
        return webdavResource;
    }

    protected void processProperty(Property property) {
        if (property.getLocalName().equals(DISPLAYNAME)) {
            this.displayName = property.getPropertyAsString();
        } else if (property.getLocalName().equals(GETCONTENTLENGTH)) {
            String string = property.getPropertyAsString();
            this.setGetContentLength(string);
        } else if (property.getLocalName().equals(RESOURCETYPE)) {
            ResourceTypeProperty resourceTypeProperty = (ResourceTypeProperty)property;
            this.setResourceType(resourceTypeProperty);
        } else if (property.getLocalName().equals(GETCONTENTTYPE)) {
            String string = property.getPropertyAsString();
            this.setGetContentType(string);
        } else if (property.getLocalName().equals(GETLASTMODIFIED)) {
            String string = property.getPropertyAsString();
            this.setGetLastModified(string);
        } else if (property.getLocalName().equals(CREATIONDATE)) {
            String string = property.getPropertyAsString();
            this.setCreationDate(string);
        } else if (property.getLocalName().equals(GETETAG)) {
            String string = property.getPropertyAsString();
            this.setGetEtag(string);
        } else if (property.getLocalName().equals(ISHIDDEN)) {
            String string = property.getPropertyAsString();
            this.setIsHidden(string);
        } else if (property.getLocalName().equals(ISCOLLECTION)) {
            String string = property.getPropertyAsString();
            this.setIsCollection(string);
        } else if (property.getLocalName().equals(SUPPORTEDLOCK)) {
            String string = property.getPropertyAsString();
            this.setSupportedLock(string);
        } else if (property.getLocalName().equals(LOCKDISCOVERY)) {
            LockDiscoveryProperty lockDiscoveryProperty = (LockDiscoveryProperty)property;
            this.setLockDiscovery(lockDiscoveryProperty);
        }
    }

    public Enumeration aclReportMethod(String string, Collection collection, int n) throws HttpException, IOException {
        this.setClient();
        AclReportMethod aclReportMethod = new AclReportMethod(URIUtil.encodePath(string), collection, Integer.MAX_VALUE, n);
        aclReportMethod.setDebug(this.debug);
        aclReportMethod.setFollowRedirects(this.followRedirects);
        this.generateTransactionHeader(aclReportMethod);
        int n2 = this.client.executeMethod(aclReportMethod);
        if (this.thisResource) {
            this.setStatusCode(aclReportMethod.getStatusLine().getStatusCode());
        }
        if (n2 != 207 && n2 != 200) {
            HttpException httpException = new HttpException();
            httpException.setReasonCode(n2);
            throw httpException;
        }
        this.thisResource = false;
        return aclReportMethod.getResponses();
    }

    public boolean bindMethod(String string) throws HttpException, IOException {
        return this.bindMethod(this.httpURL.getPath(), string);
    }

    public boolean bindMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        BindMethod bindMethod = new BindMethod(URIUtil.encodePath(string), URIUtil.encodePath(string2));
        bindMethod.setDebug(this.debug);
        bindMethod.setOverwrite(this.overwrite);
        this.generateTransactionHeader(bindMethod);
        int n = this.client.executeMethod(bindMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean unbindMethod() throws HttpException, IOException {
        boolean bl = this.unbindMethod(this.httpURL.getPath());
        if (bl) {
            this.setExistence(false);
        }
        return bl;
    }

    public boolean unbindMethod(String string) throws HttpException, IOException {
        this.setClient();
        UnbindMethod unbindMethod = new UnbindMethod(URIUtil.encodePath(string));
        unbindMethod.setDebug(this.debug);
        this.generateTransactionHeader(unbindMethod);
        int n = this.client.executeMethod(unbindMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public boolean rebindMethod(String string) throws HttpException, IOException {
        boolean bl = this.rebindMethod(this.httpURL.getPath(), string);
        if (bl) {
            this.httpURL.setPath(string);
            this.refresh();
        }
        return bl;
    }

    public boolean rebindMethod(String string, String string2) throws HttpException, IOException {
        this.setClient();
        RebindMethod rebindMethod = new RebindMethod(URIUtil.encodePath(string), URIUtil.encodePath(string2));
        rebindMethod.setDebug(this.debug);
        rebindMethod.setOverwrite(this.overwrite);
        this.generateTransactionHeader(rebindMethod);
        int n = this.client.executeMethod(rebindMethod);
        this.setStatusCode(n);
        return n >= 200 && n < 300;
    }

    public Subscription subscribeMethod(String string, String string2, String string3, long l2, int n, long l3) throws HttpException, IOException {
        this.setClient();
        SubscribeMethod subscribeMethod = new SubscribeMethod(string);
        subscribeMethod.setDebug(this.debug);
        subscribeMethod.setFollowRedirects(this.followRedirects);
        subscribeMethod.setCallback(string3);
        subscribeMethod.setDepth(n);
        subscribeMethod.setSubsciptionLifetime(l3);
        subscribeMethod.setNotificationType(string2);
        subscribeMethod.setNotificationDelay(l2);
        this.generateTransactionHeader(subscribeMethod);
        int n2 = this.client.executeMethod(subscribeMethod);
        if (n2 == 200) {
            return new Subscription(string, subscribeMethod.getResponsedSubscriptionId(), subscribeMethod.getCallback(), subscribeMethod.getResponsedSubscriptionLifetime(), subscribeMethod.getResponsedContentLocation(), subscribeMethod.getNotificationType());
        }
        return null;
    }

    public boolean subscribeMethod(String string, int n) throws HttpException, IOException {
        this.setClient();
        SubscribeMethod subscribeMethod = new SubscribeMethod(string);
        subscribeMethod.setDebug(this.debug);
        subscribeMethod.setFollowRedirects(this.followRedirects);
        subscribeMethod.setSubscriptionId(n);
        this.generateTransactionHeader(subscribeMethod);
        int n2 = this.client.executeMethod(subscribeMethod);
        return n2 == 200;
    }

    public boolean subscribeMethod(Subscription subscription) throws HttpException, IOException {
        return this.subscribeMethod(subscription.getPath(), subscription.getId());
    }

    public boolean unsubscribeMethod(String string, int n) throws HttpException, IOException {
        this.setClient();
        UnsubscribeMethod unsubscribeMethod = new UnsubscribeMethod(string);
        unsubscribeMethod.setDebug(this.debug);
        unsubscribeMethod.setFollowRedirects(this.followRedirects);
        unsubscribeMethod.addSubscriptionId(n);
        this.generateTransactionHeader(unsubscribeMethod);
        int n2 = this.client.executeMethod(unsubscribeMethod);
        return n2 == 200;
    }

    public boolean unsubscribeMethod(Subscription subscription) throws HttpException, IOException {
        return this.unsubscribeMethod(subscription.getPath(), subscription.getId());
    }

    public boolean pollMethod(String string, int n) throws HttpException, IOException {
        this.setClient();
        PollMethod pollMethod = new PollMethod(string);
        pollMethod.setDebug(this.debug);
        pollMethod.setFollowRedirects(this.followRedirects);
        pollMethod.addSubscriptionId(n);
        this.generateTransactionHeader(pollMethod);
        int n2 = this.client.executeMethod(pollMethod);
        if (n2 == 207) {
            return pollMethod.getSubscriptionsWithEvents().size() > 0;
        }
        return false;
    }

    public boolean pollMethod(Subscription subscription) throws HttpException, IOException {
        return this.pollMethod(subscription.getContentLocation(), subscription.getId());
    }

    private static String a(String string) {
        String string2 = URIUtil.getName(string.endsWith("/") ? string.substring(0, string.length() - 1) : string);
        try {
            return URIUtil.decode(string2);
        }
        catch (URIException uRIException) {
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String if(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = 0;
        while (true) {
            block23: {
                block22: {
                    if (n >= cArray.length) {
                        return stringBuffer.toString();
                    }
                    if (cArray[n] != '%' || n >= cArray.length - 2) break block22;
                    switch (cArray[n + 1]) {
                        case '2': {
                            switch (cArray[n + 2]) {
                                case 'D': 
                                case 'd': {
                                    stringBuffer.append('-');
                                    n += 2;
                                    break block23;
                                }
                                case 'E': 
                                case 'e': {
                                    stringBuffer.append('.');
                                    n += 2;
                                    break block23;
                                }
                                case '1': {
                                    stringBuffer.append('!');
                                    n += 2;
                                    break block23;
                                }
                                case 'A': 
                                case 'a': {
                                    stringBuffer.append('*');
                                    n += 2;
                                    break block23;
                                }
                                case '7': {
                                    stringBuffer.append('\'');
                                    n += 2;
                                    break block23;
                                }
                                case '8': {
                                    stringBuffer.append('(');
                                    n += 2;
                                    break block23;
                                }
                                case '9': {
                                    stringBuffer.append(')');
                                    n += 2;
                                    break block23;
                                }
                            }
                            break;
                        }
                        case '5': {
                            switch (cArray[n + 2]) {
                                case 'F': 
                                case 'f': {
                                    stringBuffer.append('_');
                                    n += 2;
                                    break block23;
                                }
                            }
                            break;
                        }
                        case '7': {
                            switch (cArray[n + 2]) {
                                case 'E': 
                                case 'e': {
                                    stringBuffer.append('~');
                                    n += 2;
                                    break block23;
                                }
                            }
                        }
                    }
                }
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
    }

    private char[] a(char[] cArray) {
        String string = new String(cArray);
        string = string.replaceAll("\\Q^\\E", "%5E");
        string = string.replaceAll("\\Q{\\E", "%7B");
        string = string.replaceAll("\\Q}\\E", "%7D");
        string = string.replaceAll("\\Q]\\E", "%5D");
        string = string.replaceAll("\\Q[\\E", "%5B");
        string = string.replaceAll("\\Q`\\E", "%60");
        string = string.replaceAll("\\Q>\\E", "%3E");
        string = string.replaceAll("\\Q<\\E", "%3C");
        return string.toCharArray();
    }

    static {
        for (int i2 = 0; i2 < formats.length; ++i2) {
            formats[i2].setTimeZone(gmtZone);
        }
        defaultAction = 3;
        defaultDepth = 0;
        useDiskForGet = true;
    }
}

