/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.methods;

import java.io.IOException;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpMethodBase;
import jec.httpclient.HttpState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeadMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog((Class)HeadMethod.class);
    private int bodyCheckTimeout = -1;

    public HeadMethod() {
        this.setFollowRedirects(true);
    }

    public HeadMethod(String uri) {
        super(uri);
        this.setFollowRedirects(true);
    }

    public String getName() {
        return "HEAD";
    }

    public void recycle() {
        super.recycle();
        this.setFollowRedirects(true);
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException {
        LOG.trace((Object)"enter HeadMethod.readResponseBody(HttpState, HttpConnection)");
        if (this.bodyCheckTimeout < 0) {
            this.responseBodyConsumed();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Check for non-compliant response body. Timeout in " + this.bodyCheckTimeout + " ms"));
            }
            boolean responseAvailable = false;
            try {
                responseAvailable = conn.isResponseAvailable(this.bodyCheckTimeout);
            }
            catch (IOException e2) {
                LOG.debug((Object)"An IOException occurred while testing if a response was available, we will assume one is not.", (Throwable)e2);
                responseAvailable = false;
            }
            if (responseAvailable) {
                if (this.isStrictMode()) {
                    throw new HttpException("Body content may not be sent in response to HTTP HEAD request");
                }
                LOG.warn((Object)"Body content returned in response to HTTP HEAD");
                super.readResponseBody(state, conn);
            }
        }
    }

    public int getBodyCheckTimeout() {
        return this.bodyCheckTimeout;
    }

    public void setBodyCheckTimeout(int timeout) {
        this.bodyCheckTimeout = timeout;
    }
}

