/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient.auth;

import jec.httpclient.Credentials;
import jec.httpclient.HttpConstants;
import jec.httpclient.UsernamePasswordCredentials;
import jec.httpclient.auth.AuthenticationException;
import jec.httpclient.auth.MalformedChallengeException;
import jec.httpclient.auth.RFC2617Scheme;
import jec.httpclient.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicScheme
extends RFC2617Scheme {
    private static final Log LOG = LogFactory.getLog((Class)BasicScheme.class);

    public BasicScheme(String challenge) throws MalformedChallengeException {
        super(challenge);
    }

    public String getSchemeName() {
        return "basic";
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        LOG.trace((Object)"enter BasicScheme.authenticate(Credentials, String, String)");
        UsernamePasswordCredentials usernamepassword = null;
        try {
            usernamepassword = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException e2) {
            throw new AuthenticationException("Credentials cannot be used for basic authentication: " + credentials.getClass().getName());
        }
        return BasicScheme.authenticate(usernamepassword);
    }

    public static String authenticate(UsernamePasswordCredentials credentials) {
        LOG.trace((Object)"enter BasicScheme.authenticate(UsernamePasswordCredentials)");
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(credentials.getUserName());
        buffer.append(":");
        buffer.append(credentials.getPassword());
        return "Basic " + HttpConstants.getAsciiString(Base64.encode(HttpConstants.getContentBytes(buffer.toString())));
    }
}

