/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import jec.httpclient.ChunkedInputStream;

public class ContentLengthInputStream
extends FilterInputStream {
    private int contentLength;
    private int pos = 0;
    private boolean closed = false;

    public ContentLengthInputStream(InputStream in, int contentLength) {
        super(in);
        this.contentLength = contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                ChunkedInputStream.exhaustInputStream(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        ++this.pos;
        return super.read();
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.pos >= this.contentLength) {
            return -1;
        }
        if (this.pos + len > this.contentLength) {
            len = this.contentLength - this.pos;
        }
        int count = super.read(b2, off, len);
        this.pos += count;
        return count;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }
}

