/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jec.httpclient.Header;
import jec.httpclient.HttpConstants;
import jec.httpclient.HttpMethod;
import jec.httpclient.HttpParser;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int chunkSize;
    private int pos;
    private boolean bof = true;
    private boolean eof = false;
    private boolean closed = false;
    private HttpMethod method;

    public ChunkedInputStream(InputStream in, HttpMethod method) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream parameter may not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("HttpMethod parameter may not be null");
        }
        this.in = in;
        this.method = method;
        this.pos = 0;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.pos;
        return this.in.read();
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.pos >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        len = Math.min(len, this.chunkSize - this.pos);
        int count = this.in.read(b2, off, len);
        this.pos += count;
        return count;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    private void readCRLF() throws IOException {
        int cr = this.in.read();
        int lf = this.in.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("CRLF expected at end of chunk: " + cr + "/" + lf);
        }
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.readCRLF();
        }
        this.chunkSize = ChunkedInputStream.getChunkSizeFromInputStream(this.in);
        this.bof = false;
        this.pos = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
            this.parseTrailerHeaders();
        }
    }

    private static int getChunkSizeFromInputStream(InputStream in) throws IOException {
        int result;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int state = 0;
        block15: while (state != -1) {
            int b2 = in.read();
            if (b2 == -1) {
                throw new IOException("chunked stream ended unexpectedly");
            }
            switch (state) {
                case 0: {
                    switch (b2) {
                        case 13: {
                            state = 1;
                            continue block15;
                        }
                        case 34: {
                            state = 2;
                        }
                    }
                    baos.write(b2);
                    continue block15;
                }
                case 1: {
                    if (b2 == 10) {
                        state = -1;
                        continue block15;
                    }
                    throw new IOException("Protocol violation: Unexpected single newline character in chunk size");
                }
                case 2: {
                    switch (b2) {
                        case 92: {
                            b2 = in.read();
                            baos.write(b2);
                            continue block15;
                        }
                        case 34: {
                            state = 0;
                        }
                    }
                    baos.write(b2);
                    continue block15;
                }
            }
            throw new RuntimeException("assertion failed");
        }
        String dataString = HttpConstants.getString(baos.toByteArray());
        int separator = dataString.indexOf(59);
        dataString = separator > 0 ? dataString.substring(0, separator).trim() : dataString.trim();
        try {
            result = Integer.parseInt(dataString.trim(), 16);
        }
        catch (NumberFormatException e2) {
            throw new IOException("Bad chunk size: " + dataString);
        }
        return result;
    }

    private void parseTrailerHeaders() throws IOException {
        Header[] footers = HttpParser.parseHeaders(this.in);
        for (int i2 = 0; i2 < footers.length; ++i2) {
            this.method.addResponseFooter(footers[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof) {
                    ChunkedInputStream.exhaustInputStream(this);
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    static void exhaustInputStream(InputStream inStream) throws IOException {
        byte[] buffer = new byte[1024];
        while (inStream.read(buffer) >= 0) {
        }
    }
}

