/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import jec.httpclient.ResponseConsumedWatcher;

class AutoCloseInputStream
extends FilterInputStream {
    private boolean streamOpen = true;
    private boolean selfClosed = false;
    private ResponseConsumedWatcher watcher = null;

    public AutoCloseInputStream(InputStream in, ResponseConsumedWatcher watcher) {
        super(in);
        this.watcher = watcher;
    }

    public int read() throws IOException {
        int l2 = -1;
        if (this.isReadAllowed()) {
            l2 = super.read();
            this.checkClose(l2);
        }
        return l2;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int l2 = -1;
        if (this.isReadAllowed()) {
            l2 = super.read(b2, off, len);
            this.checkClose(l2);
        }
        return l2;
    }

    public int read(byte[] b2) throws IOException {
        int l2 = -1;
        if (this.isReadAllowed()) {
            l2 = super.read(b2);
            this.checkClose(l2);
        }
        return l2;
    }

    public void close() throws IOException {
        if (!this.selfClosed) {
            this.selfClosed = true;
            this.notifyWatcher();
        }
    }

    private void checkClose(int readResult) throws IOException {
        if (readResult == -1) {
            this.notifyWatcher();
        }
    }

    private boolean isReadAllowed() throws IOException {
        if (!this.streamOpen && this.selfClosed) {
            throw new IOException("Attempted read on closed stream.");
        }
        return this.streamOpen;
    }

    private void notifyWatcher() throws IOException {
        if (this.streamOpen) {
            super.close();
            this.streamOpen = false;
            if (this.watcher != null) {
                this.watcher.responseConsumed();
            }
        }
    }
}

