/*
 * Decompiled with CFR 0.152.
 */
package jec.httpclient;

import java.util.ArrayList;
import jec.httpclient.Header;
import jec.httpclient.HttpConnection;
import jec.httpclient.HttpException;
import jec.httpclient.HttpMethod;
import jec.httpclient.HttpState;
import jec.httpclient.auth.AuthScheme;
import jec.httpclient.auth.HttpAuthenticator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Authenticator {
    private static final Log LOG = LogFactory.getLog((Class)Authenticator.class);
    public static final String WWW_AUTH = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";

    public static boolean authenticate(HttpMethod method, HttpState state) throws HttpException, UnsupportedOperationException {
        LOG.trace((Object)"enter Authenticator.authenticate(HttpMethod, HttpState)");
        return Authenticator.authenticate(method, state, false);
    }

    public static boolean authenticateProxy(HttpMethod method, HttpState state) throws HttpException, UnsupportedOperationException {
        LOG.trace((Object)"enter Authenticator.authenticateProxy(HttpMethod, HttpState)");
        return Authenticator.authenticate(method, state, true);
    }

    private static boolean authenticate(HttpMethod method, HttpState state, boolean proxy) throws HttpException, UnsupportedOperationException {
        LOG.trace((Object)"enter Authenticator.authenticate(HttpMethod, HttpState, Header, String)");
        return Authenticator.authenticate(method, null, state, proxy);
    }

    private static boolean authenticate(HttpMethod method, HttpConnection conn, HttpState state, boolean proxy) throws HttpException, UnsupportedOperationException {
        String challengeheader = proxy ? PROXY_AUTH : WWW_AUTH;
        Header[] headers = method.getResponseHeaders();
        ArrayList<Header> headerlist = new ArrayList<Header>();
        for (int i2 = 0; i2 < headers.length; ++i2) {
            Header header = headers[i2];
            if (!header.getName().equalsIgnoreCase(challengeheader)) continue;
            headerlist.add(header);
        }
        headers = headerlist.toArray(new Header[headerlist.size()]);
        headerlist = null;
        if (headers.length == 0) {
            if (state.isAuthenticationPreemptive()) {
                LOG.debug((Object)"Preemptively sending default basic credentials");
                if (proxy) {
                    return HttpAuthenticator.authenticateProxyDefault(method, conn, state);
                }
                return HttpAuthenticator.authenticateDefault(method, conn, state);
            }
            return false;
        }
        AuthScheme authscheme = HttpAuthenticator.selectAuthScheme(headers);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using " + authscheme.getSchemeName() + " authentication scheme"));
        }
        if (proxy) {
            return HttpAuthenticator.authenticateProxy(authscheme, method, conn, state);
        }
        return HttpAuthenticator.authenticate(authscheme, method, conn, state);
    }
}

