/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.jaredrummler.android.processes.models.Cgroup;
import com.jaredrummler.android.processes.models.ProcFile;
import com.jaredrummler.android.processes.models.Stat;
import com.jaredrummler.android.processes.models.Statm;
import com.jaredrummler.android.processes.models.Status;
import java.io.IOException;
import java.util.Locale;

public class AndroidProcess
implements Parcelable {
    public final String name;
    public final int pid;
    public static final Parcelable.Creator<AndroidProcess> CREATOR = new Parcelable.Creator<AndroidProcess>(){

        public AndroidProcess createFromParcel(Parcel source) {
            return new AndroidProcess(source);
        }

        public AndroidProcess[] newArray(int size) {
            return new AndroidProcess[size];
        }
    };

    public AndroidProcess(int pid) throws IOException {
        this.pid = pid;
        this.name = this.getProcessName(pid);
    }

    protected AndroidProcess(Parcel in) {
        this.name = in.readString();
        this.pid = in.readInt();
    }

    public String read(String filename) throws IOException {
        return ProcFile.readFile(String.format(Locale.ENGLISH, "/proc/%d/%s", this.pid, filename));
    }

    public String attr_current() throws IOException {
        return this.read("attr/current");
    }

    public String cmdline() throws IOException {
        return this.read("cmdline");
    }

    public Cgroup cgroup() throws IOException {
        return Cgroup.get(this.pid);
    }

    public int oom_score() throws IOException {
        return Integer.parseInt(this.read("oom_score"));
    }

    public int oom_adj() throws IOException {
        return Integer.parseInt(this.read("oom_adj"));
    }

    public int oom_score_adj() throws IOException {
        return Integer.parseInt(this.read("oom_score_adj"));
    }

    public Stat stat() throws IOException {
        return Stat.get(this.pid);
    }

    public Statm statm() throws IOException {
        return Statm.get(this.pid);
    }

    public Status status() throws IOException {
        return Status.get(this.pid);
    }

    public String wchan() throws IOException {
        return this.read("wchan");
    }

    private String getProcessName(int pid) throws IOException {
        String cmdline = null;
        try {
            cmdline = ProcFile.readFile(String.format(Locale.ENGLISH, "/proc/%d/cmdline", pid)).trim();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (TextUtils.isEmpty(cmdline)) {
            try {
                return Stat.get(pid).getComm();
            }
            catch (Exception e) {
                throw new IOException(String.format(Locale.ENGLISH, "Error reading /proc/%d/stat", pid));
            }
        }
        return cmdline;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeInt(this.pid);
    }
}

