/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes.models;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.jaredrummler.android.processes.AndroidProcesses;
import com.jaredrummler.android.processes.models.AndroidProcess;
import com.jaredrummler.android.processes.models.Cgroup;
import com.jaredrummler.android.processes.models.ControlGroup;
import com.jaredrummler.android.processes.models.Stat;
import com.jaredrummler.android.processes.models.Status;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class AndroidAppProcess
extends AndroidProcess {
    private static final boolean SYS_SUPPORTS_SCHEDGROUPS = new File("/dev/cpuctl/tasks").exists();
    private static final Pattern PROCESS_NAME_PATTERN = Pattern.compile("^([A-Za-z]{1}[A-Za-z0-9_]*[\\.|:])*[A-Za-z][A-Za-z0-9_]*$");
    public final boolean foreground;
    public final int uid;
    public static final Parcelable.Creator<AndroidAppProcess> CREATOR = new Parcelable.Creator<AndroidAppProcess>(){

        public AndroidAppProcess createFromParcel(Parcel source) {
            return new AndroidAppProcess(source);
        }

        public AndroidAppProcess[] newArray(int size) {
            return new AndroidAppProcess[size];
        }
    };

    public AndroidAppProcess(int pid) throws IOException, NotAndroidAppProcessException {
        super(pid);
        int uid;
        boolean foreground;
        if (this.name == null || !PROCESS_NAME_PATTERN.matcher(this.name).matches() || !new File("/data/data", this.getPackageName()).exists()) {
            throw new NotAndroidAppProcessException(pid);
        }
        if (SYS_SUPPORTS_SCHEDGROUPS) {
            Cgroup cgroup = this.cgroup();
            ControlGroup cpuacct = cgroup.getGroup("cpuacct");
            ControlGroup cpu = cgroup.getGroup("cpu");
            if (Build.VERSION.SDK_INT >= 21) {
                if (cpu == null || cpuacct == null || !cpuacct.group.contains("pid_")) {
                    throw new NotAndroidAppProcessException(pid);
                }
                foreground = !cpu.group.contains("bg_non_interactive");
                try {
                    uid = Integer.parseInt(cpuacct.group.split("/")[1].replace("uid_", ""));
                }
                catch (Exception e) {
                    uid = this.status().getUid();
                }
                AndroidProcesses.log("name=%s, pid=%d, uid=%d, foreground=%b, cpuacct=%s, cpu=%s", this.name, pid, uid, foreground, cpuacct.toString(), cpu.toString());
            } else {
                if (cpu == null || cpuacct == null || !cpu.group.contains("apps")) {
                    throw new NotAndroidAppProcessException(pid);
                }
                foreground = !cpu.group.contains("bg_non_interactive");
                try {
                    uid = Integer.parseInt(cpuacct.group.substring(cpuacct.group.lastIndexOf("/") + 1));
                }
                catch (Exception e) {
                    uid = this.status().getUid();
                }
                AndroidProcesses.log("name=%s, pid=%d, uid=%d foreground=%b, cpuacct=%s, cpu=%s", this.name, pid, uid, foreground, cpuacct.toString(), cpu.toString());
            }
        } else {
            Stat stat = this.stat();
            Status status = this.status();
            foreground = stat.policy() == 0;
            uid = status.getUid();
            AndroidProcesses.log("name=%s, pid=%d, uid=%d foreground=%b", this.name, pid, uid, foreground);
        }
        this.foreground = foreground;
        this.uid = uid;
    }

    protected AndroidAppProcess(Parcel in) {
        super(in);
        this.foreground = in.readByte() != 0;
        this.uid = in.readInt();
    }

    public String getPackageName() {
        return this.name.split(":")[0];
    }

    public PackageInfo getPackageInfo(Context context, int flags) throws PackageManager.NameNotFoundException {
        return context.getPackageManager().getPackageInfo(this.getPackageName(), flags);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeByte((byte)(this.foreground ? 1 : 0));
        dest.writeInt(this.uid);
    }

    public static final class NotAndroidAppProcessException
    extends Exception {
        public NotAndroidAppProcessException(int pid) {
            super(String.format("The process %d does not belong to any application", pid));
        }
    }
}

