/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.jaredrummler.android.processes.models.AndroidAppProcess;
import com.jaredrummler.android.processes.models.AndroidProcess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class AndroidProcesses {
    public static final String TAG = "AndroidProcesses";
    private static final int AID_READPROC = 3009;
    private static boolean loggingEnabled;

    public static void setLoggingEnabled(boolean enabled) {
        loggingEnabled = enabled;
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static void log(String message, Object ... args) {
        if (loggingEnabled) {
            Log.d((String)TAG, (String)(args.length == 0 ? message : String.format(message, args)));
        }
    }

    public static void log(Throwable error, String message, Object ... args) {
        if (loggingEnabled) {
            Log.d((String)TAG, (String)(args.length == 0 ? message : String.format(message, args)), (Throwable)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProcessInfoHidden() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader("/proc/mounts"));
            String line = reader.readLine();
            while (true) {
                if (line != null) {
                    String[] columns = line.split("\\s+");
                    if (columns.length == 6 && columns[1].equals("/proc")) {
                        boolean bl = columns[3].contains("hidepid=1") || columns[3].contains("hidepid=2");
                        return bl;
                    }
                    line = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Error reading /proc/mounts. Checking if UID 'readproc' exists.");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Process.getUidForName((String)"readproc") == 3009;
    }

    public static List<AndroidProcess> getRunningProcesses() {
        File[] files;
        ArrayList<AndroidProcess> processes = new ArrayList<AndroidProcess>();
        for (File file : files = new File("/proc").listFiles()) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                processes.add(new AndroidProcess(pid));
            }
            catch (IOException e) {
                AndroidProcesses.log(e, "Error reading from /proc/%d.", pid);
            }
        }
        return processes;
    }

    public static List<AndroidAppProcess> getRunningAppProcesses() {
        File[] files;
        ArrayList<AndroidAppProcess> processes = new ArrayList<AndroidAppProcess>();
        for (File file : files = new File("/proc").listFiles()) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                processes.add(new AndroidAppProcess(pid));
            }
            catch (AndroidAppProcess.NotAndroidAppProcessException e) {
            }
            catch (IOException e) {
                AndroidProcesses.log(e, "Error reading from /proc/%d.", pid);
            }
        }
        return processes;
    }

    public static List<AndroidAppProcess> getRunningForegroundApps(Context context) {
        ArrayList<AndroidAppProcess> processes = new ArrayList<AndroidAppProcess>();
        File[] files = new File("/proc").listFiles();
        PackageManager pm = context.getPackageManager();
        for (File file : files) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                AndroidAppProcess process = new AndroidAppProcess(pid);
                if (!process.foreground || process.uid >= 1000 && process.uid <= 9999 || process.name.contains(":") || pm.getLaunchIntentForPackage(process.getPackageName()) == null) continue;
                processes.add(process);
            }
            catch (AndroidAppProcess.NotAndroidAppProcessException process) {
            }
            catch (IOException e) {
                AndroidProcesses.log(e, "Error reading from /proc/%d.", pid);
            }
        }
        return processes;
    }

    public static boolean isMyProcessInTheForeground() {
        try {
            return new AndroidAppProcess((int)Process.myPid()).foreground;
        }
        catch (Exception e) {
            AndroidProcesses.log(e, "Error finding our own process", new Object[0]);
            return false;
        }
    }

    public static List<ActivityManager.RunningAppProcessInfo> getRunningAppProcessInfo(Context context) {
        if (Build.VERSION.SDK_INT >= 22) {
            List<AndroidAppProcess> runningAppProcesses = AndroidProcesses.getRunningAppProcesses();
            ArrayList<ActivityManager.RunningAppProcessInfo> appProcessInfos = new ArrayList<ActivityManager.RunningAppProcessInfo>();
            for (AndroidAppProcess process : runningAppProcesses) {
                ActivityManager.RunningAppProcessInfo info = new ActivityManager.RunningAppProcessInfo(process.name, process.pid, null);
                info.uid = process.uid;
                appProcessInfos.add(info);
            }
            return appProcessInfos;
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        return am.getRunningAppProcesses();
    }

    AndroidProcesses() {
        throw new AssertionError((Object)"no instances");
    }

    public static final class ProcessComparator
    implements Comparator<AndroidProcess> {
        @Override
        public int compare(AndroidProcess p1, AndroidProcess p2) {
            return p1.name.compareToIgnoreCase(p2.name);
        }
    }
}

