/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes.models;

import com.jaredrummler.android.processes.models.ProcFile;
import java.io.IOException;

public final class Status
extends ProcFile {
    public static Status get(int pid) throws IOException {
        return new Status(String.format("/proc/%d/status", pid));
    }

    private Status(String path) throws IOException {
        super(path);
    }

    public String getValue(String fieldName) {
        String[] lines;
        for (String line : lines = this.content.split("\n")) {
            if (!line.startsWith(fieldName + ":")) continue;
            return line.split(fieldName + ":")[1].trim();
        }
        return null;
    }

    public int getUid() {
        try {
            return Integer.parseInt(this.getValue("Uid").split("\\s+")[0]);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getGid() {
        try {
            return Integer.parseInt(this.getValue("Gid").split("\\s+")[0]);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

