/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.jaredrummler.android.processes.models.AndroidAppProcess;
import com.jaredrummler.android.processes.models.AndroidProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ProcessManager {
    public static List<AndroidProcess> getRunningProcesses() {
        File[] files;
        ArrayList<AndroidProcess> processes = new ArrayList<AndroidProcess>();
        for (File file : files = new File("/proc").listFiles()) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                processes.add(new AndroidProcess(pid));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return processes;
    }

    public static List<AndroidAppProcess> getRunningAppProcesses() {
        File[] files;
        ArrayList<AndroidAppProcess> processes = new ArrayList<AndroidAppProcess>();
        for (File file : files = new File("/proc").listFiles()) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                processes.add(new AndroidAppProcess(pid));
            }
            catch (AndroidAppProcess.NotAndroidAppProcessException notAndroidAppProcessException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return processes;
    }

    public static List<AndroidAppProcess> getRunningForegroundApps(Context ctx) {
        ArrayList<AndroidAppProcess> processes = new ArrayList<AndroidAppProcess>();
        File[] files = new File("/proc").listFiles();
        PackageManager pm = ctx.getPackageManager();
        for (File file : files) {
            int pid;
            if (!file.isDirectory()) continue;
            try {
                pid = Integer.parseInt(file.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                AndroidAppProcess process = new AndroidAppProcess(pid);
                if (!process.foreground || process.uid >= 1000 && process.uid <= 9999 || process.name.contains(":") || pm.getLaunchIntentForPackage(process.getPackageName()) == null) continue;
                processes.add(new AndroidAppProcess(pid));
            }
            catch (AndroidAppProcess.NotAndroidAppProcessException notAndroidAppProcessException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return processes;
    }

    public static List<ActivityManager.RunningAppProcessInfo> getRunningAppProcessInfo(Context ctx) {
        if (Build.VERSION.SDK_INT >= 22) {
            List<AndroidAppProcess> runningAppProcesses = ProcessManager.getRunningAppProcesses();
            ArrayList<ActivityManager.RunningAppProcessInfo> appProcessInfos = new ArrayList<ActivityManager.RunningAppProcessInfo>();
            for (AndroidAppProcess process : runningAppProcesses) {
                ActivityManager.RunningAppProcessInfo info = new ActivityManager.RunningAppProcessInfo(process.name, process.pid, null);
                info.uid = process.uid;
                appProcessInfos.add(info);
            }
            return appProcessInfos;
        }
        ActivityManager am = (ActivityManager)ctx.getSystemService("activity");
        return am.getRunningAppProcesses();
    }
}

