/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.device;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.WorkerThread;
import com.jaredrummler.android.device.DeviceDatabase;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceName {
    private static final String SHARED_PREF_NAME = "device_names";
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;

    public static void init(Context context) {
        DeviceName.context = context.getApplicationContext();
    }

    public static Request with(Context context) {
        return new Request(context.getApplicationContext());
    }

    public static String getDeviceName() {
        return DeviceName.getDeviceName(Build.DEVICE, Build.MODEL, DeviceName.capitalize(Build.MODEL));
    }

    public static String getDeviceName(String codename, String fallback) {
        return DeviceName.getDeviceName(codename, codename, fallback);
    }

    public static String getDeviceName(String codename, String model, String fallback) {
        String marketName = DeviceName.getDeviceInfo((Context)DeviceName.context(), (String)codename, (String)model).marketName;
        return marketName == null ? fallback : marketName;
    }

    @WorkerThread
    public static DeviceInfo getDeviceInfo(Context context) {
        return DeviceName.getDeviceInfo(context.getApplicationContext(), Build.DEVICE, Build.MODEL);
    }

    @WorkerThread
    public static DeviceInfo getDeviceInfo(Context context, String codename) {
        return DeviceName.getDeviceInfo(context, codename, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public static DeviceInfo getDeviceInfo(Context context, String codename, String model) {
        SharedPreferences prefs = context.getSharedPreferences(SHARED_PREF_NAME, 0);
        String key = String.format("%s:%s", codename, model);
        String savedJson = prefs.getString(key, null);
        if (savedJson != null) {
            try {
                return new DeviceInfo(new JSONObject(savedJson));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        try (DeviceDatabase database = new DeviceDatabase(context);){
            DeviceInfo info = database.queryToDevice(codename, model);
            if (info != null) {
                JSONObject json = new JSONObject();
                json.put("manufacturer", (Object)info.manufacturer);
                json.put("codename", (Object)info.codename);
                json.put("model", (Object)info.model);
                json.put("market_name", (Object)info.marketName);
                SharedPreferences.Editor editor = prefs.edit();
                editor.putString(key, json.toString());
                editor.apply();
                DeviceInfo deviceInfo = info;
                return deviceInfo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!codename.equals(Build.DEVICE)) return new DeviceInfo(null, null, codename, model);
        if (!Build.MODEL.equals(model)) return new DeviceInfo(null, null, codename, model);
        return new DeviceInfo(Build.MANUFACTURER, codename, codename, model);
    }

    private static String capitalize(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        char[] arr = str.toCharArray();
        boolean capitalizeNext = true;
        StringBuilder phrase = new StringBuilder();
        for (char c : arr) {
            if (capitalizeNext && Character.isLetter(c)) {
                phrase.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                capitalizeNext = true;
            }
            phrase.append(c);
        }
        return phrase.toString();
    }

    @SuppressLint(value={"PrivateApi"})
    private static Context context() {
        if (context != null) {
            return context;
        }
        try {
            return (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            try {
                return (Application)Class.forName("android.app.AppGlobals").getMethod("getInitialApplication", new Class[0]).invoke(null, (Object[])null);
            }
            catch (Exception exception2) {
                throw new RuntimeException("DeviceName must be initialized before usage.");
            }
        }
    }

    public static final class DeviceInfo {
        @Deprecated
        public final String manufacturer;
        public final String marketName;
        public final String codename;
        public final String model;

        public DeviceInfo(String marketName, String codename, String model) {
            this(null, marketName, codename, model);
        }

        public DeviceInfo(String manufacturer, String marketName, String codename, String model) {
            this.manufacturer = manufacturer;
            this.marketName = marketName;
            this.codename = codename;
            this.model = model;
        }

        private DeviceInfo(JSONObject jsonObject) throws JSONException {
            this.manufacturer = jsonObject.getString("manufacturer");
            this.marketName = jsonObject.getString("market_name");
            this.codename = jsonObject.getString("codename");
            this.model = jsonObject.getString("model");
        }

        public String getName() {
            if (!TextUtils.isEmpty((CharSequence)this.marketName)) {
                return this.marketName;
            }
            return DeviceName.capitalize(this.model);
        }
    }

    public static interface Callback {
        public void onFinished(DeviceInfo var1, Exception var2);
    }

    public static final class Request {
        final Context context;
        final Handler handler;
        String codename;
        String model;

        private Request(Context ctx) {
            this.context = ctx;
            this.handler = new Handler(ctx.getMainLooper());
        }

        public Request setCodename(String codename) {
            this.codename = codename;
            return this;
        }

        public Request setModel(String model) {
            this.model = model;
            return this;
        }

        public void request(Callback callback) {
            if (this.codename == null && this.model == null) {
                this.codename = Build.DEVICE;
                this.model = Build.MODEL;
            }
            GetDeviceRunnable runnable = new GetDeviceRunnable(callback);
            if (Looper.myLooper() == Looper.getMainLooper()) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }

        private final class GetDeviceRunnable
        implements Runnable {
            final Callback callback;
            DeviceInfo deviceInfo;
            Exception error;

            GetDeviceRunnable(Callback callback) {
                this.callback = callback;
            }

            @Override
            public void run() {
                try {
                    this.deviceInfo = DeviceName.getDeviceInfo(Request.this.context, Request.this.codename, Request.this.model);
                }
                catch (Exception e) {
                    this.error = e;
                }
                Request.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        GetDeviceRunnable.this.callback.onFinished(GetDeviceRunnable.this.deviceInfo, GetDeviceRunnable.this.error);
                    }
                });
            }
        }
    }
}

