package com.jamonapi;

import java.util.*;
import com.jamonapi.utils.*;

public class JAMonListenerFactory {
	private static String[] HEADER={"ListenerName", "Listener"};
	private static Map map=Misc.createCaseInsensitiveMap();
	
	static {
		JAMonListener factoryInstance=new JAMonBufferListener();
		put(factoryInstance);
	}
	
	/** Developers may register their own listeners to be made available for use in JAMon */
	public static void put(JAMonListener jamonListener) {
		map.put(jamonListener.getName(), jamonListener);
	}
	
	/** Returns an array of all registered JAMonListeners in the format: key, JamonListener factory instance */
	public static Object[][] getData() {
		Iterator iter=map.entrySet().iterator();
		Object[][] data=new Object[map.size()][];
		
		int i=0;
		while (iter.hasNext()) {
			data[i]=new Object[2];
			Map.Entry entry=(Map.Entry) iter.next();
			data[i][0]=entry.getKey();
			data[i][1]=entry.getValue();
			i++;
		}
		
		return data;
	}
	
	public static String[] getHeader() {
		return HEADER;
	}
	
	/** Get an instance of the named factory instance.  If the Liistener implements 
	 * CopyJAMonListener then copy will be called.  If not then the default constructor will
	 * be called.
	 * 
	 * @param listenerName
	 * @return
	 */
	public static JAMonListener get(String listenerName) {
		try {
		 JAMonListener factoryInstance =(JAMonListener)map.get(listenerName);
		 if (factoryInstance instanceof CopyJAMonListener) {
			 return ((CopyJAMonListener)factoryInstance).copy();
		 }  else {
		   JAMonListener newInst = (JAMonListener)factoryInstance.getClass().newInstance(); 
		   newInst.setName(factoryInstance.getName());
		   return newInst;
		 }
		 
		} catch (Exception e) {
			throw new RuntimeException("Error getting listener from factory: "+listenerName+", "+e);
		}
		
	}
	
	
	
	public static void main(String[] args) {
		put(new CompositeListener("tester"));
		put(new JAMonBufferListener("helloListener", new BufferList(new String[]{"hey"},200)));
		String[] header=getHeader();
		Object[][] data=getData();
		for (int i=0;i<data.length;i++)
			for (int j=0;j<data[i].length;j++)
				System.out.println(header[j]+"="+data[i][j]);
		
		System.out.println("\ngetting listener="+get("JAMonBufferListener"));
		JAMonBufferListener jbl=(JAMonBufferListener)get("helloListener");
		System.out.println("name="+jbl.getName()+", buffer="+jbl.getBufferList().getBufferSize());

	}

}
