/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxrelay2;

import com.jakewharton.rxrelay2.AppendOnlyLinkedArrayList;
import com.jakewharton.rxrelay2.Relay;
import io.reactivex.Observer;

final class SerializedRelay<T>
extends Relay<T> {
    private final Relay<T> actual;
    private boolean emitting;
    private AppendOnlyLinkedArrayList<T> queue;

    SerializedRelay(Relay<T> actual) {
        this.actual = actual;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        this.actual.subscribe(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T value) {
        SerializedRelay serializedRelay = this;
        synchronized (serializedRelay) {
            if (this.emitting) {
                AppendOnlyLinkedArrayList<T> q = this.queue;
                if (q == null) {
                    q = new AppendOnlyLinkedArrayList(4);
                    this.queue = q;
                }
                q.add(value);
                return;
            }
            this.emitting = true;
        }
        this.actual.accept(value);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitLoop() {
        while (true) {
            AppendOnlyLinkedArrayList<T> q;
            SerializedRelay serializedRelay = this;
            synchronized (serializedRelay) {
                q = this.queue;
                if (q == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            q.accept(this.actual);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.actual.hasObservers();
    }
}

