/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding4.recyclerview;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.jakewharton.rxbinding4.internal.Preconditions;
import com.jakewharton.rxbinding4.recyclerview.RecyclerViewChildAttachEvent;
import com.jakewharton.rxbinding4.recyclerview.RecyclerViewChildAttachStateChangeEvent;
import com.jakewharton.rxbinding4.recyclerview.RecyclerViewChildDetachEvent;
import io.reactivex.rxjava3.android.MainThreadDisposable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jakewharton/rxbinding4/recyclerview/RecyclerViewChildAttachStateChangeEventObservable;", "Lio/reactivex/rxjava3/core/Observable;", "Lcom/jakewharton/rxbinding4/recyclerview/RecyclerViewChildAttachStateChangeEvent;", "view", "Landroidx/recyclerview/widget/RecyclerView;", "(Landroidx/recyclerview/widget/RecyclerView;)V", "subscribeActual", "", "observer", "Lio/reactivex/rxjava3/core/Observer;", "Listener", "rxbinding-recyclerview_release"})
final class RecyclerViewChildAttachStateChangeEventObservable
extends Observable<RecyclerViewChildAttachStateChangeEvent> {
    private final RecyclerView view;

    protected void subscribeActual(@NotNull Observer<? super RecyclerViewChildAttachStateChangeEvent> observer) {
        Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)listener);
    }

    public RecyclerViewChildAttachStateChangeEventObservable(@NotNull RecyclerView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.view = view;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jakewharton/rxbinding4/recyclerview/RecyclerViewChildAttachStateChangeEventObservable$Listener;", "Lio/reactivex/rxjava3/android/MainThreadDisposable;", "Landroidx/recyclerview/widget/RecyclerView$OnChildAttachStateChangeListener;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "observer", "Lio/reactivex/rxjava3/core/Observer;", "Lcom/jakewharton/rxbinding4/recyclerview/RecyclerViewChildAttachStateChangeEvent;", "(Landroidx/recyclerview/widget/RecyclerView;Lio/reactivex/rxjava3/core/Observer;)V", "onChildViewAttachedToWindow", "", "childView", "Landroid/view/View;", "onChildViewDetachedFromWindow", "onDispose", "rxbinding-recyclerview_release"})
    public static final class Listener
    extends MainThreadDisposable
    implements RecyclerView.OnChildAttachStateChangeListener {
        private final RecyclerView recyclerView;
        private final Observer<? super RecyclerViewChildAttachStateChangeEvent> observer;

        public void onChildViewAttachedToWindow(@NotNull View childView) {
            Intrinsics.checkParameterIsNotNull((Object)childView, (String)"childView");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new RecyclerViewChildAttachEvent(this.recyclerView, childView));
            }
        }

        public void onChildViewDetachedFromWindow(@NotNull View childView) {
            Intrinsics.checkParameterIsNotNull((Object)childView, (String)"childView");
            if (!this.isDisposed()) {
                this.observer.onNext((Object)new RecyclerViewChildDetachEvent(this.recyclerView, childView));
            }
        }

        protected void onDispose() {
            this.recyclerView.removeOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this);
        }

        public Listener(@NotNull RecyclerView recyclerView, @NotNull Observer<? super RecyclerViewChildAttachStateChangeEvent> observer) {
            Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
            Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
            this.recyclerView = recyclerView;
            this.observer = observer;
        }
    }
}

